/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.snodge.mutagens;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.natpryce.snodge.DocumentMutation;
import com.natpryce.snodge.JsonPath;
import com.natpryce.snodge.Mutagen;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class AddObjectProperty
implements Mutagen,
Function<JsonElement, JsonElement> {
    private final JsonElement newElement;

    public AddObjectProperty(JsonElement newElement) {
        this.newElement = newElement;
    }

    @Override
    public Stream<DocumentMutation> potentialMutations(JsonElement document, JsonPath pathToElement, JsonElement elementToMutate) {
        if (elementToMutate.isJsonObject()) {
            return Stream.of(pathToElement.map(this));
        }
        return Stream.empty();
    }

    @Override
    public JsonElement apply(JsonElement original) {
        JsonObject mutated = new JsonObject();
        Set entries = original.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            mutated.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
        mutated.add(this.newProperty(mutated), this.newElement);
        return mutated;
    }

    private String newProperty(JsonObject thingy) {
        String newPropertyName = "x";
        while (thingy.has(newPropertyName)) {
            newPropertyName = newPropertyName + "x";
        }
        return newPropertyName;
    }
}

