/*
 * Decompiled with CFR 0.152.
 */
package com.natpryce.snodge.mutagens;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.natpryce.snodge.DocumentMutation;
import com.natpryce.snodge.JsonPath;
import com.natpryce.snodge.Mutagen;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class ReorderObjectProperties
implements Mutagen,
Function<JsonElement, JsonElement> {
    @Override
    public Stream<DocumentMutation> potentialMutations(JsonElement document, JsonPath pathToElement, JsonElement elementToMutate) {
        if (elementToMutate.isJsonObject()) {
            return Stream.of(pathToElement.map(this));
        }
        return Stream.empty();
    }

    @Override
    public JsonElement apply(JsonElement element) {
        ArrayList objectProperties = new ArrayList(element.getAsJsonObject().entrySet());
        Collections.shuffle(objectProperties);
        JsonObject mutant = new JsonObject();
        for (Map.Entry property : objectProperties) {
            mutant.add((String)property.getKey(), (JsonElement)property.getValue());
        }
        return mutant;
    }
}

