/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public final class AddrUtil {
    private AddrUtil() {
    }

    public static List<InetSocketAddress> getAddresses(String s) {
        if (s == null) {
            throw new NullPointerException("Null host list");
        }
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        if (s.trim().equals("")) {
            return addrs;
        }
        for (String hoststuff : s.split("(?:\\s|,)+")) {
            if (hoststuff.equals("")) continue;
            int finalColon = hoststuff.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server ``" + hoststuff + "'' in list:  " + s);
            }
            String hostPart = hoststuff.substring(0, finalColon);
            String portNum = hoststuff.substring(finalColon + 1);
            addrs.add(new InetSocketAddress(hostPart, Integer.parseInt(portNum)));
        }
        assert (!addrs.isEmpty()) : "No addrs found";
        return addrs;
    }
}

