/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.Manifest;
import net.spy.memcached.ArcusClientIF;
import net.spy.memcached.ArcusClientPool;
import net.spy.memcached.ArcusMBeanServer;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.CacheManager;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.PartitionedList;
import net.spy.memcached.PartitionedMap;
import net.spy.memcached.StatisticsHandler;
import net.spy.memcached.collection.Attributes;
import net.spy.memcached.collection.BKeyObject;
import net.spy.memcached.collection.BTreeCount;
import net.spy.memcached.collection.BTreeCreate;
import net.spy.memcached.collection.BTreeDelete;
import net.spy.memcached.collection.BTreeElement;
import net.spy.memcached.collection.BTreeFindPosition;
import net.spy.memcached.collection.BTreeFindPositionWithGet;
import net.spy.memcached.collection.BTreeGet;
import net.spy.memcached.collection.BTreeGetBulk;
import net.spy.memcached.collection.BTreeGetBulkWithByteTypeBkey;
import net.spy.memcached.collection.BTreeGetBulkWithLongTypeBkey;
import net.spy.memcached.collection.BTreeGetByPosition;
import net.spy.memcached.collection.BTreeGetResult;
import net.spy.memcached.collection.BTreeInsert;
import net.spy.memcached.collection.BTreeInsertAndGet;
import net.spy.memcached.collection.BTreeMutate;
import net.spy.memcached.collection.BTreeOrder;
import net.spy.memcached.collection.BTreeSMGet;
import net.spy.memcached.collection.BTreeSMGetWithByteTypeBkey;
import net.spy.memcached.collection.BTreeSMGetWithByteTypeBkeyOld;
import net.spy.memcached.collection.BTreeSMGetWithLongTypeBkey;
import net.spy.memcached.collection.BTreeSMGetWithLongTypeBkeyOld;
import net.spy.memcached.collection.BTreeUpdate;
import net.spy.memcached.collection.BTreeUpsert;
import net.spy.memcached.collection.ByteArrayBKey;
import net.spy.memcached.collection.ByteArrayTreeMap;
import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.CollectionBulkInsert;
import net.spy.memcached.collection.CollectionCount;
import net.spy.memcached.collection.CollectionCreate;
import net.spy.memcached.collection.CollectionDelete;
import net.spy.memcached.collection.CollectionExist;
import net.spy.memcached.collection.CollectionGet;
import net.spy.memcached.collection.CollectionInsert;
import net.spy.memcached.collection.CollectionMutate;
import net.spy.memcached.collection.CollectionPipedInsert;
import net.spy.memcached.collection.CollectionPipedUpdate;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.collection.CollectionUpdate;
import net.spy.memcached.collection.Element;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.collection.ElementFlagUpdate;
import net.spy.memcached.collection.ElementValueType;
import net.spy.memcached.collection.ListCreate;
import net.spy.memcached.collection.ListDelete;
import net.spy.memcached.collection.ListGet;
import net.spy.memcached.collection.ListInsert;
import net.spy.memcached.collection.MapCreate;
import net.spy.memcached.collection.MapDelete;
import net.spy.memcached.collection.MapGet;
import net.spy.memcached.collection.MapInsert;
import net.spy.memcached.collection.MapUpdate;
import net.spy.memcached.collection.SMGetElement;
import net.spy.memcached.collection.SMGetMode;
import net.spy.memcached.collection.SMGetTrimKey;
import net.spy.memcached.collection.SetCreate;
import net.spy.memcached.collection.SetDelete;
import net.spy.memcached.collection.SetExist;
import net.spy.memcached.collection.SetGet;
import net.spy.memcached.collection.SetInsert;
import net.spy.memcached.collection.SetPipedExist;
import net.spy.memcached.compat.log.Logger;
import net.spy.memcached.compat.log.LoggerFactory;
import net.spy.memcached.internal.BTreeStoreAndGetFuture;
import net.spy.memcached.internal.BulkOperationFuture;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.internal.CollectionFuture;
import net.spy.memcached.internal.CollectionGetBulkFuture;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.internal.SMGetFuture;
import net.spy.memcached.ops.BTreeFindPositionOperation;
import net.spy.memcached.ops.BTreeFindPositionWithGetOperation;
import net.spy.memcached.ops.BTreeGetBulkOperation;
import net.spy.memcached.ops.BTreeGetByPositionOperation;
import net.spy.memcached.ops.BTreeInsertAndGetOperation;
import net.spy.memcached.ops.BTreeSortMergeGetOperation;
import net.spy.memcached.ops.BTreeSortMergeGetOperationOld;
import net.spy.memcached.ops.CollectionBulkInsertOperation;
import net.spy.memcached.ops.CollectionCountOperation;
import net.spy.memcached.ops.CollectionCreateOperation;
import net.spy.memcached.ops.CollectionDeleteOperation;
import net.spy.memcached.ops.CollectionExistOperation;
import net.spy.memcached.ops.CollectionGetOperation;
import net.spy.memcached.ops.CollectionInsertOperation;
import net.spy.memcached.ops.CollectionMutateOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.CollectionPipedExistOperation;
import net.spy.memcached.ops.CollectionPipedInsertOperation;
import net.spy.memcached.ops.CollectionPipedUpdateOperation;
import net.spy.memcached.ops.CollectionUpdateOperation;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.FlushOperation;
import net.spy.memcached.ops.GetAttrOperation;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.SetAttrOperation;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.plugin.FrontCacheMemcachedClient;
import net.spy.memcached.transcoders.CollectionTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.util.BTreeUtil;

public class ArcusClient
extends FrontCacheMemcachedClient
implements ArcusClientIF {
    private static String VERSION;
    private static final Logger arcusLogger;
    private static final String ARCUS_CLOUD_ADDR = "127.0.0.1:2181";
    private static final String DEFAULT_ARCUS_CLIENT_NAME = "ArcusClient";
    private boolean dead;
    private final Transcoder<Object> collectionTranscoder = new CollectionTranscoder();
    private final int smgetKeyChunkSize;
    private static final int BOPGET_BULK_CHUNK_SIZE = 200;
    private static final int NON_PIPED_BULK_INSERT_CHUNK_SIZE = 500;
    private static final int MAX_GETBULK_ELEMENT_COUNT = 50;
    private static final int MAX_SMGET_COUNT = 1000;
    private static final int MAX_MKEY_LENGTH = 250;
    private CacheManager cacheManager;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public static ArcusClient createArcusClient(String hostPorts, String serviceCode, ConnectionFactoryBuilder cfb) {
        return ArcusClient.createArcusClient(hostPorts, serviceCode, cfb, 1, 10000).getClient();
    }

    public static ArcusClient createArcusClient(String serviceCode, ConnectionFactoryBuilder cfb) {
        return ArcusClient.createArcusClient(ARCUS_CLOUD_ADDR, serviceCode, cfb, 1, 10000).getClient();
    }

    public static ArcusClientPool createArcusClientPool(String hostPorts, String serviceCode, ConnectionFactoryBuilder cfb, int poolSize) {
        return ArcusClient.createArcusClient(hostPorts, serviceCode, cfb, poolSize, 0);
    }

    public static ArcusClientPool createArcusClientPool(String serviceCode, ConnectionFactoryBuilder cfb, int poolSize) {
        return ArcusClient.createArcusClient(ARCUS_CLOUD_ADDR, serviceCode, cfb, poolSize, 0);
    }

    private static ArcusClientPool createArcusClient(String hostPorts, String serviceCode, ConnectionFactoryBuilder cfb, int poolSize, int waitTimeForConnect) {
        if (hostPorts == null) {
            throw new NullPointerException("Arcus admin address required.");
        }
        if (serviceCode == null) {
            throw new NullPointerException("Service code required.");
        }
        if (hostPorts.isEmpty()) {
            throw new IllegalArgumentException("Arcus admin address is empty.");
        }
        if (serviceCode.isEmpty()) {
            throw new IllegalArgumentException("Service code is empty.");
        }
        CountDownLatch latch = new CountDownLatch(1);
        CacheManager exe = new CacheManager(hostPorts, serviceCode, cfb, latch, poolSize, waitTimeForConnect);
        try {
            latch.await();
        }
        catch (Exception e) {
            arcusLogger.warn("you cannot see this message!");
        }
        ArcusClient[] client = exe.getAC();
        return new ArcusClientPool(poolSize, client);
    }

    protected static ArcusClient getInstance(ConnectionFactory cf, String name, List<InetSocketAddress> addrs) throws IOException {
        return new ArcusClient(cf, name, addrs);
    }

    public ArcusClient(ConnectionFactory cf, String name, List<InetSocketAddress> addrs) throws IOException {
        super(cf, name, addrs);
        this.smgetKeyChunkSize = cf.getDefaultMaxSMGetKeyChunkSize();
        this.registerMbean();
    }

    public ArcusClient(ConnectionFactory cf, List<InetSocketAddress> addrs) throws IOException {
        super(cf, DEFAULT_ARCUS_CLIENT_NAME, addrs);
        this.smgetKeyChunkSize = cf.getDefaultMaxSMGetKeyChunkSize();
        this.registerMbean();
    }

    private void registerMbean() {
        if ("false".equals(System.getProperty("arcus.mbean", "false").toLowerCase())) {
            this.getLogger().info("Arcus client statistics MBean is NOT registered.");
            return;
        }
        try {
            StatisticsHandler mbean = new StatisticsHandler(this);
            ArcusMBeanServer.getInstance().registMBean(mbean, mbean.getClass().getPackage().getName() + ":type=" + mbean.getClass().getSimpleName() + "-" + mbean.hashCode());
            this.getLogger().info("Arcus client statistics MBean is registered.");
        }
        catch (Exception e) {
            this.getLogger().warn((Object)"Failed to initialize statistics mbean.", e);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
        }
        this.dead = true;
    }

    private void validateMKey(String mkey) {
        byte[] keyBytes = KeyUtil.getKeyBytes(mkey);
        if (keyBytes.length > 250) {
            throw new IllegalArgumentException("MKey is too long (maxlen = 250)");
        }
        if (keyBytes.length == 0) {
            throw new IllegalArgumentException("MKey must contain at least one character.");
        }
        for (byte b : keyBytes) {
            if (b != 32 && b != 10 && b != 13 && b != 0) continue;
            throw new IllegalArgumentException("MKey contains invalid characters:  ``" + mkey + "''");
        }
    }

    Future<Boolean> asyncStore(StoreType storeType, String key, int exp, CachedData co) {
        final CountDownLatch latch = new CountDownLatch(1);
        final OperationFuture<Boolean> rv = new OperationFuture<Boolean>(latch, this.operationTimeout);
        StoreOperation op = this.opFact.store(storeType, key, co.getFlags(), exp, co.getData(), new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus val) {
                rv.set(val.isSuccess(), val);
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    @Override
    public CollectionFuture<Boolean> asyncSetAttr(String key, Attributes attrs) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Boolean> rv = new CollectionFuture<Boolean>(latch, this.operationTimeout);
        SetAttrOperation op = this.opFact.setAttr(key, attrs, new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                if (status instanceof CollectionOperationStatus) {
                    rv.set(status.isSuccess(), (CollectionOperationStatus)status);
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    rv.set(status.isSuccess(), new CollectionOperationStatus(status));
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    @Override
    public CollectionFuture<CollectionAttributes> asyncGetAttr(final String key) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<CollectionAttributes> rv = new CollectionFuture<CollectionAttributes>(latch, this.operationTimeout);
        GetAttrOperation op = this.opFact.getAttr(key, new GetAttrOperation.Callback(){
            private final CollectionAttributes attrs = new CollectionAttributes();

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus stat = status instanceof CollectionOperationStatus ? (CollectionOperationStatus)status : new CollectionOperationStatus(status);
                rv.set(stat.isSuccess() ? this.attrs : null, stat);
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotAttribute(String k, String attr) {
                assert (key.equals(k)) : "Wrong key returned";
                this.attrs.setAttribute(attr);
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    private <T> CollectionFuture<List<T>> asyncLopGet(final String k, CollectionGet collectionGet, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<List<T>> rv = new CollectionFuture<List<T>>(latch, this.operationTimeout);
        CollectionGetOperation op = this.opFact.collectionGet(k, collectionGet, new CollectionGetOperation.Callback(){
            private final List<T> list = new ArrayList();

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(this.list, cstatus);
                    return;
                }
                switch (cstatus.getResponse()) {
                    case NOT_FOUND: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case NOT_FOUND_ELEMENT: {
                        rv.set(this.list, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case OUT_OF_RANGE: {
                        rv.set(this.list, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) not found in condition : %s", k, cstatus);
                        break;
                    }
                    case UNREADABLE: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) is not readable : %s", k, cstatus);
                        break;
                    }
                    default: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) unknown status : %s", k, cstatus);
                    }
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotData(String key, String subkey, int flags, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                this.list.add(tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncSopExist(String key, T value, Transcoder<T> tc) {
        SetExist<T> exist = new SetExist<T>(value, tc);
        return this.asyncCollectionExist(key, "", exist, tc);
    }

    @Override
    public CollectionFuture<Boolean> asyncSopExist(String key, Object value) {
        SetExist<Object> exist = new SetExist<Object>(value, this.collectionTranscoder);
        return this.asyncCollectionExist(key, "", exist, this.collectionTranscoder);
    }

    private <T> CollectionFuture<Set<T>> asyncSopGet(final String k, CollectionGet collectionGet, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Set<T>> rv = new CollectionFuture<Set<T>>(latch, this.operationTimeout);
        CollectionGetOperation op = this.opFact.collectionGet(k, collectionGet, new CollectionGetOperation.Callback(){
            private final Set<T> set = new HashSet();

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(this.set, cstatus);
                    return;
                }
                switch (cstatus.getResponse()) {
                    case NOT_FOUND: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case NOT_FOUND_ELEMENT: {
                        rv.set(this.set, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case UNREADABLE: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) is not readable : %s", k, cstatus);
                        break;
                    }
                    default: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) unknown status : %s", k, cstatus);
                    }
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotData(String key, String subkey, int flags, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                this.set.add(tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    private <T> CollectionFuture<Map<Long, Element<T>>> asyncBopGet(final String k, final CollectionGet collectionGet, final boolean reverse, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Map<Long, Element<T>>> rv = new CollectionFuture<Map<Long, Element<T>>>(latch, this.operationTimeout);
        CollectionGetOperation op = this.opFact.collectionGet(k, collectionGet, new CollectionGetOperation.Callback(){
            private final TreeMap<Long, Element<T>> map;
            {
                this.map = new TreeMap(reverse ? Collections.reverseOrder() : null);
            }

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(this.map, cstatus);
                    return;
                }
                switch (cstatus.getResponse()) {
                    case NOT_FOUND: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case NOT_FOUND_ELEMENT: {
                        rv.set(this.map, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case UNREADABLE: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) is not readable : %s", k, cstatus);
                        break;
                    }
                    default: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) Unknown response : %s", k, cstatus);
                    }
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotData(String key, String subkey, int flags, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                long longSubkey = Long.parseLong(subkey);
                this.map.put(longSubkey, new Element(longSubkey, tc.decode(new CachedData(flags, data, tc.getMaxSize())), collectionGet.getElementFlag()));
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    private <T> CollectionFuture<Map<String, T>> asyncMopGet(final String k, CollectionGet collectionGet, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Map<String, T>> rv = new CollectionFuture<Map<String, T>>(latch, this.operationTimeout);
        CollectionGetOperation op = this.opFact.collectionGet(k, collectionGet, new CollectionGetOperation.Callback(){
            private final HashMap<String, T> map = new HashMap();

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(this.map, cstatus);
                    return;
                }
                switch (cstatus.getResponse()) {
                    case NOT_FOUND: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case NOT_FOUND_ELEMENT: {
                        rv.set(this.map, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case UNREADABLE: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) is not readable : %s", k, cstatus);
                        break;
                    }
                    default: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) Unknown response : %s", k, cstatus);
                    }
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotData(String key, String subkey, int flags, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                this.map.put(subkey, tc.decode(new CachedData(flags, data, tc.getMaxSize())));
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    private <T> CollectionFuture<Boolean> asyncCollectionInsert(String key, String subkey, CollectionInsert<T> collectionInsert, Transcoder<T> tc) {
        CachedData co = tc.encode(collectionInsert.getValue());
        collectionInsert.setFlags(co.getFlags());
        return this.asyncCollectionInsert(key, subkey, collectionInsert, co);
    }

    <T> CollectionFuture<Boolean> asyncCollectionInsert(final String key, final String subkey, final CollectionInsert<T> collectionInsert, CachedData co) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Boolean> rv = new CollectionFuture<Boolean>(latch, this.operationTimeout);
        CollectionInsertOperation op = this.opFact.collectionInsert(key, subkey, collectionInsert, co.getData(), new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                rv.set(cstatus.isSuccess(), cstatus);
                if (!cstatus.isSuccess() && ArcusClient.this.getLogger().isDebugEnabled()) {
                    ArcusClient.this.getLogger().debug("Insertion to the collection failed : " + cstatus.getMessage() + " (type=" + collectionInsert.getClass().getName() + ", key=" + key + ", subkey=" + subkey + ", value=" + collectionInsert.getValue() + ")");
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncCollectionPipedInsert(String key, CollectionPipedInsert<T> insert) {
        if (insert.getItemCount() == 0) {
            throw new IllegalArgumentException("The number of piped operations must be larger than 0.");
        }
        if (insert.getItemCount() > 500) {
            throw new IllegalArgumentException("The number of piped operations must not exceed a maximum of 500.");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Map<Integer, CollectionOperationStatus>> rv = new CollectionFuture<Map<Integer, CollectionOperationStatus>>(latch, this.operationTimeout);
        CollectionPipedInsertOperation op = this.opFact.collectionPipedInsert(key, insert, new CollectionPipedInsertOperation.Callback(){
            private final Map<Integer, CollectionOperationStatus> result = new TreeMap<Integer, CollectionOperationStatus>();

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                rv.set(this.result, cstatus);
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotStatus(Integer index, OperationStatus status) {
                if (status instanceof CollectionOperationStatus) {
                    this.result.put(index, (CollectionOperationStatus)status);
                } else {
                    this.result.put(index, new CollectionOperationStatus(status));
                }
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncCollectionPipedUpdate(String key, CollectionPipedUpdate<T> update) {
        if (update.getItemCount() == 0) {
            throw new IllegalArgumentException("The number of piped operations must be larger than 0.");
        }
        if (update.getItemCount() > 500) {
            throw new IllegalArgumentException("The number of piped operations must not exceed a maximum of 500.");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Map<Integer, CollectionOperationStatus>> rv = new CollectionFuture<Map<Integer, CollectionOperationStatus>>(latch, this.operationTimeout);
        CollectionPipedUpdateOperation op = this.opFact.collectionPipedUpdate(key, update, new CollectionPipedUpdateOperation.Callback(){
            private final Map<Integer, CollectionOperationStatus> result = new TreeMap<Integer, CollectionOperationStatus>();

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                rv.set(this.result, cstatus);
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotStatus(Integer index, OperationStatus status) {
                if (status instanceof CollectionOperationStatus) {
                    this.result.put(index, (CollectionOperationStatus)status);
                } else {
                    this.result.put(index, new CollectionOperationStatus(status));
                }
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncCollectionPipedUpdate(String key, List<CollectionPipedUpdate<T>> updateList) {
        final ConcurrentLinkedQueue<CollectionPipedUpdateOperation> ops = new ConcurrentLinkedQueue<CollectionPipedUpdateOperation>();
        final CountDownLatch latch = new CountDownLatch(updateList.size());
        final List mergedOperationStatus = Collections.synchronizedList(new ArrayList(1));
        final ConcurrentHashMap mergedResult = new ConcurrentHashMap();
        int i = 0;
        while (i < updateList.size()) {
            CollectionPipedUpdate<T> update = updateList.get(i);
            final int idx = i++;
            CollectionPipedUpdateOperation op = this.opFact.collectionPipedUpdate(key, update, new CollectionPipedUpdateOperation.Callback(){

                @Override
                public void receivedStatus(OperationStatus status) {
                    CollectionOperationStatus cstatus;
                    if (status instanceof CollectionOperationStatus) {
                        cstatus = (CollectionOperationStatus)status;
                    } else {
                        ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                        cstatus = new CollectionOperationStatus(status);
                    }
                    mergedOperationStatus.add(cstatus);
                }

                @Override
                public void complete() {
                    latch.countDown();
                }

                @Override
                public void gotStatus(Integer index, OperationStatus status) {
                    if (status instanceof CollectionOperationStatus) {
                        mergedResult.put(index + idx * 500, (CollectionOperationStatus)status);
                    } else {
                        mergedResult.put(index + idx * 500, new CollectionOperationStatus(status));
                    }
                }
            });
            this.addOp(key, op);
            ops.add(op);
        }
        return new CollectionFuture<Map<Integer, CollectionOperationStatus>>(latch, this.operationTimeout){

            @Override
            public boolean cancel(boolean ign) {
                boolean rv = false;
                for (Operation op : ops) {
                    op.cancel("by application.");
                    rv |= op.getState() == OperationState.WRITE_QUEUED;
                }
                return rv;
            }

            @Override
            public boolean isCancelled() {
                for (Operation op : ops) {
                    if (!op.isCancelled()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map<Integer, CollectionOperationStatus> get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
                if (!this.latch.await(duration, units)) {
                    for (Operation op : ops) {
                        MemcachedConnection.opTimedOut(op);
                    }
                    throw new CheckedOperationTimeoutException("Timed out waiting for operation >" + duration + " " + (Object)((Object)units), ops);
                }
                for (Operation op : ops) {
                    MemcachedConnection.opSucceeded(op);
                }
                for (Operation op : ops) {
                    if (op != null && op.hasErrored()) {
                        throw new ExecutionException(op.getException());
                    }
                    if (op == null || !op.isCancelled()) continue;
                    throw new ExecutionException(new RuntimeException(op.getCancelCause()));
                }
                return mergedResult;
            }

            @Override
            public CollectionOperationStatus getOperationStatus() {
                for (OperationStatus status : mergedOperationStatus) {
                    if (status.isSuccess()) continue;
                    return new CollectionOperationStatus(status);
                }
                return new CollectionOperationStatus(true, "END", CollectionResponse.END);
            }

            @Override
            public boolean isDone() {
                for (Operation op : ops) {
                    if (op.getState() == OperationState.COMPLETE || op.isCancelled()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private CollectionFuture<Boolean> asyncCollectionDelete(final String key, final CollectionDelete collectionDelete) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Boolean> rv = new CollectionFuture<Boolean>(latch, this.operationTimeout);
        CollectionDeleteOperation op = this.opFact.collectionDelete(key, collectionDelete, new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                rv.set(cstatus.isSuccess(), cstatus);
                if (!cstatus.isSuccess() && ArcusClient.this.getLogger().isDebugEnabled()) {
                    ArcusClient.this.getLogger().debug("Deletion to the collection failed : " + cstatus.getMessage() + " (type=" + collectionDelete.getClass().getName() + ", key=" + key + ")");
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    private <T> CollectionFuture<Boolean> asyncCollectionExist(final String key, final String subkey, final CollectionExist collectionExist, Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Boolean> rv = new CollectionFuture<Boolean>(latch, this.operationTimeout);
        CollectionExistOperation op = this.opFact.collectionExist(key, subkey, collectionExist, new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                boolean isExist = CollectionResponse.EXIST == cstatus.getResponse();
                rv.set(isExist, cstatus);
                if (!cstatus.isSuccess() && ArcusClient.this.getLogger().isDebugEnabled()) {
                    ArcusClient.this.getLogger().debug("Exist command to the collection failed : " + cstatus.getMessage() + " (type=" + collectionExist.getClass().getName() + ", key=" + key + ", subkey=" + subkey + ")");
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    @Override
    @Deprecated
    public <T> Future<Map<String, CollectionOperationStatus>> asyncSetBulk(List<String> key, final int exp, T o, Transcoder<T> tc) {
        if (key == null) {
            throw new IllegalArgumentException("Key list is null.");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key list is empty.");
        }
        final CachedData co = this.transcoder.encode(o);
        final CountDownLatch blatch = new CountDownLatch(key.size());
        return new BulkOperationFuture<CollectionOperationStatus>(key, blatch, this.operationTimeout){

            @Override
            public Operation createOp(final String k) {
                StoreOperation op = ArcusClient.this.opFact.store(StoreType.set, k, co.getFlags(), exp, co.getData(), new OperationCallback(){

                    @Override
                    public void receivedStatus(OperationStatus val) {
                        if (!val.isSuccess()) {
                            failedResult.put(k, new CollectionOperationStatus(false, String.valueOf(val.isSuccess()), CollectionResponse.END));
                        }
                    }

                    @Override
                    public void complete() {
                        blatch.countDown();
                    }
                });
                ArcusClient.this.addOp(k, op);
                return op;
            }
        };
    }

    @Override
    @Deprecated
    public Future<Map<String, CollectionOperationStatus>> asyncSetBulk(List<String> key, int exp, Object o) {
        return this.asyncSetBulk(key, exp, o, this.transcoder);
    }

    @Override
    @Deprecated
    public <T> Future<Map<String, CollectionOperationStatus>> asyncSetBulk(final Map<String, T> o, final int exp, Transcoder<T> tc) {
        if (o == null) {
            throw new IllegalArgumentException("Map is null.");
        }
        if (o.isEmpty()) {
            throw new IllegalArgumentException("Map is empty.");
        }
        final CountDownLatch blatch = new CountDownLatch(o.size());
        return new BulkOperationFuture<CollectionOperationStatus>(o.keySet(), blatch, this.operationTimeout){

            @Override
            public Operation createOp(final String k) {
                CachedData co = ArcusClient.this.transcoder.encode(o.get(k));
                StoreOperation op = ArcusClient.this.opFact.store(StoreType.set, k, co.getFlags(), exp, co.getData(), new OperationCallback(){

                    @Override
                    public void receivedStatus(OperationStatus val) {
                        if (!val.isSuccess()) {
                            failedResult.put(k, new CollectionOperationStatus(false, String.valueOf(val.isSuccess()), CollectionResponse.END));
                        }
                    }

                    @Override
                    public void complete() {
                        blatch.countDown();
                    }
                });
                ArcusClient.this.addOp(k, op);
                return op;
            }
        };
    }

    @Override
    @Deprecated
    public Future<Map<String, CollectionOperationStatus>> asyncSetBulk(Map<String, Object> o, int exp) {
        return this.asyncSetBulk(o, exp, this.transcoder);
    }

    @Override
    public <T> Future<Map<String, OperationStatus>> asyncStoreBulk(final StoreType type, List<String> key, final int exp, T o, Transcoder<T> tc) {
        if (key == null) {
            throw new IllegalArgumentException("Key list is null.");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key list is empty.");
        }
        final CachedData co = this.transcoder.encode(o);
        final CountDownLatch blatch = new CountDownLatch(key.size());
        return new BulkOperationFuture<OperationStatus>(key, blatch, this.operationTimeout){

            @Override
            public Operation createOp(final String k) {
                StoreOperation op = ArcusClient.this.opFact.store(type, k, co.getFlags(), exp, co.getData(), new OperationCallback(){

                    @Override
                    public void receivedStatus(OperationStatus val) {
                        if (!val.isSuccess()) {
                            failedResult.put(k, val);
                        }
                    }

                    @Override
                    public void complete() {
                        blatch.countDown();
                    }
                });
                ArcusClient.this.addOp(k, op);
                return op;
            }
        };
    }

    @Override
    public Future<Map<String, OperationStatus>> asyncStoreBulk(StoreType type, List<String> key, int exp, Object o) {
        return this.asyncStoreBulk(type, key, exp, o, this.transcoder);
    }

    @Override
    public <T> Future<Map<String, OperationStatus>> asyncStoreBulk(final StoreType type, final Map<String, T> o, final int exp, Transcoder<T> tc) {
        if (o == null) {
            throw new IllegalArgumentException("Map is null.");
        }
        if (o.isEmpty()) {
            throw new IllegalArgumentException("Map is empty.");
        }
        final CountDownLatch blatch = new CountDownLatch(o.size());
        return new BulkOperationFuture<OperationStatus>(o.keySet(), blatch, this.operationTimeout){

            @Override
            public Operation createOp(final String k) {
                CachedData co = ArcusClient.this.transcoder.encode(o.get(k));
                StoreOperation op = ArcusClient.this.opFact.store(type, k, co.getFlags(), exp, co.getData(), new OperationCallback(){

                    @Override
                    public void receivedStatus(OperationStatus val) {
                        if (!val.isSuccess()) {
                            failedResult.put(k, val);
                        }
                    }

                    @Override
                    public void complete() {
                        blatch.countDown();
                    }
                });
                ArcusClient.this.addOp(k, op);
                return op;
            }
        };
    }

    @Override
    public Future<Map<String, OperationStatus>> asyncStoreBulk(StoreType type, Map<String, Object> o, int exp) {
        return this.asyncStoreBulk(type, o, exp, this.transcoder);
    }

    @Override
    public Future<Map<String, OperationStatus>> asyncDeleteBulk(List<String> key) {
        if (key == null) {
            throw new IllegalArgumentException("Key list is null.");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key list is empty.");
        }
        final CountDownLatch blatch = new CountDownLatch(key.size());
        return new BulkOperationFuture<OperationStatus>(key, blatch, this.operationTimeout){

            @Override
            public Operation createOp(final String k) {
                DeleteOperation op = ArcusClient.this.opFact.delete(k, new OperationCallback(){

                    @Override
                    public void receivedStatus(OperationStatus val) {
                        if (!val.isSuccess()) {
                            failedResult.put(k, val);
                        }
                    }

                    @Override
                    public void complete() {
                        blatch.countDown();
                    }
                });
                ArcusClient.this.addOp(k, op);
                return op;
            }
        };
    }

    @Override
    public Future<Map<String, OperationStatus>> asyncDeleteBulk(String ... key) {
        if (key == null) {
            throw new IllegalArgumentException("Key list is null.");
        }
        return this.asyncDeleteBulk(Arrays.asList(key));
    }

    @Override
    public int getMaxPipedItemCount() {
        return 500;
    }

    @Override
    public CollectionFuture<Boolean> asyncBopCreate(String key, ElementValueType valueType, CollectionAttributes attributes) {
        int flag = CollectionTranscoder.examineFlags(valueType);
        boolean noreply = false;
        BTreeCreate bTreeCreate = new BTreeCreate(flag, attributes.getExpireTime(), attributes.getMaxCount(), attributes.getOverflowAction(), attributes.getReadable(), noreply);
        return this.asyncCollectionCreate(key, bTreeCreate);
    }

    @Override
    public CollectionFuture<Boolean> asyncMopCreate(String key, ElementValueType type, CollectionAttributes attributes) {
        int flag = CollectionTranscoder.examineFlags(type);
        boolean noreply = false;
        MapCreate mapCreate = new MapCreate(flag, attributes.getExpireTime(), attributes.getMaxCount(), attributes.getReadable(), noreply);
        return this.asyncCollectionCreate(key, mapCreate);
    }

    @Override
    public CollectionFuture<Boolean> asyncSopCreate(String key, ElementValueType type, CollectionAttributes attributes) {
        int flag = CollectionTranscoder.examineFlags(type);
        boolean noreply = false;
        SetCreate setCreate = new SetCreate(flag, attributes.getExpireTime(), attributes.getMaxCount(), attributes.getReadable(), noreply);
        return this.asyncCollectionCreate(key, setCreate);
    }

    @Override
    public CollectionFuture<Boolean> asyncLopCreate(String key, ElementValueType type, CollectionAttributes attributes) {
        int flag = CollectionTranscoder.examineFlags(type);
        boolean noreply = false;
        ListCreate listCreate = new ListCreate(flag, attributes.getExpireTime(), attributes.getMaxCount(), attributes.getOverflowAction(), attributes.getReadable(), noreply);
        return this.asyncCollectionCreate(key, listCreate);
    }

    CollectionFuture<Boolean> asyncCollectionCreate(final String key, final CollectionCreate collectionCreate) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Boolean> rv = new CollectionFuture<Boolean>(latch, this.operationTimeout);
        CollectionCreateOperation op = this.opFact.collectionCreate(key, collectionCreate, new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                rv.set(cstatus.isSuccess(), cstatus);
                if (!cstatus.isSuccess() && ArcusClient.this.getLogger().isDebugEnabled()) {
                    ArcusClient.this.getLogger().debug("Insertion to the collection failed : " + cstatus.getMessage() + " (type=" + collectionCreate.getClass().getName() + ", key=" + key + ", attribute=" + collectionCreate.toString() + ")");
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    @Override
    public CollectionFuture<Map<Long, Element<Object>>> asyncBopGet(String key, long bkey, ElementFlagFilter eFlagFilter, boolean withDelete, boolean dropIfEmpty) {
        BTreeGet get = new BTreeGet(bkey, withDelete, dropIfEmpty, eFlagFilter);
        return this.asyncBopGet(key, get, false, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<Map<Long, Element<Object>>> asyncBopGet(String key, long from, long to, ElementFlagFilter eFlagFilter, int offset, int count, boolean withDelete, boolean dropIfEmpty) {
        BTreeGet get = new BTreeGet(from, to, offset, count, withDelete, dropIfEmpty, eFlagFilter);
        boolean reverse = from > to;
        return this.asyncBopGet(key, get, reverse, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<Long, Element<T>>> asyncBopGet(String key, long bkey, ElementFlagFilter eFlagFilter, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        BTreeGet get = new BTreeGet(bkey, withDelete, dropIfEmpty, eFlagFilter);
        return this.asyncBopGet(key, get, false, tc);
    }

    @Override
    public <T> CollectionFuture<Map<Long, Element<T>>> asyncBopGet(String key, long from, long to, ElementFlagFilter eFlagFilter, int offset, int count, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        BTreeGet get = new BTreeGet(from, to, offset, count, withDelete, dropIfEmpty, eFlagFilter);
        boolean reverse = from > to;
        return this.asyncBopGet(key, get, reverse, tc);
    }

    @Override
    public CollectionFuture<Map<String, Object>> asyncMopGet(String key, boolean withDelete, boolean dropIfEmpty) {
        ArrayList<String> mkeyList = new ArrayList<String>();
        MapGet get = new MapGet(mkeyList, withDelete, dropIfEmpty);
        return this.asyncMopGet(key, get, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<Map<String, Object>> asyncMopGet(String key, String mkey, boolean withDelete, boolean dropIfEmpty) {
        if (mkey == null) {
            throw new IllegalArgumentException("mkey is null");
        }
        this.validateMKey(mkey);
        ArrayList<String> mkeyList = new ArrayList<String>(1);
        mkeyList.add(mkey);
        MapGet get = new MapGet(mkeyList, withDelete, dropIfEmpty);
        return this.asyncMopGet(key, get, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<Map<String, Object>> asyncMopGet(String key, List<String> mkeyList, boolean withDelete, boolean dropIfEmpty) {
        if (mkeyList == null) {
            throw new IllegalArgumentException("mkeyList is null");
        }
        for (int i = 0; i < mkeyList.size(); ++i) {
            this.validateMKey(mkeyList.get(i));
        }
        MapGet get = new MapGet(mkeyList, withDelete, dropIfEmpty);
        return this.asyncMopGet(key, get, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<String, T>> asyncMopGet(String key, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        ArrayList<String> mkeyList = new ArrayList<String>();
        MapGet get = new MapGet(mkeyList, withDelete, dropIfEmpty);
        return this.asyncMopGet(key, get, tc);
    }

    @Override
    public <T> CollectionFuture<Map<String, T>> asyncMopGet(String key, String mkey, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        if (mkey == null) {
            throw new IllegalArgumentException("mkey is null");
        }
        this.validateMKey(mkey);
        ArrayList<String> mkeyList = new ArrayList<String>(1);
        mkeyList.add(mkey);
        MapGet get = new MapGet(mkeyList, withDelete, dropIfEmpty);
        return this.asyncMopGet(key, get, tc);
    }

    @Override
    public <T> CollectionFuture<Map<String, T>> asyncMopGet(String key, List<String> mkeyList, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        if (mkeyList == null) {
            throw new IllegalArgumentException("mkeyList is null");
        }
        for (int i = 0; i < mkeyList.size(); ++i) {
            this.validateMKey(mkeyList.get(i));
        }
        MapGet get = new MapGet(mkeyList, withDelete, dropIfEmpty);
        return this.asyncMopGet(key, get, tc);
    }

    @Override
    public CollectionFuture<List<Object>> asyncLopGet(String key, int index, boolean withDelete, boolean dropIfEmpty) {
        ListGet get = new ListGet(index, withDelete, dropIfEmpty);
        return this.asyncLopGet(key, get, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<List<Object>> asyncLopGet(String key, int from, int to, boolean withDelete, boolean dropIfEmpty) {
        ListGet get = new ListGet(from, to, withDelete, dropIfEmpty);
        return this.asyncLopGet(key, get, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<List<T>> asyncLopGet(String key, int index, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        ListGet get = new ListGet(index, withDelete, dropIfEmpty);
        return this.asyncLopGet(key, get, tc);
    }

    @Override
    public <T> CollectionFuture<List<T>> asyncLopGet(String key, int from, int to, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        ListGet get = new ListGet(from, to, withDelete, dropIfEmpty);
        return this.asyncLopGet(key, get, tc);
    }

    @Override
    public CollectionFuture<Set<Object>> asyncSopGet(String key, int count, boolean withDelete, boolean dropIfEmpty) {
        SetGet get = new SetGet(count, withDelete, dropIfEmpty);
        return this.asyncSopGet(key, get, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Set<T>> asyncSopGet(String key, int count, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        SetGet get = new SetGet(count, withDelete, dropIfEmpty);
        return this.asyncSopGet(key, get, tc);
    }

    @Override
    public CollectionFuture<Boolean> asyncBopDelete(String key, long bkey, ElementFlagFilter eFlagFilter, boolean dropIfEmpty) {
        BTreeDelete delete = new BTreeDelete(bkey, false, dropIfEmpty, eFlagFilter);
        return this.asyncCollectionDelete(key, delete);
    }

    @Override
    public CollectionFuture<Boolean> asyncBopDelete(String key, long from, long to, ElementFlagFilter eFlagFilter, int count, boolean dropIfEmpty) {
        BTreeDelete delete = new BTreeDelete(from, to, count, false, dropIfEmpty, eFlagFilter);
        return this.asyncCollectionDelete(key, delete);
    }

    @Override
    public CollectionFuture<Boolean> asyncMopDelete(String key, boolean dropIfEmpty) {
        ArrayList<String> mkeyList = new ArrayList<String>();
        MapDelete delete = new MapDelete(mkeyList, false, dropIfEmpty);
        return this.asyncCollectionDelete(key, delete);
    }

    @Override
    public CollectionFuture<Boolean> asyncMopDelete(String key, String mkey, boolean dropIfEmpty) {
        if (mkey == null) {
            throw new IllegalArgumentException("mkey is null");
        }
        this.validateMKey(mkey);
        ArrayList<String> mkeyList = new ArrayList<String>(1);
        mkeyList.add(mkey);
        MapDelete delete = new MapDelete(mkeyList, false, dropIfEmpty);
        return this.asyncCollectionDelete(key, delete);
    }

    @Override
    public CollectionFuture<Boolean> asyncLopDelete(String key, int index, boolean dropIfEmpty) {
        ListDelete delete = new ListDelete(index, false, dropIfEmpty);
        return this.asyncCollectionDelete(key, delete);
    }

    @Override
    public CollectionFuture<Boolean> asyncLopDelete(String key, int from, int to, boolean dropIfEmpty) {
        ListDelete delete = new ListDelete(from, to, false, dropIfEmpty);
        return this.asyncCollectionDelete(key, delete);
    }

    @Override
    public CollectionFuture<Boolean> asyncSopDelete(String key, Object value, boolean dropIfEmpty) {
        SetDelete<Object> delete = new SetDelete<Object>(value, false, dropIfEmpty, this.collectionTranscoder);
        return this.asyncCollectionDelete(key, delete);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncSopDelete(String key, T value, boolean dropIfEmpty, Transcoder<T> tc) {
        SetDelete<T> delete = new SetDelete<T>(value, false, dropIfEmpty, tc);
        return this.asyncCollectionDelete(key, delete);
    }

    private CollectionFuture<Integer> asyncCollectionCount(String k, CollectionCount collectionCount) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Integer> rv = new CollectionFuture<Integer>(latch, this.operationTimeout);
        CollectionCountOperation op = this.opFact.collectionCount(k, collectionCount, new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(new Integer(cstatus.getMessage()), new CollectionOperationStatus(new OperationStatus(true, "END")));
                    return;
                }
                rv.set(null, cstatus);
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    @Override
    public CollectionFuture<Integer> asyncBopGetItemCount(String key, long from, long to, ElementFlagFilter eFlagFilter) {
        BTreeCount collectionCount = new BTreeCount(from, to, eFlagFilter);
        return this.asyncCollectionCount(key, collectionCount);
    }

    @Override
    public CollectionFuture<Boolean> asyncBopInsert(String key, long bkey, byte[] eFlag, Object value, CollectionAttributes attributesForCreate) {
        BTreeInsert<Object> bTreeInsert = new BTreeInsert<Object>(value, eFlag, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, String.valueOf(bkey), bTreeInsert, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<Boolean> asyncMopInsert(String key, String mkey, Object value, CollectionAttributes attributesForCreate) {
        this.validateMKey(mkey);
        MapInsert<Object> mapInsert = new MapInsert<Object>(value, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, mkey, mapInsert, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<Boolean> asyncLopInsert(String key, int index, Object value, CollectionAttributes attributesForCreate) {
        ListInsert<Object> listInsert = new ListInsert<Object>(value, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, String.valueOf(index), listInsert, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<Boolean> asyncSopInsert(String key, Object value, CollectionAttributes attributesForCreate) {
        SetInsert<Object> setInsert = new SetInsert<Object>(value, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, "", setInsert, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncBopInsert(String key, long bkey, byte[] eFlag, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        BTreeInsert<T> bTreeInsert = new BTreeInsert<T>(value, eFlag, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, String.valueOf(bkey), bTreeInsert, tc);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncMopInsert(String key, String mkey, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        this.validateMKey(mkey);
        MapInsert<T> mapInsert = new MapInsert<T>(value, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, mkey, mapInsert, tc);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncLopInsert(String key, int index, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        ListInsert<T> listInsert = new ListInsert<T>(value, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, String.valueOf(index), listInsert, tc);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncSopInsert(String key, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        SetInsert<T> setInsert = new SetInsert<T>(value, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, "", setInsert, tc);
    }

    @Override
    public CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncBopPipedInsertBulk(String key, Map<Long, Object> elements, CollectionAttributes attributesForCreate) {
        return this.asyncBopPipedInsertBulk(key, elements, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncMopPipedInsertBulk(String key, Map<String, Object> elements, CollectionAttributes attributesForCreate) {
        return this.asyncMopPipedInsertBulk(key, elements, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncLopPipedInsertBulk(String key, int index, List<Object> valueList, CollectionAttributes attributesForCreate) {
        return this.asyncLopPipedInsertBulk(key, index, valueList, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncSopPipedInsertBulk(String key, List<Object> valueList, CollectionAttributes attributesForCreate) {
        return this.asyncSopPipedInsertBulk(key, valueList, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncBopPipedInsertBulk(String key, Map<Long, T> elements, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        if (elements.size() <= 500) {
            CollectionPipedInsert.BTreePipedInsert<T> insert = new CollectionPipedInsert.BTreePipedInsert<T>(key, elements, attributesForCreate != null, attributesForCreate, tc);
            return this.asyncCollectionPipedInsert(key, insert);
        }
        ArrayList<CollectionPipedInsert<T>> insertList = new ArrayList<CollectionPipedInsert<T>>();
        PartitionedMap<Long, T> list = new PartitionedMap<Long, T>(elements, 500);
        for (int i = 0; i < list.size(); ++i) {
            insertList.add(new CollectionPipedInsert.BTreePipedInsert<T>(key, list.get(i), attributesForCreate != null, attributesForCreate, tc));
        }
        return this.asyncCollectionPipedInsert(key, insertList);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncMopPipedInsertBulk(String key, Map<String, T> elements, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        for (Map.Entry<String, T> checkMKey : elements.entrySet()) {
            this.validateMKey(checkMKey.getKey());
        }
        if (elements.size() <= 500) {
            CollectionPipedInsert.MapPipedInsert<T> insert = new CollectionPipedInsert.MapPipedInsert<T>(key, elements, attributesForCreate != null, attributesForCreate, tc);
            return this.asyncCollectionPipedInsert(key, insert);
        }
        ArrayList<CollectionPipedInsert<T>> insertList = new ArrayList<CollectionPipedInsert<T>>();
        PartitionedMap<String, T> list = new PartitionedMap<String, T>(elements, 500);
        for (int i = 0; i < list.size(); ++i) {
            insertList.add(new CollectionPipedInsert.MapPipedInsert<T>(key, list.get(i), attributesForCreate != null, attributesForCreate, tc));
        }
        return this.asyncCollectionPipedInsert(key, insertList);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncLopPipedInsertBulk(String key, int index, List<T> valueList, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        if (valueList.size() <= 500) {
            CollectionPipedInsert.ListPipedInsert<T> insert = new CollectionPipedInsert.ListPipedInsert<T>(key, index, valueList, attributesForCreate != null, attributesForCreate, tc);
            return this.asyncCollectionPipedInsert(key, insert);
        }
        PartitionedList<T> list = new PartitionedList<T>(valueList, 500);
        ArrayList<CollectionPipedInsert<T>> insertList = new ArrayList<CollectionPipedInsert<T>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            insertList.add(new CollectionPipedInsert.ListPipedInsert<T>(key, index, list.get(i), attributesForCreate != null, attributesForCreate, tc));
        }
        return this.asyncCollectionPipedInsert(key, insertList);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncSopPipedInsertBulk(String key, List<T> valueList, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        if (valueList.size() <= 500) {
            CollectionPipedInsert.SetPipedInsert<T> insert = new CollectionPipedInsert.SetPipedInsert<T>(key, valueList, attributesForCreate != null, attributesForCreate, tc);
            return this.asyncCollectionPipedInsert(key, insert);
        }
        PartitionedList<T> list = new PartitionedList<T>(valueList, 500);
        ArrayList<CollectionPipedInsert<T>> insertList = new ArrayList<CollectionPipedInsert<T>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            insertList.add(new CollectionPipedInsert.SetPipedInsert<T>(key, list.get(i), attributesForCreate != null, attributesForCreate, tc));
        }
        return this.asyncCollectionPipedInsert(key, insertList);
    }

    @Override
    public OperationFuture<Boolean> flush(String prefix) {
        return this.flush(prefix, -1);
    }

    @Override
    public OperationFuture<Boolean> flush(final String prefix, final int delay) {
        final AtomicReference<Object> flushResult = new AtomicReference<Object>(null);
        final ConcurrentLinkedQueue ops = new ConcurrentLinkedQueue();
        final CountDownLatch blatch = this.broadcastOp(new BroadcastOpFactory(){

            @Override
            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                FlushOperation op = ArcusClient.this.opFact.flush(prefix, delay, false, new OperationCallback(){

                    @Override
                    public void receivedStatus(OperationStatus s) {
                        flushResult.set(s.isSuccess());
                    }

                    @Override
                    public void complete() {
                        latch.countDown();
                    }
                });
                ops.add(op);
                return op;
            }
        });
        return new OperationFuture<Boolean>(blatch, flushResult, this.operationTimeout){

            @Override
            public boolean cancel(boolean ign) {
                boolean rv = false;
                for (Operation op : ops) {
                    op.cancel("by application.");
                    rv |= op.getState() == OperationState.WRITE_QUEUED;
                }
                return rv;
            }

            @Override
            public boolean isCancelled() {
                for (Operation op : ops) {
                    if (!op.isCancelled()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Boolean get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
                if (!blatch.await(duration, units)) {
                    for (Operation op : ops) {
                        MemcachedConnection.opTimedOut(op);
                    }
                    throw new CheckedOperationTimeoutException("Timed out waiting for operation. >" + duration + " " + (Object)((Object)units), ops);
                }
                for (Operation op : ops) {
                    MemcachedConnection.opSucceeded(op);
                }
                for (Operation op : ops) {
                    if (op != null && op.hasErrored()) {
                        throw new ExecutionException(op.getException());
                    }
                    if (op == null || !op.isCancelled()) continue;
                    throw new ExecutionException(new RuntimeException(op.getCancelCause()));
                }
                return (Boolean)flushResult.get();
            }

            @Override
            public boolean isDone() {
                for (Operation op : ops) {
                    if (op.getState() == OperationState.COMPLETE || op.isCancelled()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public SMGetFuture<List<SMGetElement<Object>>> asyncBopSortMergeGet(List<String> keyList, long from, long to, ElementFlagFilter eFlagFilter, int offset, int count) {
        if (keyList == null || keyList.isEmpty()) {
            throw new IllegalArgumentException("Key list is empty.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be 0 or positive integer.");
        }
        if (count < 1) {
            throw new IllegalArgumentException("Count must be larger than 0.");
        }
        if (offset + count > 1000) {
            throw new IllegalArgumentException("The sum of offset and count must not exceed a maximum of 1000.");
        }
        Map<String, List<String>> arrangedKey = this.groupingKeys(keyList, this.smgetKeyChunkSize);
        ArrayList smGetList = new ArrayList(arrangedKey.size());
        for (List<String> v : arrangedKey.values()) {
            if (arrangedKey.size() > 1) {
                smGetList.add(new BTreeSMGetWithLongTypeBkeyOld(v, from, to, eFlagFilter, 0, offset + count));
                continue;
            }
            smGetList.add(new BTreeSMGetWithLongTypeBkeyOld(v, from, to, eFlagFilter, offset, count));
        }
        return this.smget(smGetList, offset, count, from > to, this.collectionTranscoder);
    }

    @Override
    public SMGetFuture<List<SMGetElement<Object>>> asyncBopSortMergeGet(List<String> keyList, long from, long to, ElementFlagFilter eFlagFilter, int count, SMGetMode smgetMode) {
        if (keyList == null || keyList.isEmpty()) {
            throw new IllegalArgumentException("Key list is empty.");
        }
        if (count < 1) {
            throw new IllegalArgumentException("Count must be larger than 0.");
        }
        if (count > 1000) {
            throw new IllegalArgumentException("The count must not exceed a maximum of 1000.");
        }
        Map<String, List<String>> arrangedKey = this.groupingKeys(keyList, this.smgetKeyChunkSize);
        ArrayList smGetList = new ArrayList(arrangedKey.size());
        for (List<String> v : arrangedKey.values()) {
            smGetList.add(new BTreeSMGetWithLongTypeBkey(v, from, to, eFlagFilter, count, smgetMode));
        }
        return this.smget(smGetList, count, from > to, this.collectionTranscoder, smgetMode);
    }

    private Map<String, List<String>> groupingKeys(List<String> keyList, int groupSize) {
        HashMap<String, Integer> chunkCount = new HashMap<String, Integer>();
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        HashSet<String> keySet = new HashSet<String>();
        MemcachedConnection conn = this.getMemcachedConnection();
        for (String k : keyList) {
            int cc;
            this.validateKey(k);
            if (!keySet.add(k)) {
                throw new IllegalArgumentException("Duplicate keys exist in key list.");
            }
            MemcachedNode qa = conn.findNodeByKey(k);
            String node = qa == null ? "fake_node" : qa.getSocketAddress().toString();
            if (chunkCount.containsKey(node)) {
                cc = (Integer)chunkCount.get(node);
            } else {
                cc = 0;
                chunkCount.put(node, 0);
            }
            String resultKey = node + cc;
            List<String> arrangedKeyList = null;
            if (result.containsKey(resultKey)) {
                if (((List)result.get(resultKey)).size() >= groupSize) {
                    arrangedKeyList = new ArrayList();
                    result.put(node + ++cc, arrangedKeyList);
                    chunkCount.put(node, cc);
                } else {
                    arrangedKeyList = (List)result.get(resultKey);
                }
            } else {
                arrangedKeyList = new ArrayList<String>();
                result.put(resultKey, arrangedKeyList);
            }
            arrangedKeyList.add(k);
        }
        return result;
    }

    private <T> List<SMGetElement<T>> getSubList(List<SMGetElement<T>> mergedResult, int offset, int count) {
        if (mergedResult.size() > count) {
            int toIndex;
            int n = toIndex = count + offset > mergedResult.size() ? mergedResult.size() : count + offset;
            if (offset > toIndex) {
                return Collections.emptyList();
            }
            return mergedResult.subList(offset, toIndex);
        }
        if (offset > 0) {
            int toIndex;
            int n = toIndex = count + offset > mergedResult.size() ? mergedResult.size() : count + offset;
            if (offset > toIndex) {
                return Collections.emptyList();
            }
            return mergedResult.subList(offset, toIndex);
        }
        return mergedResult;
    }

    private <T> SMGetFuture<List<SMGetElement<T>>> smget(final List<BTreeSMGet<T>> smGetList, final int offset, final int count, final boolean reverse, final Transcoder<T> tc) {
        String END = "END";
        String TRIMMED = "TRIMMED";
        String DUPLICATED = "DUPLICATED";
        String DUPLICATED_TRIMMED = "DUPLICATED_TRIMMED";
        final CountDownLatch blatch = new CountDownLatch(smGetList.size());
        final ConcurrentLinkedQueue<BTreeSortMergeGetOperationOld> ops = new ConcurrentLinkedQueue<BTreeSortMergeGetOperationOld>();
        final List missedKeyList = Collections.synchronizedList(new ArrayList());
        final Map missedKeys = Collections.synchronizedMap(new HashMap());
        final List mergedTrimmedKeys = Collections.synchronizedList(new ArrayList());
        final int totalResultElementCount = count + offset;
        final List mergedResult = Collections.synchronizedList(new ArrayList(totalResultElementCount));
        final ReentrantLock lock = new ReentrantLock();
        final List resultOperationStatus = Collections.synchronizedList(new ArrayList(1));
        final List failedOperationStatus = Collections.synchronizedList(new ArrayList(1));
        final AtomicInteger processedSMGetCount = new AtomicInteger(smGetList.size());
        final AtomicBoolean mergedTrim = new AtomicBoolean(false);
        final AtomicBoolean stopCollect = new AtomicBoolean(false);
        for (BTreeSMGet<T> smGet : smGetList) {
            BTreeSortMergeGetOperationOld op = this.opFact.bopsmget(smGet, new BTreeSortMergeGetOperationOld.Callback(){
                private final List<SMGetElement<T>> eachResult = new ArrayList();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receivedStatus(OperationStatus status) {
                    processedSMGetCount.decrementAndGet();
                    if (!status.isSuccess()) {
                        ArcusClient.this.getLogger().warn("SMGetFailed. status=%s", status);
                        if (!stopCollect.get()) {
                            stopCollect.set(true);
                            failedOperationStatus.add(status);
                        }
                        mergedResult.clear();
                        return;
                    }
                    boolean isTrimmed = "TRIMMED".equals(status.getMessage()) || "DUPLICATED_TRIMMED".equals(status.getMessage());
                    lock.lock();
                    try {
                        if (mergedResult.size() == 0) {
                            mergedResult.addAll(this.eachResult);
                            mergedTrim.set(isTrimmed);
                        } else {
                            boolean addAll = true;
                            int pos = 0;
                            for (SMGetElement result : this.eachResult) {
                                while (pos < mergedResult.size() && !(reverse ? 0 < result.compareTo((SMGetElement)mergedResult.get(pos)) : 0 > result.compareTo((SMGetElement)mergedResult.get(pos)))) {
                                    ++pos;
                                }
                                if (pos >= totalResultElementCount) {
                                    addAll = false;
                                    break;
                                }
                                if (pos >= mergedResult.size() && mergedTrim.get() && result.compareBkeyTo((SMGetElement)mergedResult.get(pos - 1)) != 0) {
                                    addAll = false;
                                    break;
                                }
                                mergedResult.add(pos, result);
                                if (mergedResult.size() > totalResultElementCount) {
                                    mergedResult.remove(totalResultElementCount);
                                }
                                ++pos;
                            }
                            if (isTrimmed && addAll) {
                                while (pos < mergedResult.size()) {
                                    if (((SMGetElement)mergedResult.get(pos)).compareBkeyTo((SMGetElement)mergedResult.get(pos - 1)) == 0) {
                                        ++pos;
                                        continue;
                                    }
                                    mergedResult.remove(pos);
                                }
                                mergedTrim.set(true);
                            }
                            if (mergedResult.size() >= totalResultElementCount) {
                                mergedTrim.set(false);
                            }
                        }
                        if (processedSMGetCount.get() == 0) {
                            boolean isDuplicated = false;
                            for (int i = 1; i < mergedResult.size(); ++i) {
                                if (((SMGetElement)mergedResult.get(i)).compareBkeyTo((SMGetElement)mergedResult.get(i - 1)) != 0) continue;
                                isDuplicated = true;
                                break;
                            }
                            if (mergedTrim.get()) {
                                if (isDuplicated) {
                                    resultOperationStatus.add(new OperationStatus(true, "DUPLICATED_TRIMMED"));
                                } else {
                                    resultOperationStatus.add(new OperationStatus(true, "TRIMMED"));
                                }
                            } else if (isDuplicated) {
                                resultOperationStatus.add(new OperationStatus(true, "DUPLICATED"));
                            } else {
                                resultOperationStatus.add(new OperationStatus(true, "END"));
                            }
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }

                @Override
                public void complete() {
                    blatch.countDown();
                }

                @Override
                public void gotData(String key, Object subkey, int flags, byte[] data) {
                    if (stopCollect.get()) {
                        return;
                    }
                    if (subkey instanceof Long) {
                        this.eachResult.add(new SMGetElement(key, (Long)subkey, tc.decode(new CachedData(flags, data, tc.getMaxSize()))));
                    } else if (subkey instanceof byte[]) {
                        this.eachResult.add(new SMGetElement(key, (byte[])subkey, tc.decode(new CachedData(flags, data, tc.getMaxSize()))));
                    }
                }

                @Override
                public void gotMissedKey(byte[] data) {
                    missedKeyList.add(new String(data));
                    OperationStatus cause = new OperationStatus(false, "UNDEFINED");
                    missedKeys.put(new String(data), new CollectionOperationStatus(cause));
                }
            });
            ops.add(op);
            this.addOp(smGet.getRepresentKey(), op);
        }
        return new SMGetFuture<List<SMGetElement<T>>>(ops, this.operationTimeout){

            @Override
            public List<SMGetElement<T>> get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
                if (!blatch.await(duration, units)) {
                    for (Operation op : ops) {
                        MemcachedConnection.opTimedOut(op);
                    }
                    throw new CheckedOperationTimeoutException("Timed out waiting for operation >" + duration + " " + (Object)((Object)units), ops);
                }
                for (Operation op : ops) {
                    MemcachedConnection.opSucceeded(op);
                }
                for (Operation op : ops) {
                    if (op != null && op.hasErrored()) {
                        throw new ExecutionException(op.getException());
                    }
                    if (op == null || !op.isCancelled()) continue;
                    throw new ExecutionException(new RuntimeException(op.getCancelCause()));
                }
                if (smGetList.size() == 1) {
                    return mergedResult;
                }
                return ArcusClient.this.getSubList(mergedResult, offset, count);
            }

            @Override
            public List<String> getMissedKeyList() {
                return missedKeyList;
            }

            @Override
            public Map<String, CollectionOperationStatus> getMissedKeys() {
                return missedKeys;
            }

            @Override
            public List<SMGetTrimKey> getTrimmedKeys() {
                return mergedTrimmedKeys;
            }

            @Override
            public CollectionOperationStatus getOperationStatus() {
                if (failedOperationStatus.size() > 0) {
                    return new CollectionOperationStatus((OperationStatus)failedOperationStatus.get(0));
                }
                return new CollectionOperationStatus((OperationStatus)resultOperationStatus.get(0));
            }
        };
    }

    private <T> SMGetFuture<List<SMGetElement<T>>> smget(final List<BTreeSMGet<T>> smGetList, final int count, final boolean reverse, final Transcoder<T> tc, final SMGetMode smgetMode) {
        String END = "END";
        String TRIMMED = "TRIMMED";
        String DUPLICATED = "DUPLICATED";
        String DUPLICATED_TRIMMED = "DUPLICATED_TRIMMED";
        final CountDownLatch blatch = new CountDownLatch(smGetList.size());
        final ConcurrentLinkedQueue<BTreeSortMergeGetOperation> ops = new ConcurrentLinkedQueue<BTreeSortMergeGetOperation>();
        final List missedKeyList = Collections.synchronizedList(new ArrayList());
        final Map missedKeys = Collections.synchronizedMap(new HashMap());
        final int totalResultElementCount = count;
        final List mergedResult = Collections.synchronizedList(new ArrayList(totalResultElementCount));
        final List mergedTrimmedKeys = Collections.synchronizedList(new ArrayList());
        final ReentrantLock lock = new ReentrantLock();
        final List resultOperationStatus = Collections.synchronizedList(new ArrayList(1));
        final List failedOperationStatus = Collections.synchronizedList(new ArrayList(1));
        final AtomicBoolean stopCollect = new AtomicBoolean(false);
        final AtomicInteger processedSMGetCount = new AtomicInteger(smGetList.size());
        for (BTreeSMGet<T> smGet : smGetList) {
            BTreeSortMergeGetOperation op = this.opFact.bopsmget(smGet, new BTreeSortMergeGetOperation.Callback(){
                private final List<SMGetElement<T>> eachResult = new ArrayList();
                private final List<SMGetTrimKey> eachTrimmedResult = new ArrayList<SMGetTrimKey>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void receivedStatus(OperationStatus status) {
                    processedSMGetCount.decrementAndGet();
                    if (!status.isSuccess()) {
                        ArcusClient.this.getLogger().warn("SMGetFailed. status=%s", status);
                        if (!stopCollect.get()) {
                            stopCollect.set(true);
                            failedOperationStatus.add(status);
                        }
                        mergedResult.clear();
                        mergedTrimmedKeys.clear();
                        return;
                    }
                    lock.lock();
                    try {
                        if (mergedResult.size() == 0) {
                            mergedResult.addAll(this.eachResult);
                        } else {
                            int pos = 0;
                            for (SMGetElement result : this.eachResult) {
                                boolean duplicated = false;
                                while (pos < mergedResult.size()) {
                                    int comp = result.compareBkeyTo((SMGetElement)mergedResult.get(pos));
                                    if (!reverse ? 0 > comp : 0 < comp) break;
                                    if (comp == 0) {
                                        comp = result.compareKeyTo((SMGetElement)mergedResult.get(pos));
                                        if (reverse ? 0 < comp : 0 > comp) {
                                            if (smgetMode != SMGetMode.UNIQUE) break;
                                            mergedResult.remove(pos);
                                            break;
                                        }
                                        if (smgetMode == SMGetMode.UNIQUE) {
                                            duplicated = true;
                                            break;
                                        }
                                    }
                                    ++pos;
                                }
                                if (duplicated) continue;
                                if (pos >= totalResultElementCount) break;
                                mergedResult.add(pos, result);
                                if (mergedResult.size() > totalResultElementCount) {
                                    mergedResult.remove(totalResultElementCount);
                                }
                                ++pos;
                            }
                        }
                        if (this.eachTrimmedResult.size() > 0) {
                            if (mergedTrimmedKeys.size() == 0) {
                                mergedTrimmedKeys.addAll(this.eachTrimmedResult);
                            } else {
                                int pos = 0;
                                for (SMGetTrimKey result : this.eachTrimmedResult) {
                                    while (pos < mergedTrimmedKeys.size() && !(reverse ? 0 < result.compareTo((SMGetTrimKey)mergedTrimmedKeys.get(pos)) : 0 > result.compareTo((SMGetTrimKey)mergedTrimmedKeys.get(pos)))) {
                                        ++pos;
                                    }
                                    mergedTrimmedKeys.add(pos, result);
                                    ++pos;
                                }
                            }
                        }
                        if (processedSMGetCount.get() == 0) {
                            if (mergedTrimmedKeys.size() > 0 && count <= mergedResult.size()) {
                                SMGetElement lastElement = (SMGetElement)mergedResult.get(mergedResult.size() - 1);
                                SMGetTrimKey lastTrimKey = new SMGetTrimKey(lastElement.getKey(), lastElement.getBkeyByObject());
                                for (int i = mergedTrimmedKeys.size() - 1; i >= 0; --i) {
                                    SMGetTrimKey me = (SMGetTrimKey)mergedTrimmedKeys.get(i);
                                    if (!(reverse ? 0 >= me.compareBkeyTo(lastTrimKey) : 0 <= me.compareBkeyTo(lastTrimKey))) break;
                                    mergedTrimmedKeys.remove(i);
                                }
                            }
                            if (smgetMode == SMGetMode.UNIQUE) {
                                resultOperationStatus.add(new OperationStatus(true, "END"));
                            } else {
                                boolean isDuplicated = false;
                                for (int i = 1; i < mergedResult.size(); ++i) {
                                    if (((SMGetElement)mergedResult.get(i)).compareBkeyTo((SMGetElement)mergedResult.get(i - 1)) != 0) continue;
                                    isDuplicated = true;
                                    break;
                                }
                                if (isDuplicated) {
                                    resultOperationStatus.add(new OperationStatus(true, "DUPLICATED"));
                                } else {
                                    resultOperationStatus.add(new OperationStatus(true, "END"));
                                }
                            }
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }

                @Override
                public void complete() {
                    blatch.countDown();
                }

                @Override
                public void gotData(String key, Object subkey, int flags, byte[] data) {
                    if (stopCollect.get()) {
                        return;
                    }
                    if (subkey instanceof Long) {
                        this.eachResult.add(new SMGetElement(key, (Long)subkey, tc.decode(new CachedData(flags, data, tc.getMaxSize()))));
                    } else if (subkey instanceof byte[]) {
                        this.eachResult.add(new SMGetElement(key, (byte[])subkey, tc.decode(new CachedData(flags, data, tc.getMaxSize()))));
                    }
                }

                @Override
                public void gotMissedKey(String key, OperationStatus cause) {
                    missedKeyList.add(key);
                    missedKeys.put(key, new CollectionOperationStatus(cause));
                }

                @Override
                public void gotTrimmedKey(String key, Object subkey) {
                    if (stopCollect.get()) {
                        return;
                    }
                    if (subkey instanceof Long) {
                        this.eachTrimmedResult.add(new SMGetTrimKey(key, (Long)subkey));
                    } else if (subkey instanceof byte[]) {
                        this.eachTrimmedResult.add(new SMGetTrimKey(key, (byte[])subkey));
                    }
                }
            });
            ops.add(op);
            this.addOp(smGet.getRepresentKey(), op);
        }
        return new SMGetFuture<List<SMGetElement<T>>>(ops, this.operationTimeout){

            @Override
            public List<SMGetElement<T>> get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
                if (!blatch.await(duration, units)) {
                    for (Operation op : ops) {
                        MemcachedConnection.opTimedOut(op);
                    }
                    throw new CheckedOperationTimeoutException("Timed out waiting for operation >" + duration + " " + (Object)((Object)units), ops);
                }
                for (Operation op : ops) {
                    MemcachedConnection.opSucceeded(op);
                }
                for (Operation op : ops) {
                    if (op != null && op.hasErrored()) {
                        throw new ExecutionException(op.getException());
                    }
                    if (op == null || !op.isCancelled()) continue;
                    throw new ExecutionException(new RuntimeException(op.getCancelCause()));
                }
                if (smGetList.size() == 1) {
                    return mergedResult;
                }
                return ArcusClient.this.getSubList(mergedResult, 0, count);
            }

            @Override
            public List<String> getMissedKeyList() {
                return missedKeyList;
            }

            @Override
            public Map<String, CollectionOperationStatus> getMissedKeys() {
                return missedKeys;
            }

            @Override
            public List<SMGetTrimKey> getTrimmedKeys() {
                return mergedTrimmedKeys;
            }

            @Override
            public CollectionOperationStatus getOperationStatus() {
                if (failedOperationStatus.size() > 0) {
                    return new CollectionOperationStatus((OperationStatus)failedOperationStatus.get(0));
                }
                return new CollectionOperationStatus((OperationStatus)resultOperationStatus.get(0));
            }
        };
    }

    @Override
    public CollectionFuture<Boolean> asyncBopUpsert(String key, long bkey, byte[] elementFlag, Object value, CollectionAttributes attributesForCreate) {
        BTreeUpsert<Object> bTreeUpsert = new BTreeUpsert<Object>(value, elementFlag, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, String.valueOf(bkey), bTreeUpsert, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncBopUpsert(String key, long bkey, byte[] elementFlag, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        BTreeUpsert<T> bTreeUpsert = new BTreeUpsert<T>(value, elementFlag, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, String.valueOf(bkey), bTreeUpsert, tc);
    }

    @Override
    public CollectionFuture<Boolean> asyncBopUpdate(String key, long bkey, ElementFlagUpdate eFlagUpdate, Object value) {
        BTreeUpdate<Object> collectionUpdate = new BTreeUpdate<Object>(value, eFlagUpdate, false);
        return this.asyncCollectionUpdate(key, String.valueOf(bkey), collectionUpdate, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncBopUpdate(String key, long bkey, ElementFlagUpdate eFlagUpdate, T value, Transcoder<T> tc) {
        BTreeUpdate<T> collectionUpdate = new BTreeUpdate<T>(value, eFlagUpdate, false);
        return this.asyncCollectionUpdate(key, String.valueOf(bkey), collectionUpdate, tc);
    }

    @Override
    public CollectionFuture<Boolean> asyncBopUpdate(String key, byte[] bkey, ElementFlagUpdate eFlagUpdate, Object value) {
        BTreeUpdate<Object> collectionUpdate = new BTreeUpdate<Object>(value, eFlagUpdate, false);
        return this.asyncCollectionUpdate(key, BTreeUtil.toHex(bkey), collectionUpdate, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncBopUpdate(String key, byte[] bkey, ElementFlagUpdate eFlagUpdate, T value, Transcoder<T> tc) {
        BTreeUpdate<T> collectionUpdate = new BTreeUpdate<T>(value, eFlagUpdate, false);
        return this.asyncCollectionUpdate(key, BTreeUtil.toHex(bkey), collectionUpdate, tc);
    }

    @Override
    public CollectionFuture<Boolean> asyncMopUpdate(String key, String mkey, Object value) {
        this.validateMKey(mkey);
        MapUpdate<Object> collectionUpdate = new MapUpdate<Object>(value, false);
        return this.asyncCollectionUpdate(key, String.valueOf(mkey), collectionUpdate, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncMopUpdate(String key, String mkey, T value, Transcoder<T> tc) {
        this.validateMKey(mkey);
        MapUpdate<T> collectionUpdate = new MapUpdate<T>(value, false);
        return this.asyncCollectionUpdate(key, String.valueOf(mkey), collectionUpdate, tc);
    }

    private <T> CollectionFuture<Boolean> asyncCollectionUpdate(final String key, final String subkey, final CollectionUpdate<T> collectionUpdate, Transcoder<T> tc) {
        CachedData co = null;
        if (collectionUpdate.getNewValue() != null) {
            co = tc.encode(collectionUpdate.getNewValue());
            collectionUpdate.setFlags(co.getFlags());
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Boolean> rv = new CollectionFuture<Boolean>(latch, this.operationTimeout);
        CollectionUpdateOperation op = this.opFact.collectionUpdate(key, subkey, collectionUpdate, co == null ? null : co.getData(), new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                rv.set(cstatus.isSuccess(), cstatus);
                if (!cstatus.isSuccess() && ArcusClient.this.getLogger().isDebugEnabled()) {
                    ArcusClient.this.getLogger().debug("Insertion to the collection failed : " + cstatus.getMessage() + " (type=" + collectionUpdate.getClass().getName() + ", key=" + key + ", subkey=" + subkey + ", value=" + collectionUpdate.getNewValue() + ")");
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    @Override
    public CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncBopPipedUpdateBulk(String key, List<Element<Object>> elements) {
        return this.asyncBopPipedUpdateBulk(key, elements, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncBopPipedUpdateBulk(String key, List<Element<T>> elements, Transcoder<T> tc) {
        if (elements.size() <= 500) {
            CollectionPipedUpdate.BTreePipedUpdate<T> collectionPipedUpdate = new CollectionPipedUpdate.BTreePipedUpdate<T>(key, elements, tc);
            return this.asyncCollectionPipedUpdate(key, collectionPipedUpdate);
        }
        PartitionedList<Element<T>> list = new PartitionedList<Element<T>>(elements, 500);
        ArrayList<CollectionPipedUpdate<T>> collectionPipedUpdateList = new ArrayList<CollectionPipedUpdate<T>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            collectionPipedUpdateList.add(new CollectionPipedUpdate.BTreePipedUpdate<T>(key, list.get(i), tc));
        }
        return this.asyncCollectionPipedUpdate(key, collectionPipedUpdateList);
    }

    @Override
    public CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncMopPipedUpdateBulk(String key, Map<String, Object> elements) {
        return this.asyncMopPipedUpdateBulk(key, elements, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncMopPipedUpdateBulk(String key, Map<String, T> elements, Transcoder<T> tc) {
        for (Map.Entry<String, T> checkMKey : elements.entrySet()) {
            this.validateMKey(checkMKey.getKey());
        }
        if (elements.size() <= 500) {
            CollectionPipedUpdate.MapPipedUpdate<T> collectionPipedUpdate = new CollectionPipedUpdate.MapPipedUpdate<T>(key, elements, tc);
            return this.asyncCollectionPipedUpdate(key, collectionPipedUpdate);
        }
        PartitionedMap<String, T> list = new PartitionedMap<String, T>(elements, 500);
        ArrayList<CollectionPipedUpdate<T>> collectionPipedUpdateList = new ArrayList<CollectionPipedUpdate<T>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            collectionPipedUpdateList.add(new CollectionPipedUpdate.MapPipedUpdate<T>(key, list.get(i), tc));
        }
        return this.asyncCollectionPipedUpdate(key, collectionPipedUpdateList);
    }

    @Override
    public CollectionFuture<Boolean> asyncBopInsert(String key, byte[] bkey, byte[] eFlag, Object value, CollectionAttributes attributesForCreate) {
        BTreeInsert<Object> bTreeInsert = new BTreeInsert<Object>(value, eFlag, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, BTreeUtil.toHex(bkey), bTreeInsert, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncBopInsert(String key, byte[] bkey, byte[] eFlag, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        BTreeInsert<T> bTreeInsert = new BTreeInsert<T>(value, eFlag, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, BTreeUtil.toHex(bkey), bTreeInsert, tc);
    }

    @Override
    public CollectionFuture<Map<ByteArrayBKey, Element<Object>>> asyncBopGet(String key, byte[] bkey, ElementFlagFilter eFlagFilter, boolean withDelete, boolean dropIfEmpty) {
        BTreeGet get = new BTreeGet(bkey, bkey, 0, 1, withDelete, dropIfEmpty, eFlagFilter);
        return this.asyncBopExtendedGet(key, get, false, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<ByteArrayBKey, Element<T>>> asyncBopGet(String key, byte[] bkey, ElementFlagFilter eFlagFilter, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        BTreeGet get = new BTreeGet(bkey, bkey, 0, 1, withDelete, dropIfEmpty, eFlagFilter);
        return this.asyncBopExtendedGet(key, get, false, tc);
    }

    @Override
    public CollectionFuture<Map<ByteArrayBKey, Element<Object>>> asyncBopGet(String key, byte[] from, byte[] to, ElementFlagFilter eFlagFilter, int offset, int count, boolean withDelete, boolean dropIfEmpty) {
        BTreeGet get = new BTreeGet(from, to, offset, count, withDelete, dropIfEmpty, eFlagFilter);
        boolean reverse = BTreeUtil.compareByteArraysInLexOrder(from, to) > 0;
        return this.asyncBopExtendedGet(key, get, reverse, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<ByteArrayBKey, Element<T>>> asyncBopGet(String key, byte[] from, byte[] to, ElementFlagFilter eFlagFilter, int offset, int count, boolean withDelete, boolean dropIfEmpty, Transcoder<T> tc) {
        BTreeGet get = new BTreeGet(from, to, offset, count, withDelete, dropIfEmpty, eFlagFilter);
        boolean reverse = BTreeUtil.compareByteArraysInLexOrder(from, to) > 0;
        return this.asyncBopExtendedGet(key, get, reverse, tc);
    }

    private <T> CollectionFuture<Map<ByteArrayBKey, Element<T>>> asyncBopExtendedGet(final String k, final CollectionGet collectionGet, final boolean reverse, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Map<ByteArrayBKey, Element<T>>> rv = new CollectionFuture<Map<ByteArrayBKey, Element<T>>>(latch, this.operationTimeout);
        CollectionGetOperation op = this.opFact.collectionGet(k, collectionGet, new CollectionGetOperation.Callback(){
            private final TreeMap<ByteArrayBKey, Element<T>> map;
            {
                this.map = new ByteArrayTreeMap(reverse ? Collections.reverseOrder() : null);
            }

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(this.map, cstatus);
                    return;
                }
                switch (cstatus.getResponse()) {
                    case NOT_FOUND: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case NOT_FOUND_ELEMENT: {
                        rv.set(this.map, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case UNREADABLE: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) is not readable : %s", k, cstatus);
                        break;
                    }
                    default: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) Unknown response : %s", k, cstatus);
                    }
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotData(String key, String subkey, int flags, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                byte[] bkey = BTreeUtil.hexStringToByteArrays(subkey);
                Element element = new Element(bkey, tc.decode(new CachedData(flags, data, tc.getMaxSize())), collectionGet.getElementFlag());
                this.map.put(new ByteArrayBKey(bkey), element);
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    @Override
    public CollectionFuture<Map<Integer, Element<Object>>> asyncBopGetByPosition(String key, BTreeOrder order, int pos) {
        BTreeGetByPosition get = new BTreeGetByPosition(order, pos);
        boolean reverse = false;
        return this.asyncBopGetByPosition(key, get, reverse, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, Element<T>>> asyncBopGetByPosition(String key, BTreeOrder order, int pos, Transcoder<T> tc) {
        BTreeGetByPosition get = new BTreeGetByPosition(order, pos);
        boolean reverse = false;
        return this.asyncBopGetByPosition(key, get, reverse, tc);
    }

    @Override
    public CollectionFuture<Map<Integer, Element<Object>>> asyncBopGetByPosition(String key, BTreeOrder order, int from, int to) {
        BTreeGetByPosition get = new BTreeGetByPosition(order, from, to);
        boolean reverse = from > to;
        return this.asyncBopGetByPosition(key, get, reverse, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, Element<T>>> asyncBopGetByPosition(String key, BTreeOrder order, int from, int to, Transcoder<T> tc) {
        BTreeGetByPosition get = new BTreeGetByPosition(order, from, to);
        boolean reverse = from > to;
        return this.asyncBopGetByPosition(key, get, reverse, tc);
    }

    private <T> CollectionFuture<Map<Integer, Element<T>>> asyncBopGetByPosition(final String k, BTreeGetByPosition get, final boolean reverse, final Transcoder<T> tc) {
        if (get.getOrder() == null) {
            throw new IllegalArgumentException("BTreeOrder must not be null.");
        }
        if (get.getPosFrom() < 0 || get.getPosTo() < 0) {
            throw new IllegalArgumentException("Position must be 0 or positive integer.");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Map<Integer, Element<T>>> rv = new CollectionFuture<Map<Integer, Element<T>>>(latch, this.operationTimeout);
        BTreeGetByPositionOperation op = this.opFact.bopGetByPosition(k, get, new BTreeGetByPositionOperation.Callback(){
            private final TreeMap<Integer, Element<T>> map;
            {
                this.map = new TreeMap(reverse ? Collections.reverseOrder() : null);
            }

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(this.map, cstatus);
                    return;
                }
                switch (cstatus.getResponse()) {
                    case NOT_FOUND: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case NOT_FOUND_ELEMENT: {
                        rv.set(this.map, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case UNREADABLE: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) is not readable : %s", k, cstatus);
                        break;
                    }
                    case TYPE_MISMATCH: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) is not a B+Tree : %s", k, cstatus);
                        break;
                    }
                    default: {
                        ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    }
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotData(String key, int flags, int pos, BKeyObject bkeyObject, byte[] eflag, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                Element element = ArcusClient.this.makeBTreeElement(key, flags, bkeyObject, eflag, data, tc);
                if (element != null) {
                    this.map.put(pos, element);
                }
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    @Override
    public CollectionFuture<Integer> asyncBopFindPosition(String key, long longBKey, BTreeOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("BTreeOrder must not be null.");
        }
        BTreeFindPosition get = new BTreeFindPosition(longBKey, order);
        return this.asyncBopFindPosition(key, get);
    }

    @Override
    public CollectionFuture<Integer> asyncBopFindPosition(String key, byte[] byteArrayBKey, BTreeOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("BTreeOrder must not be null.");
        }
        BTreeFindPosition get = new BTreeFindPosition(byteArrayBKey, order);
        return this.asyncBopFindPosition(key, get);
    }

    private CollectionFuture<Integer> asyncBopFindPosition(final String k, final BTreeFindPosition get) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Integer> rv = new CollectionFuture<Integer>(latch, this.operationTimeout);
        BTreeFindPositionOperation op = this.opFact.bopFindPosition(k, get, new BTreeFindPositionOperation.Callback(){
            private int position = 0;

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(this.position, cstatus);
                    return;
                }
                switch (cstatus.getResponse()) {
                    case NOT_FOUND: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case NOT_FOUND_ELEMENT: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case UNREADABLE: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) is not readable : %s", k, cstatus);
                        break;
                    }
                    case BKEY_MISMATCH: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) has wrong bkey : %s(%s)", new Object[]{k, cstatus, get.getBkeyObject().getType()});
                        break;
                    }
                    case TYPE_MISMATCH: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) is not a B+Tree : %s", k, cstatus);
                        break;
                    }
                    default: {
                        ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    }
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotData(int position) {
                this.position = position;
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    @Override
    public CollectionFuture<Map<Integer, Element<Object>>> asyncBopFindPositionWithGet(String key, long longBKey, BTreeOrder order, int count) {
        BTreeFindPositionWithGet get = new BTreeFindPositionWithGet(longBKey, order, count);
        return this.asyncBopFindPositionWithGet(key, get, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, Element<T>>> asyncBopFindPositionWithGet(String key, long longBKey, BTreeOrder order, int count, Transcoder<T> tc) {
        BTreeFindPositionWithGet get = new BTreeFindPositionWithGet(longBKey, order, count);
        return this.asyncBopFindPositionWithGet(key, get, tc);
    }

    @Override
    public CollectionFuture<Map<Integer, Element<Object>>> asyncBopFindPositionWithGet(String key, byte[] byteArrayBKey, BTreeOrder order, int count) {
        BTreeFindPositionWithGet get = new BTreeFindPositionWithGet(byteArrayBKey, order, count);
        return this.asyncBopFindPositionWithGet(key, get, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, Element<T>>> asyncBopFindPositionWithGet(String key, byte[] byteArrayBKey, BTreeOrder order, int count, Transcoder<T> tc) {
        BTreeFindPositionWithGet get = new BTreeFindPositionWithGet(byteArrayBKey, order, count);
        return this.asyncBopFindPositionWithGet(key, get, tc);
    }

    private <T> CollectionFuture<Map<Integer, Element<T>>> asyncBopFindPositionWithGet(final String k, final BTreeFindPositionWithGet get, final Transcoder<T> tc) {
        if (get.getOrder() == null) {
            throw new IllegalArgumentException("BTreeOrder must not be null.");
        }
        if (get.getCount() < 0 || get.getCount() > 100) {
            throw new IllegalArgumentException("Count must be a value between 0 and 100.");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Map<Integer, Element<T>>> rv = new CollectionFuture<Map<Integer, Element<T>>>(latch, this.operationTimeout);
        BTreeFindPositionWithGetOperation op = this.opFact.bopFindPositionWithGet(k, get, new BTreeFindPositionWithGetOperation.Callback(){
            private final TreeMap<Integer, Element<T>> map = new TreeMap();

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(this.map, cstatus);
                    return;
                }
                switch (cstatus.getResponse()) {
                    case NOT_FOUND: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Key(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case NOT_FOUND_ELEMENT: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Element(%s) not found : %s", k, cstatus);
                        break;
                    }
                    case UNREADABLE: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) is not readable : %s", k, cstatus);
                        break;
                    }
                    case BKEY_MISMATCH: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) has wrong bkey : %s(%s)", new Object[]{k, cstatus, get.getBkeyObject().getType()});
                        break;
                    }
                    case TYPE_MISMATCH: {
                        rv.set(null, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Collection(%s) is not a B+Tree : %s", k, cstatus);
                        break;
                    }
                    default: {
                        ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    }
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotData(String key, int flags, int pos, BKeyObject bkeyObject, byte[] eflag, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                Element element = ArcusClient.this.makeBTreeElement(key, flags, bkeyObject, eflag, data, tc);
                if (element != null) {
                    this.map.put(pos, element);
                }
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    @Override
    public BTreeStoreAndGetFuture<Boolean, Object> asyncBopInsertAndGetTrimmed(String key, long bkey, byte[] eFlag, Object value, CollectionAttributes attributesForCreate) {
        BTreeInsertAndGet<Object> insertAndGet = new BTreeInsertAndGet<Object>(BTreeInsertAndGet.Command.INSERT, bkey, eFlag, value, attributesForCreate);
        return this.asyncBTreeInsertAndGet(key, insertAndGet, this.collectionTranscoder);
    }

    @Override
    public <E> BTreeStoreAndGetFuture<Boolean, E> asyncBopInsertAndGetTrimmed(String key, long bkey, byte[] eFlag, E value, CollectionAttributes attributesForCreate, Transcoder<E> transcoder) {
        BTreeInsertAndGet<E> insertAndGet = new BTreeInsertAndGet<E>(BTreeInsertAndGet.Command.INSERT, bkey, eFlag, value, attributesForCreate);
        return this.asyncBTreeInsertAndGet(key, insertAndGet, transcoder);
    }

    @Override
    public BTreeStoreAndGetFuture<Boolean, Object> asyncBopInsertAndGetTrimmed(String key, byte[] bkey, byte[] eFlag, Object value, CollectionAttributes attributesForCreate) {
        BTreeInsertAndGet<Object> insertAndGet = new BTreeInsertAndGet<Object>(BTreeInsertAndGet.Command.INSERT, bkey, eFlag, value, attributesForCreate);
        return this.asyncBTreeInsertAndGet(key, insertAndGet, this.collectionTranscoder);
    }

    @Override
    public <E> BTreeStoreAndGetFuture<Boolean, E> asyncBopInsertAndGetTrimmed(String key, byte[] bkey, byte[] eFlag, E value, CollectionAttributes attributesForCreate, Transcoder<E> transcoder) {
        BTreeInsertAndGet<E> insertAndGet = new BTreeInsertAndGet<E>(BTreeInsertAndGet.Command.INSERT, bkey, eFlag, value, attributesForCreate);
        return this.asyncBTreeInsertAndGet(key, insertAndGet, transcoder);
    }

    @Override
    public BTreeStoreAndGetFuture<Boolean, Object> asyncBopUpsertAndGetTrimmed(String key, long bkey, byte[] eFlag, Object value, CollectionAttributes attributesForCreate) {
        BTreeInsertAndGet<Object> insertAndGet = new BTreeInsertAndGet<Object>(BTreeInsertAndGet.Command.UPSERT, bkey, eFlag, value, attributesForCreate);
        return this.asyncBTreeInsertAndGet(key, insertAndGet, this.collectionTranscoder);
    }

    @Override
    public <E> BTreeStoreAndGetFuture<Boolean, E> asyncBopUpsertAndGetTrimmed(String key, long bkey, byte[] eFlag, E value, CollectionAttributes attributesForCreate, Transcoder<E> transcoder) {
        BTreeInsertAndGet<E> insertAndGet = new BTreeInsertAndGet<E>(BTreeInsertAndGet.Command.UPSERT, bkey, eFlag, value, attributesForCreate);
        return this.asyncBTreeInsertAndGet(key, insertAndGet, transcoder);
    }

    @Override
    public BTreeStoreAndGetFuture<Boolean, Object> asyncBopUpsertAndGetTrimmed(String key, byte[] bkey, byte[] eFlag, Object value, CollectionAttributes attributesForCreate) {
        BTreeInsertAndGet<Object> insertAndGet = new BTreeInsertAndGet<Object>(BTreeInsertAndGet.Command.UPSERT, bkey, eFlag, value, attributesForCreate);
        return this.asyncBTreeInsertAndGet(key, insertAndGet, this.collectionTranscoder);
    }

    @Override
    public <E> BTreeStoreAndGetFuture<Boolean, E> asyncBopUpsertAndGetTrimmed(String key, byte[] bkey, byte[] eFlag, E value, CollectionAttributes attributesForCreate, Transcoder<E> transcoder) {
        BTreeInsertAndGet<E> insertAndGet = new BTreeInsertAndGet<E>(BTreeInsertAndGet.Command.UPSERT, bkey, eFlag, value, attributesForCreate);
        return this.asyncBTreeInsertAndGet(key, insertAndGet, transcoder);
    }

    private <E> BTreeStoreAndGetFuture<Boolean, E> asyncBTreeInsertAndGet(final String k, BTreeInsertAndGet<E> get, final Transcoder<E> tc) {
        CachedData co = tc.encode(get.getValue());
        get.setFlags(co.getFlags());
        final CountDownLatch latch = new CountDownLatch(1);
        final BTreeStoreAndGetFuture rv = new BTreeStoreAndGetFuture(latch, this.operationTimeout);
        BTreeInsertAndGetOperation op = this.opFact.bopInsertAndGet(k, get, co.getData(), new BTreeInsertAndGetOperation.Callback(){
            private Element<E> element = null;

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                if (cstatus.isSuccess()) {
                    rv.set(true, cstatus);
                    rv.setElement(this.element);
                    return;
                }
                switch (cstatus.getResponse()) {
                    case NOT_FOUND: 
                    case OUT_OF_RANGE: 
                    case TYPE_MISMATCH: 
                    case BKEY_MISMATCH: 
                    case ELEMENT_EXISTS: 
                    case OVERFLOWED: {
                        rv.set(false, cstatus);
                        if (!ArcusClient.this.getLogger().isDebugEnabled()) break;
                        ArcusClient.this.getLogger().debug("Request for \"%s\" was not successful : %s", k, cstatus);
                        break;
                    }
                    default: {
                        ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    }
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotData(String key, int flags, BKeyObject bkeyObject, byte[] eflag, byte[] data) {
                assert (key.equals(k)) : "Wrong key returned";
                this.element = ArcusClient.this.makeBTreeElement(key, flags, bkeyObject, eflag, data, tc);
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    private <T> Element<T> makeBTreeElement(String key, int flags, BKeyObject bkey, byte[] eflag, byte[] data, Transcoder<T> tc) {
        Element<T> element = null;
        T value = tc.decode(new CachedData(flags, data, tc.getMaxSize()));
        switch (bkey.getType()) {
            case LONG: {
                element = new Element<T>((long)bkey.getLongBKey(), value, eflag);
                break;
            }
            case BYTEARRAY: {
                element = new Element<T>(bkey.getByteArrayBKeyRaw(), value, eflag);
                break;
            }
            default: {
                this.getLogger().error("Unexpected bkey type : (key:" + key + ", bkey:" + bkey.toString() + ")");
            }
        }
        return element;
    }

    @Override
    public CollectionFuture<Boolean> asyncBopDelete(String key, byte[] from, byte[] to, ElementFlagFilter eFlagFilter, int count, boolean dropIfEmpty) {
        BTreeDelete delete = new BTreeDelete(from, to, count, false, dropIfEmpty, eFlagFilter);
        return this.asyncCollectionDelete(key, delete);
    }

    @Override
    public CollectionFuture<Boolean> asyncBopDelete(String key, byte[] bkey, ElementFlagFilter eFlagFilter, boolean dropIfEmpty) {
        BTreeDelete delete = new BTreeDelete(bkey, false, dropIfEmpty, eFlagFilter);
        return this.asyncCollectionDelete(key, delete);
    }

    @Override
    public CollectionFuture<Boolean> asyncBopUpsert(String key, byte[] bkey, byte[] elementFlag, Object value, CollectionAttributes attributesForCreate) {
        BTreeUpsert<Object> bTreeUpsert = new BTreeUpsert<Object>(value, elementFlag, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, BTreeUtil.toHex(bkey), bTreeUpsert, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Boolean> asyncBopUpsert(String key, byte[] bkey, byte[] elementFlag, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        BTreeUpsert<T> bTreeUpsert = new BTreeUpsert<T>(value, elementFlag, attributesForCreate != null, null, attributesForCreate);
        return this.asyncCollectionInsert(key, BTreeUtil.toHex(bkey), bTreeUpsert, tc);
    }

    @Override
    public CollectionFuture<Integer> asyncBopGetItemCount(String key, byte[] from, byte[] to, ElementFlagFilter eFlagFilter) {
        BTreeCount collectionCount = new BTreeCount(from, to, eFlagFilter);
        return this.asyncCollectionCount(key, collectionCount);
    }

    @Override
    public CollectionFuture<Map<Object, Boolean>> asyncSopPipedExistBulk(String key, List<Object> values) {
        SetPipedExist<Object> exist = new SetPipedExist<Object>(key, values, this.collectionTranscoder);
        return this.asyncSetPipedExist(key, exist);
    }

    @Override
    public <T> CollectionFuture<Map<T, Boolean>> asyncSopPipedExistBulk(String key, List<T> values, Transcoder<T> tc) {
        SetPipedExist<T> exist = new SetPipedExist<T>(key, values, tc);
        return this.asyncSetPipedExist(key, exist);
    }

    <T> CollectionFuture<Map<T, Boolean>> asyncSetPipedExist(String key, final SetPipedExist<T> exist) {
        if (exist.getItemCount() == 0) {
            throw new IllegalArgumentException("The number of piped operations must be larger than 0.");
        }
        if (exist.getItemCount() > 500) {
            throw new IllegalArgumentException("The number of piped operations must not exceed a maximum of 500.");
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Map<T, Boolean>> rv = new CollectionFuture<Map<T, Boolean>>(latch, this.operationTimeout);
        CollectionPipedExistOperation op = this.opFact.collectionPipedExist(key, exist, new CollectionPipedExistOperation.Callback(){
            private final Map<T, Boolean> result = new HashMap();
            private boolean hasAnError = false;

            @Override
            public void receivedStatus(OperationStatus status) {
                CollectionOperationStatus cstatus;
                if (this.hasAnError) {
                    return;
                }
                if (status instanceof CollectionOperationStatus) {
                    cstatus = (CollectionOperationStatus)status;
                } else {
                    ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    cstatus = new CollectionOperationStatus(status);
                }
                rv.set(this.result, cstatus);
            }

            @Override
            public void complete() {
                latch.countDown();
            }

            @Override
            public void gotStatus(Integer index, OperationStatus status) {
                CollectionOperationStatus cstatus = status instanceof CollectionOperationStatus ? (CollectionOperationStatus)status : new CollectionOperationStatus(status);
                switch (cstatus.getResponse()) {
                    case EXIST: 
                    case NOT_EXIST: {
                        this.result.put(exist.getValues().get(index), CollectionResponse.EXIST.equals((Object)cstatus.getResponse()));
                        break;
                    }
                    case NOT_FOUND: 
                    case UNREADABLE: 
                    case TYPE_MISMATCH: {
                        this.hasAnError = true;
                        rv.set(new HashMap(0), (CollectionOperationStatus)status);
                        break;
                    }
                    default: {
                        ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                    }
                }
            }
        });
        rv.setOperation(op);
        this.addOp(key, op);
        return rv;
    }

    @Override
    public CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncBopPipedInsertBulk(String key, List<Element<Object>> elements, CollectionAttributes attributesForCreate) {
        return this.asyncBopPipedInsertBulk(key, elements, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncBopPipedInsertBulk(String key, List<Element<T>> elements, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        if (elements.size() <= 500) {
            CollectionPipedInsert.ByteArraysBTreePipedInsert<T> insert = new CollectionPipedInsert.ByteArraysBTreePipedInsert<T>(key, elements, attributesForCreate != null, attributesForCreate, tc);
            return this.asyncCollectionPipedInsert(key, insert);
        }
        PartitionedList<Element<T>> list = new PartitionedList<Element<T>>(elements, 500);
        ArrayList<CollectionPipedInsert<T>> insertList = new ArrayList<CollectionPipedInsert<T>>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            insertList.add(new CollectionPipedInsert.ByteArraysBTreePipedInsert<T>(key, list.get(i), attributesForCreate != null, attributesForCreate, tc));
        }
        return this.asyncCollectionPipedInsert(key, insertList);
    }

    @Override
    public SMGetFuture<List<SMGetElement<Object>>> asyncBopSortMergeGet(List<String> keyList, byte[] from, byte[] to, ElementFlagFilter eFlagFilter, int offset, int count) {
        if (keyList == null || keyList.isEmpty()) {
            throw new IllegalArgumentException("Key list is empty.");
        }
        if (count < 1) {
            throw new IllegalArgumentException("Count must be larger than 0.");
        }
        if (offset + count > 1000) {
            throw new IllegalArgumentException("The sum of offset and count must not exceed a maximum of 1000.");
        }
        Map<String, List<String>> arrangedKey = this.groupingKeys(keyList, this.smgetKeyChunkSize);
        ArrayList smGetList = new ArrayList(arrangedKey.size());
        for (List<String> v : arrangedKey.values()) {
            if (arrangedKey.size() > 1) {
                smGetList.add(new BTreeSMGetWithByteTypeBkeyOld(v, from, to, eFlagFilter, 0, offset + count));
                continue;
            }
            smGetList.add(new BTreeSMGetWithByteTypeBkeyOld(v, from, to, eFlagFilter, offset, count));
        }
        return this.smget(smGetList, offset, count, BTreeUtil.compareByteArraysInLexOrder(from, to) > 0, this.collectionTranscoder);
    }

    @Override
    public SMGetFuture<List<SMGetElement<Object>>> asyncBopSortMergeGet(List<String> keyList, byte[] from, byte[] to, ElementFlagFilter eFlagFilter, int count, SMGetMode smgetMode) {
        if (keyList == null || keyList.isEmpty()) {
            throw new IllegalArgumentException("Key list is empty.");
        }
        if (count < 1) {
            throw new IllegalArgumentException("Count must be larger than 0.");
        }
        if (count > 1000) {
            throw new IllegalArgumentException("The count must not exceed a maximum of 1000.");
        }
        Map<String, List<String>> arrangedKey = this.groupingKeys(keyList, this.smgetKeyChunkSize);
        ArrayList smGetList = new ArrayList(arrangedKey.size());
        for (List<String> v : arrangedKey.values()) {
            smGetList.add(new BTreeSMGetWithByteTypeBkey(v, from, to, eFlagFilter, count, smgetMode));
        }
        return this.smget(smGetList, count, BTreeUtil.compareByteArraysInLexOrder(from, to) > 0, this.collectionTranscoder, smgetMode);
    }

    <T> CollectionFuture<Map<Integer, CollectionOperationStatus>> asyncCollectionPipedInsert(String key, List<CollectionPipedInsert<T>> insertList) {
        final ConcurrentLinkedQueue<CollectionPipedInsertOperation> ops = new ConcurrentLinkedQueue<CollectionPipedInsertOperation>();
        final CountDownLatch latch = new CountDownLatch(insertList.size());
        final List mergedOperationStatus = Collections.synchronizedList(new ArrayList(1));
        final ConcurrentHashMap mergedResult = new ConcurrentHashMap();
        int i = 0;
        while (i < insertList.size()) {
            CollectionPipedInsert<T> insert = insertList.get(i);
            final int idx = i++;
            CollectionPipedInsertOperation op = this.opFact.collectionPipedInsert(key, insert, new CollectionPipedInsertOperation.Callback(){

                @Override
                public void receivedStatus(OperationStatus status) {
                    CollectionOperationStatus cstatus;
                    if (status instanceof CollectionOperationStatus) {
                        cstatus = (CollectionOperationStatus)status;
                    } else {
                        ArcusClient.this.getLogger().warn("Unhandled state: " + status);
                        cstatus = new CollectionOperationStatus(status);
                    }
                    mergedOperationStatus.add(cstatus);
                }

                @Override
                public void complete() {
                    latch.countDown();
                }

                @Override
                public void gotStatus(Integer index, OperationStatus status) {
                    if (status instanceof CollectionOperationStatus) {
                        mergedResult.put(index + idx * 500, (CollectionOperationStatus)status);
                    } else {
                        mergedResult.put(index + idx * 500, new CollectionOperationStatus(status));
                    }
                }
            });
            this.addOp(key, op);
            ops.add(op);
        }
        return new CollectionFuture<Map<Integer, CollectionOperationStatus>>(latch, this.operationTimeout){

            @Override
            public boolean cancel(boolean ign) {
                boolean rv = false;
                for (Operation op : ops) {
                    op.cancel("by application.");
                    rv |= op.getState() == OperationState.WRITE_QUEUED;
                }
                return rv;
            }

            @Override
            public boolean isCancelled() {
                for (Operation op : ops) {
                    if (!op.isCancelled()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map<Integer, CollectionOperationStatus> get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
                if (!this.latch.await(duration, units)) {
                    for (Operation op : ops) {
                        MemcachedConnection.opTimedOut(op);
                    }
                    throw new CheckedOperationTimeoutException("Timed out waiting for operation >" + duration + " " + (Object)((Object)units), ops);
                }
                for (Operation op : ops) {
                    MemcachedConnection.opSucceeded(op);
                }
                for (Operation op : ops) {
                    if (op != null && op.hasErrored()) {
                        throw new ExecutionException(op.getException());
                    }
                    if (op == null || !op.isCancelled()) continue;
                    throw new ExecutionException(new RuntimeException(op.getCancelCause()));
                }
                return mergedResult;
            }

            @Override
            public CollectionOperationStatus getOperationStatus() {
                for (OperationStatus status : mergedOperationStatus) {
                    if (status.isSuccess()) continue;
                    return new CollectionOperationStatus(status);
                }
                return new CollectionOperationStatus(true, "END", CollectionResponse.END);
            }

            @Override
            public boolean isDone() {
                for (Operation op : ops) {
                    if (op.getState() == OperationState.COMPLETE || op.isCancelled()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public Future<Map<String, CollectionOperationStatus>> asyncBopInsertBulk(List<String> keyList, long bkey, byte[] eFlag, Object value, CollectionAttributes attributesForCreate) {
        return this.asyncBopInsertBulk(keyList, bkey, eFlag, value, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public <T> Future<Map<String, CollectionOperationStatus>> asyncBopInsertBulk(List<String> keyList, long bkey, byte[] eFlag, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        Map<String, List<String>> arrangedKey = this.groupingKeys(keyList, 500);
        ArrayList<CollectionBulkInsert<T>> insertList = new ArrayList<CollectionBulkInsert<T>>(arrangedKey.size());
        for (List<String> eachKeyList : arrangedKey.values()) {
            insertList.add(new CollectionBulkInsert.BTreeBulkInsert<T>(eachKeyList, bkey, eFlag, value, attributesForCreate, tc));
        }
        return this.asyncCollectionInsertBulk2(insertList);
    }

    @Override
    public Future<Map<String, CollectionOperationStatus>> asyncBopInsertBulk(List<String> keyList, byte[] bkey, byte[] eFlag, Object value, CollectionAttributes attributesForCreate) {
        return this.asyncBopInsertBulk(keyList, bkey, eFlag, value, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public <T> Future<Map<String, CollectionOperationStatus>> asyncBopInsertBulk(List<String> keyList, byte[] bkey, byte[] eFlag, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        Map<String, List<String>> arrangedKey = this.groupingKeys(keyList, 500);
        ArrayList<CollectionBulkInsert<T>> insertList = new ArrayList<CollectionBulkInsert<T>>(arrangedKey.size());
        for (List<String> eachKeyList : arrangedKey.values()) {
            insertList.add(new CollectionBulkInsert.BTreeBulkInsert<T>(eachKeyList, bkey, eFlag, value, attributesForCreate, tc));
        }
        return this.asyncCollectionInsertBulk2(insertList);
    }

    @Override
    public Future<Map<String, CollectionOperationStatus>> asyncMopInsertBulk(List<String> keyList, String mkey, Object value, CollectionAttributes attributesForCreate) {
        return this.asyncMopInsertBulk(keyList, mkey, value, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public <T> Future<Map<String, CollectionOperationStatus>> asyncMopInsertBulk(List<String> keyList, String mkey, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        this.validateMKey(mkey);
        Map<String, List<String>> arrangedKey = this.groupingKeys(keyList, 500);
        ArrayList<CollectionBulkInsert<T>> insertList = new ArrayList<CollectionBulkInsert<T>>(arrangedKey.size());
        for (List<String> eachKeyList : arrangedKey.values()) {
            insertList.add(new CollectionBulkInsert.MapBulkInsert<T>(eachKeyList, mkey, value, attributesForCreate, tc));
        }
        return this.asyncCollectionInsertBulk2(insertList);
    }

    @Override
    public Future<Map<String, CollectionOperationStatus>> asyncSopInsertBulk(List<String> keyList, Object value, CollectionAttributes attributesForCreate) {
        return this.asyncSopInsertBulk(keyList, value, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public <T> Future<Map<String, CollectionOperationStatus>> asyncSopInsertBulk(List<String> keyList, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        Map<String, List<String>> arrangedKey = this.groupingKeys(keyList, 500);
        ArrayList<CollectionBulkInsert<T>> insertList = new ArrayList<CollectionBulkInsert<T>>(arrangedKey.size());
        for (List<String> eachKeyList : arrangedKey.values()) {
            insertList.add(new CollectionBulkInsert.SetBulkInsert<T>(eachKeyList, value, attributesForCreate, tc));
        }
        return this.asyncCollectionInsertBulk2(insertList);
    }

    @Override
    public Future<Map<String, CollectionOperationStatus>> asyncLopInsertBulk(List<String> keyList, int index, Object value, CollectionAttributes attributesForCreate) {
        return this.asyncLopInsertBulk(keyList, index, value, attributesForCreate, this.collectionTranscoder);
    }

    @Override
    public <T> Future<Map<String, CollectionOperationStatus>> asyncLopInsertBulk(List<String> keyList, int index, T value, CollectionAttributes attributesForCreate, Transcoder<T> tc) {
        Map<String, List<String>> arrangedKey = this.groupingKeys(keyList, 500);
        ArrayList<CollectionBulkInsert<T>> insertList = new ArrayList<CollectionBulkInsert<T>>(arrangedKey.size());
        for (List<String> eachKeyList : arrangedKey.values()) {
            insertList.add(new CollectionBulkInsert.ListBulkInsert<T>(eachKeyList, index, value, attributesForCreate, tc));
        }
        return this.asyncCollectionInsertBulk2(insertList);
    }

    private <T> Future<Map<String, CollectionOperationStatus>> asyncCollectionInsertBulk2(List<CollectionBulkInsert<T>> insertList) {
        final ConcurrentLinkedQueue<CollectionBulkInsertOperation> ops = new ConcurrentLinkedQueue<CollectionBulkInsertOperation>();
        final ConcurrentHashMap failedResult = new ConcurrentHashMap();
        final CountDownLatch latch = new CountDownLatch(insertList.size());
        for (final CollectionBulkInsert<T> insert : insertList) {
            CollectionBulkInsertOperation op = this.opFact.collectionBulkInsert(insert.getKeyList(), insert, new CollectionBulkInsertOperation.Callback(){

                @Override
                public void receivedStatus(OperationStatus status) {
                }

                @Override
                public void complete() {
                    latch.countDown();
                }

                @Override
                public void gotStatus(Integer index, OperationStatus status) {
                    if (!status.isSuccess()) {
                        if (status instanceof CollectionOperationStatus) {
                            failedResult.put(insert.getKeyList().get(index), (CollectionOperationStatus)status);
                        } else {
                            failedResult.put(insert.getKeyList().get(index), new CollectionOperationStatus(status));
                        }
                    }
                }
            });
            ops.add(op);
            this.addOp(insert.getKeyList().get(0), op);
        }
        return new CollectionFuture<Map<String, CollectionOperationStatus>>(latch, this.operationTimeout){

            @Override
            public boolean cancel(boolean ign) {
                boolean rv = false;
                for (Operation op : ops) {
                    op.cancel("by application.");
                    rv |= op.getState() == OperationState.WRITE_QUEUED;
                }
                return rv;
            }

            @Override
            public boolean isCancelled() {
                for (Operation op : ops) {
                    if (!op.isCancelled()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Map<String, CollectionOperationStatus> get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
                if (!this.latch.await(duration, units)) {
                    for (Operation op : ops) {
                        MemcachedConnection.opTimedOut(op);
                    }
                    throw new CheckedOperationTimeoutException("Timed out waiting for bulk operation >" + duration + " " + (Object)((Object)units), ops);
                }
                for (Operation op : ops) {
                    MemcachedConnection.opSucceeded(op);
                }
                for (Operation op : ops) {
                    if (op != null && op.hasErrored()) {
                        throw new ExecutionException(op.getException());
                    }
                    if (op == null || !op.isCancelled()) continue;
                    throw new ExecutionException(new RuntimeException(op.getCancelCause()));
                }
                return failedResult;
            }

            @Override
            public CollectionOperationStatus getOperationStatus() {
                return null;
            }

            @Override
            public boolean isDone() {
                for (Operation op : ops) {
                    if (op.getState() == OperationState.COMPLETE || op.isCancelled()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public CollectionGetBulkFuture<Map<String, BTreeGetResult<Long, Object>>> asyncBopGetBulk(List<String> keyList, long from, long to, ElementFlagFilter eFlagFilter, int offset, int count) {
        return this.asyncBopGetBulk(keyList, from, to, eFlagFilter, offset, count, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionGetBulkFuture<Map<String, BTreeGetResult<Long, T>>> asyncBopGetBulk(List<String> keyList, long from, long to, ElementFlagFilter eFlagFilter, int offset, int count, Transcoder<T> tc) {
        if (keyList == null) {
            throw new IllegalArgumentException("Key list is null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be 0 or positive integer.");
        }
        if (count > 50) {
            throw new IllegalArgumentException("Count must not exceed a maximum of 50.");
        }
        Map<String, List<String>> rearrangedKeys = this.groupingKeys(keyList, 200);
        ArrayList<BTreeGetBulk<T>> getBulkList = new ArrayList<BTreeGetBulk<T>>(rearrangedKeys.size());
        for (Map.Entry<String, List<String>> entry : rearrangedKeys.entrySet()) {
            getBulkList.add(new BTreeGetBulkWithLongTypeBkey(entry.getValue(), from, to, eFlagFilter, offset, count));
        }
        return this.btreeGetBulk(getBulkList, offset, count, from > to, tc);
    }

    @Override
    public CollectionGetBulkFuture<Map<String, BTreeGetResult<ByteArrayBKey, Object>>> asyncBopGetBulk(List<String> keyList, byte[] from, byte[] to, ElementFlagFilter eFlagFilter, int offset, int count) {
        return this.asyncBopGetBulk(keyList, from, to, eFlagFilter, offset, count, this.collectionTranscoder);
    }

    @Override
    public <T> CollectionGetBulkFuture<Map<String, BTreeGetResult<ByteArrayBKey, T>>> asyncBopGetBulk(List<String> keyList, byte[] from, byte[] to, ElementFlagFilter eFlagFilter, int offset, int count, Transcoder<T> tc) {
        if (keyList == null) {
            throw new IllegalArgumentException("Key list is null.");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be 0 or positive integer.");
        }
        if (count > 50) {
            throw new IllegalArgumentException("Count must not exceed a maximum of 50.");
        }
        Map<String, List<String>> rearrangedKeys = this.groupingKeys(keyList, 200);
        ArrayList<BTreeGetBulk<T>> getBulkList = new ArrayList<BTreeGetBulk<T>>(rearrangedKeys.size());
        for (Map.Entry<String, List<String>> entry : rearrangedKeys.entrySet()) {
            getBulkList.add(new BTreeGetBulkWithByteTypeBkey(entry.getValue(), from, to, eFlagFilter, offset, count));
        }
        boolean reverse = BTreeUtil.compareByteArraysInLexOrder(from, to) > 0;
        return this.btreeGetBulkByteArrayBKey(getBulkList, offset, count, reverse, tc);
    }

    private <T> CollectionGetBulkFuture<Map<String, BTreeGetResult<Long, T>>> btreeGetBulk(List<BTreeGetBulk<T>> getBulkList, int offset, int count, final boolean reverse, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(getBulkList.size());
        ConcurrentLinkedQueue<Operation> ops = new ConcurrentLinkedQueue<Operation>();
        final ConcurrentHashMap result = new ConcurrentHashMap();
        for (BTreeGetBulk<T> getBulk : getBulkList) {
            BTreeGetBulkOperation op = this.opFact.bopGetBulk(getBulk, new BTreeGetBulkOperation.Callback<T>(){

                @Override
                public void receivedStatus(OperationStatus status) {
                }

                @Override
                public void complete() {
                    latch.countDown();
                }

                @Override
                public void gotKey(String key, int elementCount, OperationStatus status) {
                    TreeMap tree = null;
                    if (elementCount > 0) {
                        tree = new TreeMap(reverse ? Collections.reverseOrder() : null);
                    }
                    result.put(key, new BTreeGetResult(tree, new CollectionOperationStatus(status)));
                }

                @Override
                public void gotElement(String key, Object subkey, int flags, byte[] eflag, byte[] data) {
                    ((BTreeGetResult)result.get(key)).addElement(new BTreeElement((Long)subkey, eflag, tc.decode(new CachedData(flags, data, tc.getMaxSize()))));
                }
            });
            ops.add(op);
            this.addOp(getBulk.getRepresentKey(), op);
        }
        return new CollectionGetBulkFuture<Map<String, BTreeGetResult<Long, T>>>(latch, ops, result, this.operationTimeout);
    }

    private <T> CollectionGetBulkFuture<Map<String, BTreeGetResult<ByteArrayBKey, T>>> btreeGetBulkByteArrayBKey(List<BTreeGetBulk<T>> getBulkList, int offset, int count, final boolean reverse, final Transcoder<T> tc) {
        final CountDownLatch latch = new CountDownLatch(getBulkList.size());
        ConcurrentLinkedQueue<Operation> ops = new ConcurrentLinkedQueue<Operation>();
        final ConcurrentHashMap result = new ConcurrentHashMap();
        for (BTreeGetBulk<T> getBulk : getBulkList) {
            BTreeGetBulkOperation op = this.opFact.bopGetBulk(getBulk, new BTreeGetBulkOperation.Callback<T>(){

                @Override
                public void receivedStatus(OperationStatus status) {
                }

                @Override
                public void complete() {
                    latch.countDown();
                }

                @Override
                public void gotKey(String key, int elementCount, OperationStatus status) {
                    ByteArrayTreeMap tree = null;
                    if (elementCount > 0) {
                        tree = new ByteArrayTreeMap(reverse ? Collections.reverseOrder() : null);
                    }
                    result.put(key, new BTreeGetResult(tree, new CollectionOperationStatus(status)));
                }

                @Override
                public void gotElement(String key, Object subkey, int flags, byte[] eflag, byte[] data) {
                    ((BTreeGetResult)result.get(key)).addElement(new BTreeElement(new ByteArrayBKey((byte[])subkey), eflag, tc.decode(new CachedData(flags, data, tc.getMaxSize()))));
                }
            });
            ops.add(op);
            this.addOp(getBulk.getRepresentKey(), op);
        }
        return new CollectionGetBulkFuture<Map<String, BTreeGetResult<ByteArrayBKey, T>>>(latch, ops, result, this.operationTimeout);
    }

    @Override
    public CollectionFuture<Long> asyncBopIncr(String key, long subkey, int by) {
        BTreeMutate collectionMutate = new BTreeMutate(Mutator.incr, by);
        return this.asyncCollectionMutate(key, String.valueOf(subkey), collectionMutate);
    }

    @Override
    public CollectionFuture<Long> asyncBopIncr(String key, byte[] subkey, int by) {
        BTreeMutate collectionMutate = new BTreeMutate(Mutator.incr, by);
        return this.asyncCollectionMutate(key, BTreeUtil.toHex(subkey), collectionMutate);
    }

    @Override
    public CollectionFuture<Long> asyncBopIncr(String key, long subkey, int by, long initial, byte[] eFlag) {
        BTreeMutate collectionMutate = new BTreeMutate(Mutator.incr, by, initial, eFlag);
        return this.asyncCollectionMutate(key, String.valueOf(subkey), collectionMutate);
    }

    @Override
    public CollectionFuture<Long> asyncBopIncr(String key, byte[] subkey, int by, long initial, byte[] eFlag) {
        BTreeMutate collectionMutate = new BTreeMutate(Mutator.incr, by, initial, eFlag);
        return this.asyncCollectionMutate(key, BTreeUtil.toHex(subkey), collectionMutate);
    }

    @Override
    public CollectionFuture<Long> asyncBopDecr(String key, long subkey, int by) {
        BTreeMutate collectionMutate = new BTreeMutate(Mutator.decr, by);
        return this.asyncCollectionMutate(key, String.valueOf(subkey), collectionMutate);
    }

    @Override
    public CollectionFuture<Long> asyncBopDecr(String key, byte[] subkey, int by) {
        BTreeMutate collectionMutate = new BTreeMutate(Mutator.decr, by);
        return this.asyncCollectionMutate(key, BTreeUtil.toHex(subkey), collectionMutate);
    }

    @Override
    public CollectionFuture<Long> asyncBopDecr(String key, long subkey, int by, long initial, byte[] eFlag) {
        BTreeMutate collectionMutate = new BTreeMutate(Mutator.decr, by, initial, eFlag);
        return this.asyncCollectionMutate(key, String.valueOf(subkey), collectionMutate);
    }

    @Override
    public CollectionFuture<Long> asyncBopDecr(String key, byte[] subkey, int by, long initial, byte[] eFlag) {
        BTreeMutate collectionMutate = new BTreeMutate(Mutator.decr, by, initial, eFlag);
        return this.asyncCollectionMutate(key, BTreeUtil.toHex(subkey), collectionMutate);
    }

    private CollectionFuture<Long> asyncCollectionMutate(final String k, final String subkey, CollectionMutate collectionMutate) {
        final CountDownLatch latch = new CountDownLatch(1);
        final CollectionFuture<Long> rv = new CollectionFuture<Long>(latch, this.operationTimeout);
        CollectionMutateOperation op = this.opFact.collectionMutate(k, subkey, collectionMutate, new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                if (status.isSuccess()) {
                    block4: {
                        try {
                            rv.set(new Long(status.getMessage()), new CollectionOperationStatus(new OperationStatus(true, "END")));
                        }
                        catch (NumberFormatException e) {
                            rv.set(null, new CollectionOperationStatus(new OperationStatus(false, status.getMessage())));
                            if (!ArcusClient.this.getLogger().isDebugEnabled()) break block4;
                            ArcusClient.this.getLogger().debug("Key(%s), Bkey(%s) Unknown response : %s", k, subkey, status);
                        }
                    }
                    return;
                }
                rv.set(null, new CollectionOperationStatus(status));
                if (ArcusClient.this.getLogger().isDebugEnabled()) {
                    ArcusClient.this.getLogger().debug("Key(%s), Bkey(%s) Unknown response : %s", k, subkey, status);
                }
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        rv.setOperation(op);
        this.addOp(k, op);
        return rv;
    }

    public static String getVersion() {
        if (VERSION == null) {
            VERSION = "NONE";
            try {
                Enumeration<URL> resEnum = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
                while (resEnum.hasMoreElements()) {
                    Manifest manifest;
                    java.util.jar.Attributes mainAttribs;
                    String version;
                    URL url = resEnum.nextElement();
                    InputStream is = url.openStream();
                    if (is == null || (version = (mainAttribs = (manifest = new Manifest(is)).getMainAttributes()).getValue("Arcusclient-Version")) == null) continue;
                    VERSION = version;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return VERSION;
    }

    static {
        arcusLogger = LoggerFactory.getLogger(ArcusClient.class);
    }
}

