/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedNodeROImpl;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.util.ArcusKetamaNodeLocatorConfiguration;

public class ArcusKetamaNodeLocator
extends SpyObject
implements NodeLocator {
    private final TreeMap<Long, SortedSet<MemcachedNode>> ketamaNodes;
    private final Collection<MemcachedNode> allNodes;
    private final HashAlgorithm hashAlg;
    private final ArcusKetamaNodeLocatorConfiguration config;
    private final Lock lock = new ReentrantLock();

    public ArcusKetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg) {
        this(nodes, alg, new ArcusKetamaNodeLocatorConfiguration());
    }

    public ArcusKetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg, ArcusKetamaNodeLocatorConfiguration conf) {
        this.allNodes = nodes;
        this.hashAlg = alg;
        this.ketamaNodes = new TreeMap();
        this.config = conf;
        int numReps = this.config.getNodeRepetitions();
        if (alg == HashAlgorithm.KETAMA_HASH) {
            for (MemcachedNode node : nodes) {
                this.updateHash(node, false);
            }
        } else {
            for (MemcachedNode node : nodes) {
                for (int i = 0; i < numReps; ++i) {
                    long nodeHashKey = this.hashAlg.hash(this.config.getKeyForNode(node, i));
                    SortedSet<MemcachedNode> nodeSet = this.ketamaNodes.get(nodeHashKey);
                    if (nodeSet == null) {
                        nodeSet = new TreeSet<MemcachedNode>(this.config.new ArcusKetamaNodeLocatorConfiguration.NodeNameComparator());
                        this.ketamaNodes.put(nodeHashKey, nodeSet);
                    }
                    nodeSet.add(node);
                }
            }
        }
        assert (this.ketamaNodes.size() <= numReps * nodes.size());
    }

    private ArcusKetamaNodeLocator(TreeMap<Long, SortedSet<MemcachedNode>> smn, Collection<MemcachedNode> an, HashAlgorithm alg, ArcusKetamaNodeLocatorConfiguration conf) {
        this.ketamaNodes = smn;
        this.allNodes = an;
        this.hashAlg = alg;
        this.config = conf;
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return this.allNodes;
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        return this.getNodeForKey(this.hashAlg.hash(k));
    }

    long getMaxKey() {
        return this.ketamaNodes.lastKey();
    }

    MemcachedNode getNodeForKey(long hash) {
        MemcachedNode rv = null;
        this.lock.lock();
        try {
            if (!this.ketamaNodes.isEmpty()) {
                if (!this.ketamaNodes.containsKey(hash)) {
                    Long nodeHash = this.ketamaNodes.ceilingKey(hash);
                    hash = nodeHash == null ? this.ketamaNodes.firstKey().longValue() : nodeHash.longValue();
                }
                rv = this.ketamaNodes.get(hash).first();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
        return rv;
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return new KetamaIterator(k, this.allNodes.size());
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        TreeMap<Long, SortedSet<MemcachedNode>> smn = new TreeMap<Long, SortedSet<MemcachedNode>>((SortedMap<Long, SortedSet<MemcachedNode>>)this.ketamaNodes);
        ArrayList<MemcachedNode> an = new ArrayList<MemcachedNode>(this.allNodes.size());
        this.lock.lock();
        try {
            for (Map.Entry<Long, SortedSet<MemcachedNode>> me : smn.entrySet()) {
                TreeSet<MemcachedNode> nodeROSet = new TreeSet<MemcachedNode>(this.config.new ArcusKetamaNodeLocatorConfiguration.NodeNameComparator());
                for (MemcachedNode mn : me.getValue()) {
                    nodeROSet.add(new MemcachedNodeROImpl(mn));
                }
                me.setValue(nodeROSet);
            }
            for (MemcachedNode n : this.allNodes) {
                an.add(new MemcachedNodeROImpl(n));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
        return new ArcusKetamaNodeLocator(smn, an, this.hashAlg, this.config);
    }

    @Override
    public void update(Collection<MemcachedNode> toAttach, Collection<MemcachedNode> toDelete) {
        this.lock.lock();
        try {
            for (MemcachedNode node : toAttach) {
                this.allNodes.add(node);
                this.updateHash(node, false);
            }
            for (MemcachedNode node : toDelete) {
                this.allNodes.remove(node);
                this.updateHash(node, true);
                try {
                    node.getSk().attach(null);
                    node.shutdown();
                }
                catch (IOException e) {
                    this.getLogger().error("Failed to shutdown the node : " + node.toString());
                    node.setSk(null);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void updateHash(MemcachedNode node, boolean remove) {
        if (!remove) {
            this.config.insertNode(node);
        }
        for (int i = 0; i < this.config.getNodeRepetitions() / 4; ++i) {
            byte[] digest = HashAlgorithm.computeMd5(this.config.getKeyForNode(node, i));
            for (int h = 0; h < 4; ++h) {
                Long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
                SortedSet<MemcachedNode> nodeSet = this.ketamaNodes.get(k);
                if (remove) {
                    assert (nodeSet != null);
                    nodeSet.remove(node);
                    if (nodeSet.size() != 0) continue;
                    this.ketamaNodes.remove(k);
                    continue;
                }
                if (nodeSet == null) {
                    nodeSet = new TreeSet<MemcachedNode>(this.config.new ArcusKetamaNodeLocatorConfiguration.NodeNameComparator());
                    this.ketamaNodes.put(k, nodeSet);
                }
                nodeSet.add(node);
            }
        }
        if (remove) {
            this.config.removeNode(node);
        }
    }

    public SortedMap<Long, SortedSet<MemcachedNode>> getKetamaNodes() {
        return Collections.unmodifiableSortedMap(this.ketamaNodes);
    }

    public Collection<MemcachedNode> getAllNodes() {
        return Collections.unmodifiableCollection(this.allNodes);
    }

    class KetamaIterator
    implements Iterator<MemcachedNode> {
        private final String key;
        private long hashVal;
        private int remainingTries;
        private int numTries = 0;

        public KetamaIterator(String k, int t) {
            this.hashVal = ArcusKetamaNodeLocator.this.hashAlg.hash(k);
            this.remainingTries = t;
            this.key = k;
        }

        private void nextHash() {
            long tmpKey = ArcusKetamaNodeLocator.this.hashAlg.hash(this.numTries++ + this.key);
            this.hashVal += (long)((int)(tmpKey ^ tmpKey >>> 32));
            this.hashVal &= 0xFFFFFFFFL;
            --this.remainingTries;
        }

        @Override
        public boolean hasNext() {
            return this.remainingTries > 0;
        }

        @Override
        public MemcachedNode next() {
            try {
                MemcachedNode memcachedNode = ArcusKetamaNodeLocator.this.getNodeForKey(this.hashVal);
                return memcachedNode;
            }
            finally {
                this.nextHash();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

