/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class ArcusMBeanServer {
    private final MBeanServer mbserver = ManagementFactory.getPlatformMBeanServer();

    private ArcusMBeanServer() {
    }

    public static ArcusMBeanServer getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean isRegistered(String name) {
        try {
            return this.mbserver != null && this.mbserver.isRegistered(new ObjectName(name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registMBean(Object o, String name) {
        if (this.isRegistered(name)) {
            return;
        }
        if (this.mbserver != null) {
            try {
                this.mbserver.registerMBean(o, new ObjectName(name));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SingletonHolder {
        private static final ArcusMBeanServer INSTANCE = new ArcusMBeanServer();

        private SingletonHolder() {
        }
    }
}

