/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedNodeROImpl;
import net.spy.memcached.MemcachedReplicaGroup;
import net.spy.memcached.MemcachedReplicaGroupImpl;
import net.spy.memcached.MemcachedReplicaGroupROImpl;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.ReplicaPick;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.util.ArcusReplKetamaNodeLocatorConfiguration;

public class ArcusReplKetamaNodeLocator
extends SpyObject
implements NodeLocator {
    private final TreeMap<Long, SortedSet<MemcachedReplicaGroup>> ketamaGroups;
    private final HashMap<String, MemcachedReplicaGroup> allGroups;
    private final Collection<MemcachedNode> allNodes;
    private final HashAlgorithm hashAlg;
    private final ArcusReplKetamaNodeLocatorConfiguration config;
    private final Lock lock = new ReentrantLock();

    public ArcusReplKetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg) {
        this(nodes, alg, new ArcusReplKetamaNodeLocatorConfiguration());
    }

    private ArcusReplKetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg, ArcusReplKetamaNodeLocatorConfiguration conf) {
        this.allNodes = nodes;
        this.hashAlg = alg;
        this.ketamaGroups = new TreeMap();
        this.allGroups = new HashMap();
        this.config = conf;
        for (MemcachedNode node : nodes) {
            MemcachedReplicaGroup mrg = this.allGroups.get(MemcachedReplicaGroup.getGroupNameForNode(node));
            if (mrg == null) {
                mrg = new MemcachedReplicaGroupImpl(node);
                this.getLogger().info("new memcached replica group added %s", mrg.getGroupName());
                this.allGroups.put(mrg.getGroupName(), mrg);
                continue;
            }
            mrg.setMemcachedNode(node);
        }
        int numReps = this.config.getNodeRepetitions();
        if (alg == HashAlgorithm.KETAMA_HASH) {
            for (MemcachedReplicaGroup group : this.allGroups.values()) {
                this.updateHash(group, false);
            }
        } else {
            for (MemcachedReplicaGroup group : this.allGroups.values()) {
                for (int i = 0; i < numReps; ++i) {
                    long nodeHashKey = this.hashAlg.hash(this.config.getKeyForGroup(group, i));
                    SortedSet<MemcachedReplicaGroup> nodeSet = this.ketamaGroups.get(nodeHashKey);
                    if (nodeSet == null) {
                        nodeSet = new TreeSet<MemcachedReplicaGroup>(new ArcusReplKetamaNodeLocatorConfiguration.MemcachedReplicaGroupComparator());
                        this.ketamaGroups.put(nodeHashKey, nodeSet);
                    }
                    nodeSet.add(group);
                }
            }
        }
        assert (this.ketamaGroups.size() <= numReps * this.allGroups.size());
    }

    private ArcusReplKetamaNodeLocator(TreeMap<Long, SortedSet<MemcachedReplicaGroup>> kg, HashMap<String, MemcachedReplicaGroup> ag, Collection<MemcachedNode> an, HashAlgorithm alg, ArcusReplKetamaNodeLocatorConfiguration conf) {
        this.ketamaGroups = kg;
        this.allGroups = ag;
        this.allNodes = an;
        this.hashAlg = alg;
        this.config = conf;
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return this.allNodes;
    }

    public Map<String, MemcachedReplicaGroup> getAllGroups() {
        return this.allGroups;
    }

    public Collection<MemcachedNode> getMasterNodes() {
        ArrayList<MemcachedNode> masterNodes = new ArrayList<MemcachedNode>(this.allGroups.size());
        for (MemcachedReplicaGroup g : this.allGroups.values()) {
            masterNodes.add(g.getMasterNode());
        }
        return masterNodes;
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        return this.getNodeForKey(this.hashAlg.hash(k), ReplicaPick.MASTER);
    }

    public MemcachedNode getPrimary(String k, ReplicaPick pick) {
        return this.getNodeForKey(this.hashAlg.hash(k), pick);
    }

    public long getMaxKey() {
        return this.ketamaGroups.lastKey();
    }

    private MemcachedNode getNodeForKey(long hash, ReplicaPick pick) {
        MemcachedNode rv = null;
        this.lock.lock();
        try {
            if (!this.ketamaGroups.isEmpty()) {
                if (!this.ketamaGroups.containsKey(hash)) {
                    Long nodeHash = this.ketamaGroups.ceilingKey(hash);
                    hash = nodeHash == null ? this.ketamaGroups.firstKey().longValue() : nodeHash.longValue();
                }
                MemcachedReplicaGroup rg = this.ketamaGroups.get(hash).first();
                rv = rg.getNodeForReplicaPick(pick);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
        return rv;
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return new ReplKetamaIterator(k, ReplicaPick.MASTER, this.allGroups.size());
    }

    public Iterator<MemcachedNode> getSequence(String k, ReplicaPick pick) {
        return new ReplKetamaIterator(k, pick, this.allGroups.size());
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        TreeMap<Long, SortedSet<MemcachedReplicaGroup>> smg = new TreeMap<Long, SortedSet<MemcachedReplicaGroup>>((SortedMap<Long, SortedSet<MemcachedReplicaGroup>>)this.ketamaGroups);
        HashMap<String, MemcachedReplicaGroup> ag = new HashMap<String, MemcachedReplicaGroup>(this.allGroups.size());
        ArrayList<MemcachedNode> an = new ArrayList<MemcachedNode>(this.allNodes.size());
        this.lock.lock();
        try {
            for (Map.Entry<Long, SortedSet<MemcachedReplicaGroup>> entry : smg.entrySet()) {
                TreeSet<MemcachedReplicaGroup> groupROSet = new TreeSet<MemcachedReplicaGroup>(new ArcusReplKetamaNodeLocatorConfiguration.MemcachedReplicaGroupComparator());
                for (MemcachedReplicaGroup mrg : entry.getValue()) {
                    groupROSet.add(new MemcachedReplicaGroupROImpl(mrg));
                }
                entry.setValue(groupROSet);
            }
            for (Map.Entry<Object, Object> entry : this.allGroups.entrySet()) {
                ag.put((String)entry.getKey(), new MemcachedReplicaGroupROImpl((MemcachedReplicaGroup)entry.getValue()));
            }
            for (MemcachedNode memcachedNode : this.allNodes) {
                an.add(new MemcachedNodeROImpl(memcachedNode));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
        return new ArcusReplKetamaNodeLocator(smg, ag, an, this.hashAlg, this.config);
    }

    @Override
    public void update(Collection<MemcachedNode> toAttach, Collection<MemcachedNode> toDelete) {
        this.update(toAttach, toDelete, new ArrayList<MemcachedReplicaGroup>(0));
    }

    public void update(Collection<MemcachedNode> toAttach, Collection<MemcachedNode> toDelete, Collection<MemcachedReplicaGroup> changeRoleGroups) {
        this.lock.lock();
        try {
            MemcachedReplicaGroup mrg;
            for (MemcachedNode node : toDelete) {
                this.allNodes.remove(node);
                mrg = this.allGroups.get(MemcachedReplicaGroup.getGroupNameForNode(node));
                mrg.deleteMemcachedNode(node);
                try {
                    node.getSk().attach(null);
                    node.shutdown();
                }
                catch (IOException e) {
                    this.getLogger().error("Failed to shutdown the node : " + node.toString());
                    node.setSk(null);
                }
            }
            for (MemcachedReplicaGroup g : changeRoleGroups) {
                g.changeRole();
            }
            for (MemcachedNode node : toAttach) {
                this.allNodes.add(node);
                mrg = this.allGroups.get(MemcachedReplicaGroup.getGroupNameForNode(node));
                if (mrg == null) {
                    mrg = new MemcachedReplicaGroupImpl(node);
                    this.getLogger().info("new memcached replica group added %s", mrg.getGroupName());
                    this.allGroups.put(mrg.getGroupName(), mrg);
                    this.updateHash(mrg, false);
                    continue;
                }
                mrg.setMemcachedNode(node);
            }
            ArrayList<MemcachedReplicaGroup> toDeleteGroup = new ArrayList<MemcachedReplicaGroup>();
            for (Map.Entry<String, MemcachedReplicaGroup> entry : this.allGroups.entrySet()) {
                MemcachedReplicaGroup group = entry.getValue();
                if (!group.isEmptyGroup()) continue;
                toDeleteGroup.add(group);
            }
            for (MemcachedReplicaGroup group : toDeleteGroup) {
                this.getLogger().info("old memcached replica group removed %s", group.getGroupName());
                this.allGroups.remove(group.getGroupName());
                this.updateHash(group, true);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void switchoverReplGroup(MemcachedReplicaGroup group) {
        this.lock.lock();
        group.changeRole();
        this.lock.unlock();
    }

    private void updateHash(MemcachedReplicaGroup group, boolean remove) {
        for (int i = 0; i < this.config.getNodeRepetitions() / 4; ++i) {
            byte[] digest = HashAlgorithm.computeMd5(this.config.getKeyForGroup(group, i));
            for (int h = 0; h < 4; ++h) {
                Long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
                SortedSet<MemcachedReplicaGroup> nodeSet = this.ketamaGroups.get(k);
                if (remove) {
                    nodeSet.remove(group);
                    if (nodeSet.size() != 0) continue;
                    this.ketamaGroups.remove(k);
                    continue;
                }
                if (nodeSet == null) {
                    nodeSet = new TreeSet<MemcachedReplicaGroup>(new ArcusReplKetamaNodeLocatorConfiguration.MemcachedReplicaGroupComparator());
                    this.ketamaGroups.put(k, nodeSet);
                }
                nodeSet.add(group);
            }
        }
    }

    private class ReplKetamaIterator
    implements Iterator<MemcachedNode> {
        private final String key;
        private long hashVal;
        private int remainingTries;
        private int numTries = 0;
        private final ReplicaPick pick;

        public ReplKetamaIterator(String k, ReplicaPick p, int t) {
            this.hashVal = ArcusReplKetamaNodeLocator.this.hashAlg.hash(k);
            this.remainingTries = t;
            this.key = k;
            this.pick = p;
        }

        private void nextHash() {
            long tmpKey = ArcusReplKetamaNodeLocator.this.hashAlg.hash(this.numTries++ + this.key);
            this.hashVal += (long)((int)(tmpKey ^ tmpKey >>> 32));
            this.hashVal &= 0xFFFFFFFFL;
            --this.remainingTries;
        }

        @Override
        public boolean hasNext() {
            return this.remainingTries > 0;
        }

        @Override
        public MemcachedNode next() {
            try {
                MemcachedNode memcachedNode = ArcusReplKetamaNodeLocator.this.getNodeForKey(this.hashVal, this.pick);
                return memcachedNode;
            }
            finally {
                this.nextHash();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

