/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.spy.memcached.compat.log.Logger;
import net.spy.memcached.compat.log.LoggerFactory;

public class ArcusReplNodeAddress
extends InetSocketAddress {
    private static final long serialVersionUID = -1555690881482453720L;
    private static final Logger arcusLogger = LoggerFactory.getLogger(ArcusReplNodeAddress.class);
    private boolean master;
    private final String group;
    private final String ip;
    private final int port;

    private ArcusReplNodeAddress(String group, boolean master, String ip, int port) {
        super(ip, port);
        this.group = group;
        this.master = master;
        this.ip = ip;
        this.port = port;
    }

    public ArcusReplNodeAddress(ArcusReplNodeAddress addr) {
        this(addr.group, addr.master, addr.ip, addr.port);
    }

    @Override
    public String toString() {
        return "{" + this.group + " " + (this.master ? "M" : "S") + " " + this.ip + ":" + this.port + "}";
    }

    public String getIPPort() {
        return this.ip + ":" + this.port;
    }

    public String getGroupName() {
        return this.group;
    }

    static ArcusReplNodeAddress create(String group, boolean master, String ipport) {
        String[] temp = ipport.split(":");
        String ip = temp[0];
        int port = Integer.parseInt(temp[1]);
        return new ArcusReplNodeAddress(group, master, ip, port);
    }

    private static List<InetSocketAddress> parseNodeNames(String s) throws Exception {
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        for (String node : s.split(",")) {
            String[] temp = node.split("\\^");
            String group = temp[0];
            boolean master = temp[1].equals("M");
            String ipport = temp[2];
            addrs.add(ArcusReplNodeAddress.create(group, master, ipport));
        }
        return addrs;
    }

    static List<InetSocketAddress> getAddresses(String s) {
        List<InetSocketAddress> list = null;
        if (s != null && !s.isEmpty()) {
            try {
                list = ArcusReplNodeAddress.parseNodeNames(s);
            }
            catch (Exception e) {
                arcusLogger.error("Exception caught while parsing node addresses. cache_list=" + s + "\n" + e);
                e.printStackTrace();
            }
        }
        if (list == null) {
            list = new ArrayList<InetSocketAddress>(0);
        }
        return list;
    }

    static Map<String, List<ArcusReplNodeAddress>> makeGroupAddrsList(List<InetSocketAddress> addrs) {
        HashMap<String, List<ArcusReplNodeAddress>> newAllGroups = new HashMap<String, List<ArcusReplNodeAddress>>();
        for (int i = 0; i < addrs.size(); ++i) {
            ArcusReplNodeAddress arcusReplNodeAddress = (ArcusReplNodeAddress)addrs.get(i);
            String groupName = arcusReplNodeAddress.getGroupName();
            ArrayList<ArcusReplNodeAddress> gNodeList = (ArrayList<ArcusReplNodeAddress>)newAllGroups.get(groupName);
            if (gNodeList == null) {
                gNodeList = new ArrayList<ArcusReplNodeAddress>();
                newAllGroups.put(groupName, gNodeList);
            }
            if (arcusReplNodeAddress.master) {
                gNodeList.add(0, arcusReplNodeAddress);
                continue;
            }
            gNodeList.add(arcusReplNodeAddress);
        }
        for (Map.Entry entry : newAllGroups.entrySet()) {
            List newGroupNodes = (List)entry.getValue();
            if (newGroupNodes.size() >= 3) {
                arcusLogger.error("Invalid group " + (String)entry.getKey() + " : " + " Too many nodes. " + newGroupNodes);
                entry.setValue(new ArrayList());
                continue;
            }
            if (newGroupNodes.size() == 2 && ((ArcusReplNodeAddress)newGroupNodes.get(0)).getIPPort().equals(((ArcusReplNodeAddress)newGroupNodes.get(1)).getIPPort())) {
                arcusLogger.error("Invalid group " + (String)entry.getKey() + " : " + "Two nodes have the same ip and port. " + newGroupNodes);
                entry.setValue(new ArrayList());
                continue;
            }
            if (newGroupNodes.size() == 2 && ((ArcusReplNodeAddress)newGroupNodes.get((int)0)).master && ((ArcusReplNodeAddress)newGroupNodes.get((int)1)).master) {
                arcusLogger.error("Invalid group " + (String)entry.getKey() + " : " + "Two master nodes exist. " + newGroupNodes);
                entry.setValue(new ArrayList());
                continue;
            }
            if (((ArcusReplNodeAddress)newGroupNodes.get((int)0)).master) continue;
            arcusLogger.info("Invalid group " + (String)entry.getKey() + " : " + "Master does not exist. " + newGroupNodes);
            entry.setValue(new ArrayList());
        }
        return newAllGroups;
    }

    public boolean isMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.master = master;
    }
}

