/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.spy.memcached.ArcusClient;
import net.spy.memcached.CachedData;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.internal.BasicThreadFactory;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.StoreType;
import net.spy.memcached.transcoders.Transcoder;

class BulkService
extends SpyObject {
    private static int DEFAULT_LOOP_LIMIT;
    private final ExecutorService executor;
    private final long singleOpTimeout;

    BulkService(int loopLimit, int threadCount, long singleOpTimeout) {
        this.executor = new ThreadPoolExecutor(threadCount, threadCount, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new BasicThreadFactory("bulk-service", true), new ThreadPoolExecutor.AbortPolicy());
        DEFAULT_LOOP_LIMIT = loopLimit;
        this.singleOpTimeout = singleOpTimeout;
    }

    <T> Future<Map<String, CollectionOperationStatus>> setBulk(List<String> keys, int exp, T value, Transcoder<T> transcoder, ArcusClient[] client) {
        assert (!this.executor.isShutdown()) : "Pool has already shut down.";
        BulkSetWorker<T> w = new BulkSetWorker<T>(keys, exp, value, transcoder, this.singleOpTimeout, client);
        Task<Map<String, CollectionOperationStatus>> task = new Task<Map<String, CollectionOperationStatus>>(w);
        this.executor.submit(task);
        return task;
    }

    <T> Future<Map<String, CollectionOperationStatus>> setBulk(Map<String, T> o, int exp, Transcoder<T> transcoder, ArcusClient[] client) {
        assert (!this.executor.isShutdown()) : "Pool has already shut down.";
        BulkSetWorker<T> w = new BulkSetWorker<T>(o, exp, transcoder, this.singleOpTimeout, client);
        Task<Map<String, CollectionOperationStatus>> task = new Task<Map<String, CollectionOperationStatus>>(w);
        this.executor.submit(task);
        return task;
    }

    <T> Future<Map<String, CollectionOperationStatus>> deleteBulk(List<String> keys, ArcusClient[] client) {
        assert (!this.executor.isShutdown()) : "Pool has already shut down.";
        BulkDeleteWorker w = new BulkDeleteWorker(keys, this.singleOpTimeout, client);
        Task<Map<String, CollectionOperationStatus>> task = new Task<Map<String, CollectionOperationStatus>>(w);
        this.executor.submit(task);
        return task;
    }

    void shutdown() {
        try {
            this.executor.shutdown();
        }
        catch (Exception e) {
            this.getLogger().warn((Object)"exception while shutting down bulk set service.", e);
        }
    }

    private static class BulkDeleteWorker<T>
    extends BulkWorker<Map<String, CollectionOperationStatus>> {
        private final List<String> keys;

        public BulkDeleteWorker(List<String> keys, long timeout, ArcusClient[] clientList) {
            super(keys, timeout, clientList);
            this.keys = keys;
            this.errorList = new HashMap();
        }

        @Override
        public Future<Boolean> processItem(int index) {
            return this.clientList[index % this.clientList.length].delete(this.keys.get(index));
        }

        @Override
        public void awaitProcessResult(int index) {
            try {
                boolean success = (Boolean)((Future)this.future.get(index)).get(this.operationTimeout, TimeUnit.MILLISECONDS);
                if (!success) {
                    ((Map)this.errorList).put(this.keys.get(index), new CollectionOperationStatus(false, String.valueOf(success), CollectionResponse.NOT_FOUND));
                }
            }
            catch (Exception e) {
                ((Future)this.future.get(index)).cancel(true);
                ((Map)this.errorList).put(this.keys.get(index), new CollectionOperationStatus(false, e.getMessage(), CollectionResponse.EXCEPTION));
            }
        }
    }

    private static class BulkSetWorker<T>
    extends BulkWorker<Map<String, CollectionOperationStatus>> {
        private final List<String> keys;
        private final int exp;
        private final int cntCos;
        private List<CachedData> cos;

        public BulkSetWorker(List<String> keys, int exp, T value, Transcoder<T> transcoder, long timeout, ArcusClient[] clientList) {
            super(keys, timeout, clientList);
            this.keys = keys;
            this.exp = exp;
            this.cos = new ArrayList<CachedData>();
            this.cos.add(transcoder.encode(value));
            this.cntCos = 1;
            this.errorList = new HashMap();
        }

        public BulkSetWorker(Map<String, T> o, int exp, Transcoder<T> transcoder, long timeout, ArcusClient[] clientList) {
            super(o.keySet(), timeout, clientList);
            this.keys = new ArrayList<String>(o.keySet());
            this.exp = exp;
            this.cos = new ArrayList<CachedData>();
            for (String key : this.keys) {
                this.cos.add(transcoder.encode(o.get(key)));
            }
            this.cntCos = this.cos.size();
            this.errorList = new HashMap();
        }

        @Override
        public Future<Boolean> processItem(int index) {
            return this.clientList[index % this.clientList.length].asyncStore(StoreType.set, this.keys.get(index), this.exp, this.cntCos > 1 ? this.cos.get(index) : this.cos.get(0));
        }

        @Override
        public void awaitProcessResult(int index) {
            try {
                boolean success = (Boolean)((Future)this.future.get(index)).get(this.operationTimeout, TimeUnit.MILLISECONDS);
                if (!success) {
                    ((Map)this.errorList).put(this.keys.get(index), new CollectionOperationStatus(false, String.valueOf(success), CollectionResponse.END));
                }
            }
            catch (Exception e) {
                ((Future)this.future.get(index)).cancel(true);
                ((Map)this.errorList).put(this.keys.get(index), new CollectionOperationStatus(false, e.getMessage(), CollectionResponse.EXCEPTION));
            }
        }
    }

    private static abstract class BulkWorker<T>
    extends SpyObject
    implements Callable<T> {
        protected final ArcusClient[] clientList;
        protected final ArrayList<Future<Boolean>> future;
        protected final long operationTimeout;
        protected final AtomicBoolean isRunnable = new AtomicBoolean(true);
        protected T errorList = null;
        protected final int keyCount;

        public BulkWorker(Collection keys, long timeout, ArcusClient[] clientList) {
            this.future = new ArrayList(keys.size());
            this.operationTimeout = timeout;
            this.clientList = clientList;
            this.keyCount = keys.size();
        }

        public boolean cancel() {
            if (!this.isRunnable()) {
                return false;
            }
            this.isRunnable.set(false);
            boolean ret = true;
            for (Future<Boolean> f : this.future) {
                if (f == null || f.isCancelled() || f.isDone()) continue;
                ret &= f.cancel(true);
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().debug("Cancel the future. " + f);
            }
            return ret;
        }

        protected boolean isRunnable() {
            return this.isRunnable.get() && !Thread.currentThread().isInterrupted();
        }

        protected abstract Future<Boolean> processItem(int var1);

        protected abstract void awaitProcessResult(int var1);

        @Override
        public T call() throws Exception {
            int numActiveOperations = 0;
            int posResponseReceived = 0;
            for (int pos = 0; this.isRunnable() && pos < this.keyCount; ++pos) {
                try {
                    if (this.isRunnable()) {
                        this.future.add(pos, this.processItem(pos));
                    }
                }
                catch (IllegalStateException e) {
                    if (Thread.currentThread().isInterrupted()) break;
                    throw e;
                }
                if (++numActiveOperations < DEFAULT_LOOP_LIMIT) continue;
                this.awaitProcessResult(posResponseReceived);
                ++posResponseReceived;
                --numActiveOperations;
            }
            while (numActiveOperations > 0) {
                this.awaitProcessResult(posResponseReceived);
                ++posResponseReceived;
                --numActiveOperations;
            }
            return this.errorList;
        }
    }

    private static class Task<T>
    extends FutureTask<T> {
        private final BulkWorker<T> worker;

        public Task(Callable<T> callable) {
            super(callable);
            this.worker = (BulkWorker)callable;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.worker.cancel() && super.cancel(mayInterruptIfRunning);
        }
    }
}

