/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.List;
import net.spy.memcached.compat.SpyObject;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class CacheMonitor
extends SpyObject
implements Watcher,
AsyncCallback.ChildrenCallback {
    private final ZooKeeper zk;
    private final String cacheListZPath;
    private final String serviceCode;
    private volatile boolean dead;
    private final CacheMonitorListener listener;

    public CacheMonitor(ZooKeeper zk, String cacheListZPath, String serviceCode, CacheMonitorListener listener) {
        this.zk = zk;
        this.cacheListZPath = cacheListZPath;
        this.serviceCode = serviceCode;
        this.listener = listener;
        this.getLogger().info("Initializing the CacheMonitor.");
        this.asyncGetCacheList();
    }

    public void process(WatchedEvent event) {
        if (event.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
            this.asyncGetCacheList();
        }
    }

    public void processResult(int rc, String path, Object ctx, List<String> children) {
        switch (KeeperException.Code.get((int)rc)) {
            case OK: {
                this.listener.commandCacheListChange(children);
                return;
            }
            case NONODE: {
                this.getLogger().fatal("Cannot find your service code. Please contact Arcus support to solve this problem. " + this.getInfo());
                return;
            }
            case SESSIONEXPIRED: {
                this.getLogger().warn("Session expired. Trying to reconnect to the Arcus admin. " + this.getInfo());
                this.shutdown();
                return;
            }
            case NOAUTH: {
                this.getLogger().fatal("Authorization failed " + this.getInfo());
                this.shutdown();
                return;
            }
            case CONNECTIONLOSS: {
                this.getLogger().warn("Connection lost. Trying to reconnect to the Arcus admin." + this.getInfo());
                this.asyncGetCacheList();
                return;
            }
        }
        this.getLogger().warn("Ignoring an unexpected event from the Arcus admin. code=" + KeeperException.Code.get((int)rc) + ", " + this.getInfo());
        this.asyncGetCacheList();
    }

    void asyncGetCacheList() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Set a new watch on " + this.cacheListZPath + this.serviceCode);
        }
        this.zk.getChildren(this.cacheListZPath + this.serviceCode, (Watcher)this, (AsyncCallback.ChildrenCallback)this, null);
    }

    public void shutdown() {
        if (!this.dead) {
            this.getLogger().info("Shutting down the CacheMonitor. " + this.getInfo());
            this.dead = true;
            this.listener.closing();
        }
    }

    public boolean isDead() {
        return this.dead;
    }

    private String getInfo() {
        String zkSessionId = null;
        if (this.zk != null) {
            zkSessionId = "0x" + Long.toHexString(this.zk.getSessionId());
        }
        return "[serviceCode=" + this.serviceCode + ", adminSessionId=" + zkSessionId + "]";
    }

    public static interface CacheMonitorListener {
        public void commandCacheListChange(List<String> var1);

        public List<String> getPrevCacheList();

        public void closing();
    }
}

