/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.ReadPriority;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.transcoders.Transcoder;

public interface ConnectionFactory {
    public MemcachedConnection createConnection(String var1, List<InetSocketAddress> var2) throws IOException;

    public MemcachedNode createMemcachedNode(String var1, SocketAddress var2, SocketChannel var3, int var4);

    public BlockingQueue<Operation> createOperationQueue();

    public BlockingQueue<Operation> createReadOperationQueue();

    public BlockingQueue<Operation> createWriteOperationQueue();

    public long getOpQueueMaxBlockTime();

    public NodeLocator createLocator(List<MemcachedNode> var1);

    public OperationFactory getOperationFactory();

    public long getOperationTimeout();

    public boolean isDaemon();

    public boolean useNagleAlgorithm();

    public Collection<ConnectionObserver> getInitialObservers();

    public FailureMode getFailureMode();

    public Transcoder<Object> getDefaultTranscoder();

    public Transcoder<Object> getDefaultCollectionTranscoder();

    public boolean shouldOptimize();

    public int getReadBufSize();

    public HashAlgorithm getHashAlg();

    public long getMaxReconnectDelay();

    public AuthDescriptor getAuthDescriptor();

    public int getTimeoutExceptionThreshold();

    public int getTimeoutRatioThreshold();

    public int getMaxFrontCacheElements();

    public int getFrontCacheExpireTime();

    public String getFrontCacheName();

    public boolean getFrontCacheCopyOnRead();

    public boolean getFrontCacheCopyOnWrite();

    public int getDefaultMaxSMGetKeyChunkSize();

    public byte getDelimiter();

    public ReadPriority getReadPriority();

    public Map<APIType, ReadPriority> getAPIReadPriority();
}

