/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedNodeROImpl;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.util.DefaultKetamaNodeLocatorConfiguration;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;

public final class KetamaNodeLocator
extends SpyObject
implements NodeLocator {
    private final TreeMap<Long, MemcachedNode> ketamaNodes;
    private final Collection<MemcachedNode> allNodes;
    private final HashAlgorithm hashAlg;
    private final KetamaNodeLocatorConfiguration config;

    public KetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg) {
        this(nodes, alg, new DefaultKetamaNodeLocatorConfiguration());
    }

    public KetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg, KetamaNodeLocatorConfiguration conf) {
        this.allNodes = nodes;
        this.hashAlg = alg;
        this.ketamaNodes = new TreeMap();
        this.config = conf;
        int numReps = this.config.getNodeRepetitions();
        if (alg == HashAlgorithm.KETAMA_HASH) {
            for (MemcachedNode node : nodes) {
                for (int i = 0; i < numReps / 4; ++i) {
                    byte[] digest = HashAlgorithm.computeMd5(this.config.getKeyForNode(node, i));
                    for (int h = 0; h < 4; ++h) {
                        Long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
                        this.ketamaNodes.put(k, node);
                    }
                }
            }
        } else {
            for (MemcachedNode node : nodes) {
                for (int i = 0; i < numReps; ++i) {
                    this.ketamaNodes.put(this.hashAlg.hash(this.config.getKeyForNode(node, i)), node);
                }
            }
        }
        assert (this.ketamaNodes.size() == numReps * nodes.size());
    }

    private KetamaNodeLocator(TreeMap<Long, MemcachedNode> smn, Collection<MemcachedNode> an, HashAlgorithm alg, KetamaNodeLocatorConfiguration conf) {
        this.ketamaNodes = smn;
        this.allNodes = an;
        this.hashAlg = alg;
        this.config = conf;
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return this.allNodes;
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        MemcachedNode rv = this.getNodeForKey(this.hashAlg.hash(k));
        assert (rv != null) : "Found no node for key " + k;
        return rv;
    }

    long getMaxKey() {
        return this.ketamaNodes.lastKey();
    }

    MemcachedNode getNodeForKey(long hash) {
        if (!this.ketamaNodes.containsKey(hash)) {
            Long nodeHash = this.ketamaNodes.ceilingKey(hash);
            hash = nodeHash == null ? this.ketamaNodes.firstKey().longValue() : nodeHash.longValue();
        }
        MemcachedNode rv = this.ketamaNodes.get(hash);
        return rv;
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return new KetamaIterator(k, this.allNodes.size());
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        TreeMap<Long, MemcachedNode> smn = new TreeMap<Long, MemcachedNode>((SortedMap<Long, MemcachedNode>)this.ketamaNodes);
        ArrayList<MemcachedNode> an = new ArrayList<MemcachedNode>(this.allNodes.size());
        for (Map.Entry<Long, MemcachedNode> me : smn.entrySet()) {
            me.setValue(new MemcachedNodeROImpl(me.getValue()));
        }
        for (MemcachedNode n : this.allNodes) {
            an.add(new MemcachedNodeROImpl(n));
        }
        return new KetamaNodeLocator(smn, an, this.hashAlg, this.config);
    }

    @Override
    public void update(Collection<MemcachedNode> toAttach, Collection<MemcachedNode> toDelete) {
        throw new UnsupportedOperationException("update not supported");
    }

    public SortedMap<Long, MemcachedNode> getKetamaNodes() {
        return Collections.unmodifiableSortedMap(this.ketamaNodes);
    }

    class KetamaIterator
    implements Iterator<MemcachedNode> {
        private final String key;
        private long hashVal;
        private int remainingTries;
        private int numTries = 0;

        public KetamaIterator(String k, int t) {
            this.hashVal = KetamaNodeLocator.this.hashAlg.hash(k);
            this.remainingTries = t;
            this.key = k;
        }

        private void nextHash() {
            long tmpKey = KetamaNodeLocator.this.hashAlg.hash(this.numTries++ + this.key);
            this.hashVal += (long)((int)(tmpKey ^ tmpKey >>> 32));
            this.hashVal &= 0xFFFFFFFFL;
            --this.remainingTries;
        }

        @Override
        public boolean hasNext() {
            return this.remainingTries > 0;
        }

        @Override
        public MemcachedNode next() {
            try {
                MemcachedNode memcachedNode = KetamaNodeLocator.this.getNodeForKey(this.hashVal);
                return memcachedNode;
            }
            finally {
                this.nextHash();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }
    }
}

