/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import net.spy.memcached.ArcusReplNodeAddress;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.ReplicaPick;
import net.spy.memcached.compat.SpyObject;

public abstract class MemcachedReplicaGroup
extends SpyObject {
    protected final String group;
    protected MemcachedNode masterNode;
    protected MemcachedNode slaveNode;
    private boolean prevMasterPick;

    protected MemcachedReplicaGroup(String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException("Memcached in Replica Group must have group name");
        }
        this.group = groupName;
    }

    public String toString() {
        return "[" + this.masterNode + ", " + this.slaveNode + "]";
    }

    public boolean isEmptyGroup() {
        return this.masterNode == null && this.slaveNode == null;
    }

    public abstract boolean setMemcachedNode(MemcachedNode var1);

    public abstract boolean deleteMemcachedNode(MemcachedNode var1);

    public String getGroupName() {
        return this.group;
    }

    public MemcachedNode getMasterNode() {
        return this.masterNode;
    }

    public MemcachedNode getSlaveNode() {
        return this.slaveNode;
    }

    public MemcachedNode getNodeForReplicaPick(ReplicaPick priority) {
        MemcachedNode node = null;
        switch (priority) {
            case MASTER: {
                node = this.masterNode;
                break;
            }
            case SLAVE: {
                if (this.slaveNode != null && this.slaveNode.isActive()) {
                    node = this.slaveNode;
                    break;
                }
                node = this.masterNode;
                break;
            }
            case RR: {
                node = this.prevMasterPick && this.slaveNode != null && this.slaveNode.isActive() ? this.slaveNode : this.masterNode;
                this.prevMasterPick = !this.prevMasterPick;
                break;
            }
        }
        return node;
    }

    public abstract boolean changeRole();

    public static String getGroupNameForNode(MemcachedNode node) {
        return ((ArcusReplNodeAddress)node.getSocketAddress()).getGroupName();
    }
}

