/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import net.spy.memcached.ArcusReplNodeAddress;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedReplicaGroup;

public class MemcachedReplicaGroupImpl
extends MemcachedReplicaGroup {
    public MemcachedReplicaGroupImpl(MemcachedNode node) {
        super(MemcachedReplicaGroupImpl.getGroupNameForNode(node));
        if (node == null) {
            throw new IllegalArgumentException("Memcached Node must not be null");
        }
        this.setMemcachedNode(node);
    }

    @Override
    public boolean setMemcachedNode(MemcachedNode node) {
        if (node == null) {
            return false;
        }
        if (this.group.equals(MemcachedReplicaGroupImpl.getGroupNameForNode(node))) {
            if (((ArcusReplNodeAddress)node.getSocketAddress()).isMaster()) {
                this.masterNode = node;
            } else {
                this.slaveNode = node;
            }
            node.setReplicaGroup(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteMemcachedNode(MemcachedNode node) {
        if (node == null) {
            return false;
        }
        if (this.group.equals(MemcachedReplicaGroupImpl.getGroupNameForNode(node))) {
            if (((ArcusReplNodeAddress)node.getSocketAddress()).isMaster()) {
                this.masterNode = null;
            } else {
                this.slaveNode = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean changeRole() {
        MemcachedNode tmpNode = this.masterNode;
        this.masterNode = this.slaveNode;
        if (this.masterNode != null) {
            ((ArcusReplNodeAddress)this.masterNode.getSocketAddress()).setMaster(true);
        }
        this.slaveNode = tmpNode;
        if (this.slaveNode != null) {
            ((ArcusReplNodeAddress)this.slaveNode.getSocketAddress()).setMaster(false);
        }
        return true;
    }
}

