/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartitionedMap<K, V>
extends AbstractList<Map<K, V>> {
    private final List<Map<K, V>> mapList;

    public PartitionedMap(Map<K, V> map, int size) {
        int expectSize = (map.size() + size - 1) / size;
        int splitBy = size;
        int parsedSize = 0;
        int mapSize = map.size();
        int counter = 0;
        int listIndex = 0;
        this.mapList = new ArrayList<Map<K, V>>(expectSize);
        for (int i = 0; i < expectSize; ++i) {
            this.mapList.add(new HashMap());
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.mapList.get(listIndex).put(entry.getKey(), entry.getValue());
            if (++parsedSize != splitBy && ++counter != mapSize) continue;
            parsedSize = 0;
            ++listIndex;
        }
    }

    @Override
    public Map<K, V> get(int index) {
        int listSize = this.size();
        if (listSize < 0) {
            throw new IllegalArgumentException("negative size: " + listSize);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index " + index + " must not be negative");
        }
        if (index >= listSize) {
            throw new IndexOutOfBoundsException("index " + index + " must be less than size " + listSize);
        }
        return this.mapList.get(index);
    }

    @Override
    public int size() {
        return this.mapList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mapList.isEmpty();
    }
}

