/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionType;
import net.spy.memcached.compat.SpyObject;

public class Attributes
extends SpyObject {
    public static final Integer DEFAULT_FLAGS = 0;
    public static final Integer DEFAULT_EXPIRETIME = 0;
    protected Integer flags;
    protected Integer expireTime;
    protected CollectionType type;
    private String str;

    public Attributes() {
    }

    public Attributes(Integer expireTime) {
        this.expireTime = expireTime;
    }

    protected String stringify() {
        StringBuilder b = new StringBuilder();
        if (this.flags != null) {
            b.append(" flags=").append(this.flags);
        }
        if (this.expireTime != null) {
            b.append(" expiretime=").append(this.expireTime);
        }
        if (this.type != null) {
            b.append(" type=").append(this.type.getStringValue());
        }
        this.str = b.length() < 1 ? "" : b.substring(1);
        return this.str;
    }

    public String toString() {
        return this.str == null ? this.stringify() : this.str;
    }

    public int getLength() {
        return this.str == null ? this.stringify().length() : this.str.length();
    }

    public void setAttribute(String attribute) {
        block8: {
            String[] splited = attribute.split("=");
            assert (splited.length == 2) : "An attribute should be given in \"name=value\" format.";
            String name = splited[0];
            String value = splited[1];
            try {
                if ("flags".equals(name)) {
                    this.flags = Integer.parseInt(value);
                } else if ("expiretime".equals(name)) {
                    this.expireTime = Integer.parseInt(value);
                } else if ("type".equals(name)) {
                    this.type = CollectionType.find(value);
                }
            }
            catch (Exception e) {
                this.getLogger().info(e, e);
                if ($assertionsDisabled) break block8;
                throw new AssertionError((Object)"Unexpected value.");
            }
        }
    }

    public void setExpireTime(Integer expireTime) {
        this.expireTime = expireTime;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public Integer getExpireTime() {
        return this.expireTime;
    }

    public CollectionType getType() {
        return this.type;
    }
}

