/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionGet;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.collection.ElementMultiFlagsFilter;
import net.spy.memcached.util.BTreeUtil;

public class BTreeGet
extends CollectionGet {
    private static final String command = "bop get";
    protected int offset = -1;
    protected int count = -1;
    protected ElementFlagFilter elementFlagFilter;
    private int headerParseStep = 1;
    private boolean elementFlagExists = false;

    public BTreeGet(long bkey, boolean delete) {
        this.headerCount = 2;
        this.range = String.valueOf(bkey);
        this.delete = delete;
    }

    public BTreeGet(long bkey, boolean delete, boolean dropIfEmpty, ElementFlagFilter elementFlagFilter) {
        this(bkey, delete);
        this.dropIfEmpty = dropIfEmpty;
        this.elementFlagFilter = elementFlagFilter;
    }

    public BTreeGet(long from, long to, int offset, int count, boolean delete) {
        this.headerCount = 2;
        this.range = String.valueOf(from) + ".." + String.valueOf(to);
        this.offset = offset;
        this.count = count;
        this.delete = delete;
    }

    public BTreeGet(long from, long to, int offset, int count, boolean delete, boolean dropIfEmpty, ElementFlagFilter elementFlagFilter) {
        this(from, to, offset, count, delete);
        this.dropIfEmpty = dropIfEmpty;
        this.elementFlagFilter = elementFlagFilter;
    }

    public BTreeGet(byte[] from, byte[] to, int offset, int count, boolean delete, boolean dropIfEmpty, ElementFlagFilter elementFlagFilter) {
        this.headerCount = 2;
        this.range = BTreeUtil.toHex(from) + ".." + BTreeUtil.toHex(to);
        this.offset = offset;
        this.count = count;
        this.delete = delete;
        this.dropIfEmpty = dropIfEmpty;
        this.elementFlagFilter = elementFlagFilter;
    }

    public BTreeGet(long bkey, boolean delete, boolean dropIfEmpty, ElementMultiFlagsFilter elementMultiFlagsFilter) {
        this(bkey, delete);
        this.dropIfEmpty = dropIfEmpty;
        this.elementFlagFilter = elementMultiFlagsFilter;
    }

    public BTreeGet(long from, long to, int offset, int count, boolean delete, boolean dropIfEmpty, ElementMultiFlagsFilter elementMultiFlagsFilter) {
        this(from, to, offset, count, delete);
        this.dropIfEmpty = dropIfEmpty;
        this.elementFlagFilter = elementMultiFlagsFilter;
    }

    public ElementFlagFilter getElementFlagFilter() {
        return this.elementFlagFilter;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.range);
        if (this.elementFlagFilter != null) {
            b.append(" ").append(this.elementFlagFilter.toString());
        }
        if (this.offset > 0) {
            b.append(" ").append(this.offset);
        }
        if (this.count > 0) {
            b.append(" ").append(this.count);
        }
        if (this.delete && this.dropIfEmpty) {
            b.append(" drop");
        }
        if (this.delete && !this.dropIfEmpty) {
            b.append(" delete");
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }

    public void resetHeaderCount(int count) {
        this.headerCount = count;
    }

    @Override
    public boolean eachRecordParseCompleted() {
        if (this.elementFlagExists) {
            return this.headerParseStep == 1;
        }
        return true;
    }

    @Override
    public byte[] getAddtionalArgs() {
        return null;
    }

    @Override
    public boolean headerReady(int spaceCount) {
        return spaceCount == 2 || spaceCount == 3;
    }

    @Override
    public void decodeItemHeader(String itemHeader) {
        String[] splited = itemHeader.split(" ");
        if (this.headerParseStep == 1) {
            this.subkey = splited[0].startsWith("0x") ? splited[0].substring(2) : splited[0];
            if (splited[1].startsWith("0x")) {
                this.elementFlagExists = true;
                this.elementFlag = BTreeUtil.hexStringToByteArrays(splited[1].substring(2));
                this.headerParseStep = 2;
            } else {
                this.dataLength = Integer.parseInt(splited[1]);
            }
        } else {
            this.headerParseStep = 1;
            this.dataLength = Integer.parseInt(splited[1]);
        }
    }
}

