/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.BKeyObject;
import net.spy.memcached.collection.BTreeOrder;
import net.spy.memcached.collection.CollectionGet;
import net.spy.memcached.util.BTreeUtil;

public class BTreeGetByPosition
extends CollectionGet {
    public static final int HEADER_EFLAG_POSITION = 1;
    private static final String command = "bop gbp";
    private final BTreeOrder order;
    private final String range;
    private final int posFrom;
    private final int posTo;
    private BKeyObject bkey;
    private byte[] eflag;
    private int bytes;
    private static final int BKEY = 0;
    private static final int EFLAG_OR_BYTES = 1;
    private static final int BYTES = 2;

    public BTreeGetByPosition(BTreeOrder order, int pos) {
        this.headerCount = 2;
        this.order = order;
        this.range = String.valueOf(pos);
        this.posFrom = pos;
        this.posTo = pos;
    }

    public BTreeGetByPosition(BTreeOrder order, int posFrom, int posTo) {
        this.headerCount = 2;
        this.order = order;
        this.range = String.valueOf(posFrom) + ".." + String.valueOf(posTo);
        this.posFrom = posFrom;
        this.posTo = posTo;
    }

    public BTreeOrder getOrder() {
        return this.order;
    }

    public String getRange() {
        return this.range;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.order.getAscii());
        b.append(" ");
        b.append(this.range);
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }

    @Override
    public boolean headerReady(int spaceCount) {
        return spaceCount == 2;
    }

    @Override
    public byte[] getAddtionalArgs() {
        return null;
    }

    @Override
    public void decodeItemHeader(String itemHeader) {
        String[] splited = itemHeader.split(" ");
        boolean hasEFlag = false;
        this.bkey = splited[0].startsWith("0x") ? new BKeyObject(splited[0].substring(2)) : new BKeyObject(Long.parseLong(splited[0]));
        if (splited[1].startsWith("0x")) {
            hasEFlag = true;
            this.eflag = BTreeUtil.hexStringToByteArrays(splited[1].substring(2));
        } else {
            this.bytes = Integer.parseInt(splited[1]);
        }
        if (hasEFlag) {
            this.bytes = Integer.parseInt(splited[2]);
        }
        this.dataLength = this.bytes;
    }

    public BKeyObject getBkey() {
        return this.bkey;
    }

    public byte[] getEflag() {
        return this.eflag;
    }

    public int getBytes() {
        return this.bytes;
    }

    public int getPosFrom() {
        return this.posFrom;
    }

    public int getPosTo() {
        return this.posTo;
    }

    public boolean isReversed() {
        return this.posFrom > this.posTo;
    }
}

