/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.BKeyObject;
import net.spy.memcached.collection.BTreeInsert;
import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.RequestMode;
import net.spy.memcached.util.BTreeUtil;

public class BTreeInsertAndGet<T>
extends BTreeInsert<T> {
    public static final int HEADER_EFLAG_POSITION = 1;
    private Command cmd;
    private BKeyObject bkeyObject;
    private int bytes;
    private static final int BKEY = 0;
    private static final int EFLAG_OR_BYTES = 1;
    private static final int BYTES = 2;

    public BTreeInsertAndGet(Command cmd, long bkey, byte[] eFlag, T value, CollectionAttributes attributesForCreate) {
        super(value, eFlag, attributesForCreate != null, RequestMode.GET_TRIM, attributesForCreate);
        this.cmd = cmd;
        this.bkeyObject = new BKeyObject(bkey);
    }

    public BTreeInsertAndGet(Command cmd, byte[] bkey, byte[] eFlag, T value, CollectionAttributes attributesForCreate) {
        super(value, eFlag, attributesForCreate != null, RequestMode.GET_TRIM, attributesForCreate);
        this.cmd = cmd;
        this.bkeyObject = new BKeyObject(bkey);
    }

    public BKeyObject getBkeyObject() {
        return this.bkeyObject;
    }

    public boolean headerReady(int spaceCount) {
        return spaceCount == 2;
    }

    public void decodeItemHeader(String itemHeader) {
        String[] splited = itemHeader.split(" ");
        boolean hasEFlag = false;
        this.bkeyObject = splited[0].startsWith("0x") ? new BKeyObject(splited[0].substring(2)) : new BKeyObject(Long.parseLong(splited[0]));
        if (splited[1].startsWith("0x")) {
            hasEFlag = true;
            this.elementFlag = BTreeUtil.hexStringToByteArrays(splited[1].substring(2));
        } else {
            this.bytes = Integer.parseInt(splited[1]);
        }
        if (hasEFlag) {
            this.bytes = Integer.parseInt(splited[2]);
        }
    }

    public int getBytes() {
        return this.bytes;
    }

    public Command getCmd() {
        return this.cmd;
    }

    @Override
    public String getCommand() {
        return this.cmd.getCommand();
    }

    public static enum Command {
        INSERT("bop insert"),
        UPSERT("bop upsert");

        private final String command;

        private Command(String command) {
            this.command = command;
        }

        public String getCommand() {
            return this.command;
        }
    }
}

