/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionMutate;
import net.spy.memcached.ops.Mutator;
import net.spy.memcached.util.BTreeUtil;

public class BTreeMutate
extends CollectionMutate {
    private final String command;
    protected final Mutator m;
    protected final int by;
    protected long initial = -1L;
    protected byte[] elementFlag;

    public BTreeMutate(Mutator m, int by) {
        if (by <= 0) {
            throw new IllegalArgumentException("by must be positive value.");
        }
        this.command = Mutator.incr == m ? "bop incr" : "bop decr";
        this.m = m;
        this.by = by;
    }

    public BTreeMutate(Mutator m, int by, long initial, byte[] eFlag) {
        if (by <= 0) {
            throw new IllegalArgumentException("by must be positive value.");
        }
        if (initial < 0L) {
            throw new IllegalArgumentException("initial must be 0 or positive value.");
        }
        if (eFlag != null && (eFlag.length < 1 || eFlag.length > 31)) {
            throw new IllegalArgumentException("length of eFlag must be between 1 and 31.");
        }
        this.command = Mutator.incr == m ? "bop incr" : "bop decr";
        this.m = m;
        this.by = by;
        this.initial = initial;
        this.elementFlag = eFlag;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.by);
        if (this.initial >= 0L) {
            b.append(" ").append(this.initial);
        }
        if (this.elementFlag != null) {
            b.append(" ").append(this.getElementFlagByHex());
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public Mutator getMutator() {
        return this.m;
    }

    public String getElementFlagByHex() {
        return BTreeUtil.toHex(this.elementFlag);
    }
}

