/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.util.List;
import java.util.Map;
import net.spy.memcached.collection.BTreeSMGet;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.collection.SMGetMode;
import net.spy.memcached.util.BTreeUtil;

public class BTreeSMGetWithLongTypeBkey<T>
implements BTreeSMGet<T> {
    private static final String command = "bop smget";
    protected String str;
    protected List<String> keyList;
    private String keySeparator;
    private String spaceSeparatedKeys;
    protected int lenKeys;
    protected String range;
    protected int count;
    protected SMGetMode smgetMode;
    protected boolean unique;
    protected Map<Integer, T> map;
    protected boolean reverse;
    private String key;
    private int flag;
    private long subkey;
    private int dataLength;
    private byte[] eflag = null;
    private ElementFlagFilter eFlagFilter;

    public BTreeSMGetWithLongTypeBkey(List<String> keyList, long from, long to, ElementFlagFilter eFlagFilter, int count, SMGetMode smgetMode) {
        this.keyList = keyList;
        this.range = String.valueOf(from) + (to > -1L ? ".." + String.valueOf(to) : "");
        this.eFlagFilter = eFlagFilter;
        this.count = count;
        this.smgetMode = smgetMode;
        this.reverse = from > to;
    }

    @Override
    public void setKeySeparator(String keySeparator) {
        this.keySeparator = keySeparator;
    }

    @Override
    public String getSpaceSeparatedKeys() {
        if (this.spaceSeparatedKeys != null) {
            return this.spaceSeparatedKeys;
        }
        StringBuilder sb = new StringBuilder();
        int numkeys = this.keyList.size();
        for (int i = 0; i < numkeys; ++i) {
            sb.append(this.keyList.get(i));
            if (i + 1 >= numkeys) continue;
            sb.append(this.keySeparator);
        }
        this.spaceSeparatedKeys = sb.toString();
        return this.spaceSeparatedKeys;
    }

    @Override
    public String getRepresentKey() {
        if (this.keyList == null || this.keyList.isEmpty()) {
            throw new IllegalStateException("Key list is empty.");
        }
        return this.keyList.get(0);
    }

    @Override
    public List<String> getKeyList() {
        return this.keyList;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.getSpaceSeparatedKeys().length());
        b.append(" ").append(this.keyList.size());
        b.append(" ").append(this.range);
        if (this.eFlagFilter != null) {
            b.append(" ").append(this.eFlagFilter.toString());
        }
        b.append(" ").append(this.count);
        b.append(" ").append(this.smgetMode.getMode());
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }

    @Override
    public boolean headerReady(int spaceCount) {
        return 4 == spaceCount;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getFlag() {
        return this.flag;
    }

    @Override
    public Long getSubkey() {
        return this.subkey;
    }

    @Override
    public int getDataLength() {
        return this.dataLength;
    }

    @Override
    public boolean isReverse() {
        return this.reverse;
    }

    @Override
    public boolean hasEflag() {
        return this.eflag != null;
    }

    @Override
    public void decodeItemHeader(String itemHeader) {
        String[] splited = itemHeader.split(" ");
        this.key = splited[0];
        this.flag = Integer.parseInt(splited[1]);
        this.subkey = Long.parseLong(splited[2]);
        if (splited[3].startsWith("0x")) {
            this.eflag = BTreeUtil.hexStringToByteArrays(splited[3].substring(2));
            this.dataLength = Integer.parseInt(splited[4]);
        } else {
            this.eflag = null;
            this.dataLength = Integer.parseInt(splited[3]);
        }
    }
}

