/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.Attributes;
import net.spy.memcached.collection.CollectionOverflowAction;
import net.spy.memcached.collection.CollectionType;
import net.spy.memcached.util.BTreeUtil;

public class CollectionAttributes
extends Attributes {
    public static final Long DEFAULT_MAXCOUNT = 4000L;
    public static final CollectionOverflowAction DEFAULT_OVERFLOWACTION = CollectionOverflowAction.tail_trim;
    private Long count;
    private Long maxCount;
    private CollectionOverflowAction overflowAction;
    private Boolean readable;
    private Long maxBkeyRange = null;
    private byte[] maxBkeyRangeByBytes = null;
    private Long minBkey = null;
    private byte[] minBkeyByBytes = null;
    private Long maxBkey = null;
    private byte[] maxBkeyByBytes = null;
    private Long trimmed = null;
    private String str;

    public CollectionAttributes() {
    }

    public CollectionAttributes(Integer expireTime, Long maxCount, CollectionOverflowAction overflowAction) {
        this.expireTime = expireTime;
        this.maxCount = maxCount;
        this.overflowAction = overflowAction;
    }

    @Override
    protected String stringify() {
        StringBuilder b = new StringBuilder();
        if (this.flags != null) {
            b.append(" flags=").append(this.flags);
        }
        if (this.expireTime != null) {
            b.append(" expiretime=").append(this.expireTime);
        }
        if (this.type != null) {
            b.append(" type=").append(this.type.getStringValue());
        }
        if (this.count != null) {
            b.append(" count=").append(this.count);
        }
        if (this.maxCount != null) {
            b.append(" maxcount=").append(this.maxCount);
        }
        if (this.overflowAction != null) {
            b.append(" overflowaction=").append(String.valueOf((Object)this.overflowAction));
        }
        if (this.readable != null) {
            b.append(" readable=").append(this.readable != false ? "on" : "off");
        }
        if (this.maxBkeyRange != null || this.maxBkeyRangeByBytes != null) {
            if (this.maxBkeyRange != null) {
                b.append(" maxbkeyrange=").append(String.valueOf(this.maxBkeyRange));
            } else {
                b.append(" maxbkeyrange=").append(BTreeUtil.toHex(this.maxBkeyRangeByBytes));
            }
        }
        this.str = b.length() < 1 ? "" : b.substring(1);
        return this.str;
    }

    @Override
    public String toString() {
        return this.str == null ? this.stringify() : this.str;
    }

    @Override
    public int getLength() {
        return this.str == null ? this.stringify().length() : this.str.length();
    }

    @Override
    public void setAttribute(String attribute) {
        block32: {
            String[] splited = attribute.split("=");
            assert (splited.length == 2) : "An attribute should be given in \"name=value\" format.";
            String name = splited[0];
            String value = splited[1];
            try {
                if ("flags".equals(name)) {
                    this.flags = Integer.parseInt(value);
                } else if ("expiretime".equals(name)) {
                    this.expireTime = Integer.parseInt(value);
                } else if ("type".equals(name)) {
                    this.type = CollectionType.find(value);
                } else if ("count".equals(name)) {
                    this.count = Long.parseLong(value);
                } else if ("maxcount".equals(name)) {
                    this.maxCount = Long.parseLong(value);
                } else if ("overflowaction".equals(name)) {
                    this.overflowAction = CollectionOverflowAction.valueOf(value);
                } else if ("readable".equals(name)) {
                    this.readable = "on".equals(value);
                } else if ("maxbkeyrange".equals(name)) {
                    if (value.startsWith("0x")) {
                        this.maxBkeyRangeByBytes = BTreeUtil.hexStringToByteArrays(value.substring(2));
                    } else {
                        this.maxBkeyRange = Long.parseLong(value);
                    }
                } else if ("minbkey".equals(name)) {
                    if (!value.startsWith("-1")) {
                        if (value.startsWith("0x")) {
                            this.minBkeyByBytes = BTreeUtil.hexStringToByteArrays(value.substring(2));
                        } else {
                            this.minBkey = Long.parseLong(value);
                        }
                    }
                } else if ("maxbkey".equals(name)) {
                    if (!value.startsWith("-1")) {
                        if (value.startsWith("0x")) {
                            this.maxBkeyByBytes = BTreeUtil.hexStringToByteArrays(value.substring(2));
                        } else {
                            this.maxBkey = Long.parseLong(value);
                        }
                    }
                } else if ("trimmed".equals(name)) {
                    this.trimmed = Long.parseLong(value);
                }
            }
            catch (Exception e) {
                this.getLogger().info(e, e);
                if ($assertionsDisabled) break block32;
                throw new AssertionError((Object)"Unexpected value.");
            }
        }
    }

    public void setMaxCount(long maxCount) {
        this.str = null;
        this.maxCount = maxCount;
    }

    public void setOverflowAction(CollectionOverflowAction overflowAction) {
        this.str = null;
        this.overflowAction = overflowAction;
    }

    public void setReadable(Boolean readable) {
        this.str = null;
        this.readable = readable;
    }

    public Long getCount() {
        return this.count;
    }

    public Long getMaxCount() {
        return this.maxCount;
    }

    public CollectionOverflowAction getOverflowAction() {
        return this.overflowAction;
    }

    public Boolean getReadable() {
        return this.readable;
    }

    public Long getMaxBkeyRange() {
        return this.maxBkeyRange;
    }

    public void setMaxBkeyRange(Long maxBkeyRange) {
        this.str = null;
        this.maxBkeyRange = maxBkeyRange;
    }

    public byte[] getMaxBkeyRangeByBytes() {
        return this.maxBkeyRangeByBytes;
    }

    public void setMaxBkeyRangeByBytes(byte[] maxBkeyRangeByBytes) {
        this.maxBkeyRangeByBytes = maxBkeyRangeByBytes;
    }

    public Long getMinBkey() {
        return this.minBkey;
    }

    public void setMinBkey(Long minBkey) {
        this.minBkey = minBkey;
    }

    public byte[] getMinBkeyByBytes() {
        return this.minBkeyByBytes;
    }

    public Long getMaxBkey() {
        return this.maxBkey;
    }

    public byte[] getMaxBkeyByBytes() {
        return this.maxBkeyByBytes;
    }

    public Long getTrimmed() {
        return this.trimmed;
    }
}

