/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.nio.ByteBuffer;
import java.util.List;
import net.spy.memcached.CachedData;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.CollectionObject;
import net.spy.memcached.collection.CollectionOverflowAction;
import net.spy.memcached.collection.CollectionType;
import net.spy.memcached.transcoders.Transcoder;
import net.spy.memcached.util.BTreeUtil;

public abstract class CollectionBulkInsert<T>
extends CollectionObject {
    public static final String PIPE = "pipe";
    public static final int MAX_PIPED_ITEM_COUNT = 500;
    protected List<String> keyList;
    protected T value;
    protected CachedData cachedData;
    protected boolean createKeyIfNotExists;
    protected Transcoder<T> tc;
    protected int itemCount;
    protected CollectionAttributes attribute;
    protected int nextOpIndex = 0;

    public void setNextOpIndex(int i) {
        this.nextOpIndex = i;
    }

    public abstract ByteBuffer getAsciiCommand();

    public abstract ByteBuffer getBinaryCommand();

    public List<String> getKeyList() {
        return this.keyList;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public static class ListBulkInsert<T>
    extends CollectionBulkInsert<T> {
        private static final String COMMAND = "lop insert";
        private int index;

        public ListBulkInsert(List<String> keyList, int index, T value, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (attr != null && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.list.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.list) + ".");
            }
            this.keyList = keyList;
            this.index = index;
            this.value = value;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = keyList.size();
            this.createKeyIfNotExists = attr != null;
            this.cachedData = tc.encode(value);
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            int eachExtraSize = String.valueOf(this.index).length() + this.cachedData.getData().length + 128;
            for (String eachKey : this.keyList) {
                capacity += KeyUtil.getKeyBytes(eachKey).length;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity += eachExtraSize * this.keyList.size());
            int kSize = this.keyList.size();
            for (int i = this.nextOpIndex; i < kSize; ++i) {
                String key = (String)this.keyList.get(i);
                byte[] value = this.cachedData.getData();
                Object[] objectArray = new Object[11];
                objectArray[0] = COMMAND;
                objectArray[1] = key;
                objectArray[2] = this.index;
                objectArray[3] = value.length;
                objectArray[4] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[5] = this.createKeyIfNotExists ? Integer.valueOf(this.cachedData.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[6] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[7] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction() : "") : (objectArray[8] = "");
                objectArray[9] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[10] = i < kSize - 1 ? CollectionBulkInsert.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class SetBulkInsert<T>
    extends CollectionBulkInsert<T> {
        private static final String COMMAND = "sop insert";

        public SetBulkInsert(List<String> keyList, T value, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (attr != null && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.set.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.set) + ".");
            }
            this.keyList = keyList;
            this.value = value;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = keyList.size();
            this.createKeyIfNotExists = attr != null;
            this.cachedData = tc.encode(value);
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            int eachExtraSize = this.cachedData.getData().length + 128;
            for (String eachKey : this.keyList) {
                capacity += KeyUtil.getKeyBytes(eachKey).length;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity += eachExtraSize * this.keyList.size());
            int kSize = this.keyList.size();
            for (int i = this.nextOpIndex; i < kSize; ++i) {
                String key = (String)this.keyList.get(i);
                byte[] value = this.cachedData.getData();
                Object[] objectArray = new Object[10];
                objectArray[0] = COMMAND;
                objectArray[1] = key;
                objectArray[2] = value.length;
                objectArray[3] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[4] = this.createKeyIfNotExists ? Integer.valueOf(this.cachedData.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[5] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[6] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction() : "") : (objectArray[7] = "");
                objectArray[8] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[9] = i < kSize - 1 ? CollectionBulkInsert.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class MapBulkInsert<T>
    extends CollectionBulkInsert<T> {
        private static final String COMMAND = "mop insert";
        private final String mkey;

        public MapBulkInsert(List<String> keyList, String mkey, T value, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (attr != null && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.map.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.map) + ".");
            }
            this.keyList = keyList;
            this.mkey = mkey;
            this.value = value;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = keyList.size();
            this.createKeyIfNotExists = attr != null;
            this.cachedData = tc.encode(value);
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            int eachExtraSize = KeyUtil.getKeyBytes(this.mkey).length + this.cachedData.getData().length + 128;
            for (String eachKey : this.keyList) {
                capacity += KeyUtil.getKeyBytes(eachKey).length;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity += eachExtraSize * this.keyList.size());
            int kSize = this.keyList.size();
            for (int i = this.nextOpIndex; i < kSize; ++i) {
                String key = (String)this.keyList.get(i);
                byte[] value = this.cachedData.getData();
                Object[] objectArray = new Object[11];
                objectArray[0] = COMMAND;
                objectArray[1] = key;
                objectArray[2] = this.mkey;
                objectArray[3] = value.length;
                objectArray[4] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[5] = this.createKeyIfNotExists ? Integer.valueOf(this.cachedData.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[6] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[7] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction() : "") : (objectArray[8] = "");
                objectArray[9] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[10] = i < kSize - 1 ? CollectionBulkInsert.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class BTreeBulkInsert<T>
    extends CollectionBulkInsert<T> {
        private static final String COMMAND = "bop insert";
        private final String bkey;
        private final String eflag;

        public BTreeBulkInsert(List<String> keyList, long bkey, byte[] eflag, T value, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (attr != null && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.btree.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.btree) + ".");
            }
            this.keyList = keyList;
            this.bkey = String.valueOf(bkey);
            this.eflag = BTreeUtil.toHex(eflag);
            this.value = value;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = keyList.size();
            this.createKeyIfNotExists = attr != null;
            this.cachedData = tc.encode(value);
        }

        public BTreeBulkInsert(List<String> keyList, byte[] bkey, byte[] eflag, T value, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (attr != null && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.btree.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.btree) + ".");
            }
            this.keyList = keyList;
            this.bkey = BTreeUtil.toHex(bkey);
            this.eflag = BTreeUtil.toHex(eflag);
            this.value = value;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = keyList.size();
            this.createKeyIfNotExists = attr != null;
            this.cachedData = tc.encode(value);
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            int eachExtraSize = this.bkey.length() + (this.eflag != null ? this.eflag.length() : 0) + this.cachedData.getData().length + 128;
            for (String eachKey : this.keyList) {
                capacity += KeyUtil.getKeyBytes(eachKey).length;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity += eachExtraSize * this.keyList.size());
            int kSize = this.keyList.size();
            for (int i = this.nextOpIndex; i < kSize; ++i) {
                String key = (String)this.keyList.get(i);
                byte[] value = this.cachedData.getData();
                Object[] objectArray = new Object[12];
                objectArray[0] = COMMAND;
                objectArray[1] = key;
                objectArray[2] = this.bkey;
                objectArray[3] = this.eflag != null ? this.eflag : "";
                objectArray[4] = value.length;
                objectArray[5] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[6] = this.createKeyIfNotExists ? Integer.valueOf(this.cachedData.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[7] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[8] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction() : "") : (objectArray[9] = "");
                objectArray[10] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[11] = i < kSize - 1 ? CollectionBulkInsert.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }
}

