/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.BTreeInsert;
import net.spy.memcached.collection.BTreeInsertAndGet;
import net.spy.memcached.collection.BTreeUpsert;
import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.CollectionOverflowAction;
import net.spy.memcached.collection.CollectionType;
import net.spy.memcached.collection.ListInsert;
import net.spy.memcached.collection.MapInsert;
import net.spy.memcached.collection.RequestMode;
import net.spy.memcached.collection.SetInsert;
import net.spy.memcached.util.BTreeUtil;

public abstract class CollectionInsert<T> {
    protected boolean createKeyIfNotExists = false;
    protected int flags = 0;
    protected T value;
    protected RequestMode requestMode;
    protected CollectionAttributes attribute;
    protected byte[] elementFlag;
    protected String str;

    public CollectionInsert() {
    }

    public CollectionInsert(T value, byte[] elementFlag, boolean createKeyIfNotExists, RequestMode requestMode, CollectionAttributes attr) {
        CollectionOverflowAction overflowAction;
        if (attr != null && (overflowAction = attr.getOverflowAction()) != null) {
            if (this instanceof SetInsert && !CollectionType.set.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.set) + ".");
            }
            if (this instanceof MapInsert && !CollectionType.map.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.map) + ".");
            }
            if (this instanceof ListInsert && !CollectionType.list.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.list) + ".");
            }
            if ((this instanceof BTreeInsert || this instanceof BTreeUpsert || this instanceof BTreeInsertAndGet) && !CollectionType.btree.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is available overflow action in " + (Object)((Object)CollectionType.btree) + ".");
            }
        }
        if (elementFlag != null && (elementFlag.length < 1 || elementFlag.length > 31)) {
            throw new IllegalArgumentException("Length of elementFlag must be between 1 and 31.");
        }
        this.value = value;
        this.elementFlag = elementFlag;
        this.createKeyIfNotExists = createKeyIfNotExists;
        this.requestMode = requestMode;
        this.attribute = attr;
    }

    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        if (this.createKeyIfNotExists) {
            b.append("create ").append(this.flags);
            if (this.attribute != null) {
                b.append(" ").append(this.attribute.getExpireTime() == null ? CollectionAttributes.DEFAULT_EXPIRETIME : this.attribute.getExpireTime());
                b.append(" ").append(this.attribute.getMaxCount() == null ? CollectionAttributes.DEFAULT_MAXCOUNT : this.attribute.getMaxCount());
                if (null != this.attribute.getOverflowAction()) {
                    b.append(" ").append((Object)this.attribute.getOverflowAction());
                }
                if (null != this.attribute.getReadable() && !this.attribute.getReadable().booleanValue()) {
                    b.append(" ").append("unreadable");
                }
            } else {
                b.append(" ").append(CollectionAttributes.DEFAULT_EXPIRETIME);
                b.append(" ").append(CollectionAttributes.DEFAULT_MAXCOUNT);
            }
        }
        if (this.requestMode != null) {
            b.append(b.length() <= 0 ? "" : " ").append(this.requestMode.getAscii());
        }
        this.str = b.toString();
        return this.str;
    }

    public byte[] getElementFlag() {
        return this.elementFlag;
    }

    public String getElementFlagByHex() {
        if (this.elementFlag == null) {
            return "";
        }
        return BTreeUtil.toHex(this.elementFlag);
    }

    public boolean iscreateKeyIfNotExists() {
        return this.createKeyIfNotExists;
    }

    public void setcreateKeyIfNotExists(boolean createKeyIfNotExists) {
        this.createKeyIfNotExists = createKeyIfNotExists;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public RequestMode getRequestMode() {
        return this.requestMode;
    }

    public void setRequestMode(RequestMode requestMode) {
        this.requestMode = requestMode;
    }

    public void setElementFlag(byte[] elementFlag) {
        this.elementFlag = elementFlag;
    }

    public void setCollectionAttributes(CollectionAttributes attributes) {
        this.attribute = attributes;
    }

    public String toString() {
        return this.str != null ? this.str : this.stringify();
    }

    public abstract String getCommand();
}

