/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.spy.memcached.CachedData;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionAttributes;
import net.spy.memcached.collection.CollectionObject;
import net.spy.memcached.collection.CollectionOverflowAction;
import net.spy.memcached.collection.CollectionType;
import net.spy.memcached.collection.Element;
import net.spy.memcached.transcoders.Transcoder;

public abstract class CollectionPipedInsert<T>
extends CollectionObject {
    public static final String PIPE = "pipe";
    public static final int MAX_PIPED_ITEM_COUNT = 500;
    protected String key;
    protected boolean createKeyIfNotExists;
    protected Transcoder<T> tc;
    protected int itemCount;
    protected CollectionAttributes attribute;
    protected int nextOpIndex = 0;

    public void setNextOpIndex(int i) {
        this.nextOpIndex = i;
    }

    public abstract ByteBuffer getAsciiCommand();

    public abstract ByteBuffer getBinaryCommand();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean iscreateKeyIfNotExists() {
        return this.createKeyIfNotExists;
    }

    public void setcreateKeyIfNotExists(boolean createKeyIfNotExists) {
        this.createKeyIfNotExists = createKeyIfNotExists;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public static class MapPipedInsert<T>
    extends CollectionPipedInsert<T> {
        private static final String COMMAND = "mop insert";
        private Map<String, T> map;

        public MapPipedInsert(String key, Map<String, T> map, boolean createKeyIfNotExists, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (createKeyIfNotExists && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.map.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.map) + ".");
            }
            this.key = key;
            this.map = map;
            this.createKeyIfNotExists = createKeyIfNotExists;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = map.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> encodedList = new ArrayList<byte[]>(this.map.size());
            CachedData cd = null;
            for (Object each : this.map.values()) {
                cd = this.tc.encode(each);
                encodedList.add(cd.getData());
            }
            int i = 0;
            for (String eachMkey : this.map.keySet()) {
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += KeyUtil.getKeyBytes(eachMkey).length;
                capacity += ((byte[])encodedList.get(i++)).length;
                capacity += 128;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            int mkeySize = this.map.keySet().size();
            ArrayList<String> keyList = new ArrayList<String>(this.map.keySet());
            for (i = this.nextOpIndex; i < mkeySize; ++i) {
                String mkey = (String)keyList.get(i);
                byte[] value = (byte[])encodedList.get(i);
                Object[] objectArray = new Object[11];
                objectArray[0] = COMMAND;
                objectArray[1] = this.key;
                objectArray[2] = mkey;
                objectArray[3] = value.length;
                objectArray[4] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[5] = this.createKeyIfNotExists ? Integer.valueOf(cd.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[6] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[7] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction() : "") : (objectArray[8] = "");
                objectArray[9] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[10] = i < mkeySize - 1 ? CollectionPipedInsert.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class ByteArraysBTreePipedInsert<T>
    extends CollectionPipedInsert<T> {
        private static final String COMMAND = "bop insert";
        private List<Element<T>> elements;

        public ByteArraysBTreePipedInsert(String key, List<Element<T>> elements, boolean createKeyIfNotExists, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (createKeyIfNotExists && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.btree.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.btree) + ".");
            }
            this.key = key;
            this.elements = elements;
            this.createKeyIfNotExists = createKeyIfNotExists;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = elements.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> decodedList = new ArrayList<byte[]>(this.elements.size());
            CachedData cd = null;
            for (Element<T> element : this.elements) {
                cd = this.tc.encode(element.getValue());
                decodedList.add(cd.getData());
            }
            int i = 0;
            for (Element<T> element : this.elements) {
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += KeyUtil.getKeyBytes(element.isByteArraysBkey() ? element.getBkeyByHex() : String.valueOf(element.getLongBkey())).length;
                capacity += KeyUtil.getKeyBytes(element.getFlagByHex()).length;
                capacity += ((byte[])decodedList.get(i++)).length;
                capacity += 128;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(capacity);
            int n = this.elements.size();
            for (i = this.nextOpIndex; i < n; ++i) {
                Element<T> element = this.elements.get(i);
                byte[] value = (byte[])decodedList.get(i);
                Object[] objectArray = new Object[12];
                objectArray[0] = COMMAND;
                objectArray[1] = this.key;
                objectArray[2] = element.isByteArraysBkey() ? element.getBkeyByHex() : String.valueOf(element.getLongBkey());
                objectArray[3] = element.getFlagByHex();
                objectArray[4] = value.length;
                objectArray[5] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[6] = this.createKeyIfNotExists ? Integer.valueOf(cd.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[7] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[8] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction().toString() : "") : (objectArray[9] = "");
                objectArray[10] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[11] = i < n - 1 ? CollectionPipedInsert.PIPE : "";
                this.setArguments(byteBuffer, objectArray);
                byteBuffer.put(value);
                byteBuffer.put(CRLF);
            }
            byteBuffer.flip();
            return byteBuffer;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class BTreePipedInsert<T>
    extends CollectionPipedInsert<T> {
        private static final String COMMAND = "bop insert";
        private Map<Long, T> map;

        public BTreePipedInsert(String key, Map<Long, T> map, boolean createKeyIfNotExists, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (createKeyIfNotExists && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.btree.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.btree) + ".");
            }
            this.key = key;
            this.map = map;
            this.createKeyIfNotExists = createKeyIfNotExists;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = map.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> decodedList = new ArrayList<byte[]>(this.map.size());
            CachedData cd = null;
            for (Object each : this.map.values()) {
                cd = this.tc.encode(each);
                decodedList.add(cd.getData());
            }
            int i = 0;
            for (Long eachBkey : this.map.keySet()) {
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += KeyUtil.getKeyBytes(String.valueOf(eachBkey)).length;
                capacity += ((byte[])decodedList.get(i++)).length;
                capacity += 128;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            int keySize = this.map.keySet().size();
            ArrayList<Long> keyList = new ArrayList<Long>(this.map.keySet());
            for (i = this.nextOpIndex; i < keySize; ++i) {
                Long bkey = (Long)keyList.get(i);
                byte[] value = (byte[])decodedList.get(i);
                Object[] objectArray = new Object[11];
                objectArray[0] = COMMAND;
                objectArray[1] = this.key;
                objectArray[2] = bkey;
                objectArray[3] = value.length;
                objectArray[4] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[5] = this.createKeyIfNotExists ? Integer.valueOf(cd.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[6] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[7] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction() : "") : (objectArray[8] = "");
                objectArray[9] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[10] = i < keySize - 1 ? CollectionPipedInsert.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(value);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class SetPipedInsert<T>
    extends CollectionPipedInsert<T> {
        private static final String COMMAND = "sop insert";
        private Collection<T> set;

        public SetPipedInsert(String key, Collection<T> set, boolean createKeyIfNotExists, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (createKeyIfNotExists && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.set.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.set) + ".");
            }
            this.key = key;
            this.set = set;
            this.createKeyIfNotExists = createKeyIfNotExists;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = set.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> encodedList = new ArrayList<byte[]>(this.set.size());
            CachedData cd = null;
            for (Object each : this.set) {
                cd = this.tc.encode(each);
                encodedList.add(cd.getData());
            }
            Iterator<Object> iterator = encodedList.iterator();
            while (iterator.hasNext()) {
                Object each;
                each = (byte[])iterator.next();
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += ((T)each).length;
                capacity += 128;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            int eSize = encodedList.size();
            for (int i = this.nextOpIndex; i < eSize; ++i) {
                byte[] each = (byte[])encodedList.get(i);
                Object[] objectArray = new Object[10];
                objectArray[0] = COMMAND;
                objectArray[1] = this.key;
                objectArray[2] = each.length;
                objectArray[3] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[4] = this.createKeyIfNotExists ? Integer.valueOf(cd.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[5] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[6] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction() : "") : (objectArray[7] = "");
                objectArray[8] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[9] = i < eSize - 1 ? CollectionPipedInsert.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(each);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class ListPipedInsert<T>
    extends CollectionPipedInsert<T> {
        private static final String COMMAND = "lop insert";
        private Collection<T> list;
        private int index;

        public ListPipedInsert(String key, int index, Collection<T> list, boolean createKeyIfNotExists, CollectionAttributes attr, Transcoder<T> tc) {
            CollectionOverflowAction overflowAction;
            if (createKeyIfNotExists && (overflowAction = attr.getOverflowAction()) != null && !CollectionType.list.isAvailableOverflowAction(overflowAction)) {
                throw new IllegalArgumentException((Object)((Object)overflowAction) + " is unavailable overflow action in " + (Object)((Object)CollectionType.list) + ".");
            }
            this.key = key;
            this.index = index;
            this.list = list;
            this.createKeyIfNotExists = createKeyIfNotExists;
            this.attribute = attr;
            this.tc = tc;
            this.itemCount = list.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> encodedList = new ArrayList<byte[]>(this.list.size());
            CachedData cd = null;
            for (Object each : this.list) {
                cd = this.tc.encode(each);
                encodedList.add(cd.getData());
            }
            Iterator<Object> iterator = encodedList.iterator();
            while (iterator.hasNext()) {
                Object each;
                each = (byte[])iterator.next();
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += ((T)each).length;
                capacity += 128;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            int eSize = encodedList.size();
            for (int i = this.nextOpIndex; i < eSize; ++i) {
                byte[] each = (byte[])encodedList.get(i);
                Object[] objectArray = new Object[11];
                objectArray[0] = COMMAND;
                objectArray[1] = this.key;
                objectArray[2] = this.index;
                objectArray[3] = each.length;
                objectArray[4] = this.createKeyIfNotExists ? "create" : "";
                Object object = objectArray[5] = this.createKeyIfNotExists ? Integer.valueOf(cd.getFlags()) : "";
                Object object2 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getExpireTime() != null ? this.attribute.getExpireTime() : CollectionAttributes.DEFAULT_EXPIRETIME) : (objectArray[6] = "");
                Object object3 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getMaxCount() != null ? this.attribute.getMaxCount() : CollectionAttributes.DEFAULT_MAXCOUNT) : (objectArray[7] = "");
                Object object4 = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getOverflowAction() != null ? this.attribute.getOverflowAction() : "") : (objectArray[8] = "");
                objectArray[9] = this.createKeyIfNotExists ? (this.attribute != null && this.attribute.getReadable() != null && !this.attribute.getReadable().booleanValue() ? "unreadable" : "") : "";
                objectArray[10] = i < eSize - 1 ? CollectionPipedInsert.PIPE : "";
                this.setArguments(bb, objectArray);
                bb.put(each);
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }
}

