/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.spy.memcached.CachedData;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionObject;
import net.spy.memcached.collection.Element;
import net.spy.memcached.collection.ElementFlagUpdate;
import net.spy.memcached.transcoders.Transcoder;

public abstract class CollectionPipedUpdate<T>
extends CollectionObject {
    public static final String PIPE = "pipe";
    public static final int MAX_PIPED_ITEM_COUNT = 500;
    protected String key;
    protected Transcoder<T> tc;
    protected int itemCount;
    protected int nextOpIndex = 0;

    public void setNextOpIndex(int i) {
        this.nextOpIndex = i;
    }

    public abstract ByteBuffer getAsciiCommand();

    public abstract ByteBuffer getBinaryCommand();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public static class MapPipedUpdate<T>
    extends CollectionPipedUpdate<T> {
        private static final String COMMAND = "mop update";
        private Map<String, T> elements;

        public MapPipedUpdate(String key, Map<String, T> elements, Transcoder<T> tc) {
            this.key = key;
            this.elements = elements;
            this.tc = tc;
            this.itemCount = elements.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            int capacity = 0;
            ArrayList<byte[]> encodedList = new ArrayList<byte[]>(this.elements.size());
            CachedData cd = null;
            for (T each : this.elements.values()) {
                cd = this.tc.encode(each);
                encodedList.add(cd.getData());
            }
            int i = 0;
            for (String eachMkey : this.elements.keySet()) {
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += KeyUtil.getKeyBytes(eachMkey).length;
                capacity += ((byte[])encodedList.get(i++)).length;
                capacity += 64;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            int mkeySize = this.elements.keySet().size();
            ArrayList<String> keyList = new ArrayList<String>(this.elements.keySet());
            for (i = this.nextOpIndex; i < mkeySize; ++i) {
                String mkey = (String)keyList.get(i);
                byte[] value = (byte[])encodedList.get(i);
                StringBuilder b = new StringBuilder();
                this.setArguments(bb, COMMAND, this.key, mkey, b.toString(), value == null ? -1 : value.length, i < mkeySize - 1 ? CollectionPipedUpdate.PIPE : "");
                if (value == null) continue;
                if (value.length > 0) {
                    bb.put(value);
                }
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }

    public static class BTreePipedUpdate<T>
    extends CollectionPipedUpdate<T> {
        private static final String COMMAND = "bop update";
        private List<Element<T>> elements;

        public BTreePipedUpdate(String key, List<Element<T>> elements, Transcoder<T> tc) {
            this.key = key;
            this.elements = elements;
            this.tc = tc;
            this.itemCount = elements.size();
        }

        @Override
        public ByteBuffer getAsciiCommand() {
            ElementFlagUpdate eflagUpdate;
            int capacity = 0;
            ArrayList<byte[]> decodedList = new ArrayList<byte[]>(this.elements.size());
            CachedData cd = null;
            for (Element<T> each : this.elements) {
                if (each.getValue() != null) {
                    cd = this.tc.encode(each.getValue());
                    decodedList.add(cd.getData());
                    continue;
                }
                decodedList.add(null);
            }
            int i = 0;
            for (Element<T> each : this.elements) {
                eflagUpdate = each.getElementFlagUpdate();
                if (eflagUpdate != null) {
                    capacity += KeyUtil.getKeyBytes(eflagUpdate.getElementFlagByHex()).length;
                    if (eflagUpdate.getElementFlagOffset() > -1) {
                        capacity += 6;
                    }
                }
                capacity += KeyUtil.getKeyBytes(this.key).length;
                capacity += KeyUtil.getKeyBytes(each.isByteArraysBkey() ? each.getBkeyByHex() : String.valueOf(each.getLongBkey())).length;
                if (decodedList.get(i) != null) {
                    capacity += ((byte[])decodedList.get(i++)).length;
                }
                capacity += 64;
            }
            ByteBuffer bb = ByteBuffer.allocate(capacity);
            int eSize = this.elements.size();
            for (i = this.nextOpIndex; i < eSize; ++i) {
                Element<T> element = this.elements.get(i);
                byte[] value = (byte[])decodedList.get(i);
                eflagUpdate = element.getElementFlagUpdate();
                StringBuilder b = new StringBuilder();
                if (eflagUpdate != null) {
                    if (eflagUpdate.getElementFlagOffset() > -1 && eflagUpdate.getBitOp() != null) {
                        b.append(eflagUpdate.getElementFlagOffset()).append(" ");
                        b.append((Object)eflagUpdate.getBitOp()).append(" ");
                    }
                    b.append(eflagUpdate.getElementFlagByHex());
                }
                this.setArguments(bb, COMMAND, this.key, element.isByteArraysBkey() ? element.getBkeyByHex() : String.valueOf(element.getLongBkey()), b.toString(), value == null ? -1 : value.length, i < eSize - 1 ? CollectionPipedUpdate.PIPE : "");
                if (value == null) continue;
                if (value.length > 0) {
                    bb.put(value);
                }
                bb.put(CRLF);
            }
            bb.flip();
            return bb;
        }

        @Override
        public ByteBuffer getBinaryCommand() {
            throw new RuntimeException("not supported in binary protocol yet.");
        }
    }
}

