/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.util.EnumSet;
import java.util.Set;
import net.spy.memcached.collection.CollectionOverflowAction;

public enum CollectionType {
    kv("kv", null),
    list("list", EnumSet.of(CollectionOverflowAction.error, CollectionOverflowAction.head_trim, CollectionOverflowAction.tail_trim)),
    set("set", EnumSet.of(CollectionOverflowAction.error)),
    map("map", EnumSet.of(CollectionOverflowAction.error)),
    btree("b+tree", EnumSet.of(CollectionOverflowAction.error, CollectionOverflowAction.smallest_silent_trim, CollectionOverflowAction.smallest_trim, CollectionOverflowAction.largest_silent_trim, CollectionOverflowAction.largest_trim));

    private final Set<CollectionOverflowAction> availableOverflowAction;
    private final String stringValue;

    private CollectionType(String stringValue, Set<CollectionOverflowAction> available) {
        this.stringValue = stringValue;
        this.availableOverflowAction = available;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public static CollectionType find(String value) {
        for (CollectionType each : CollectionType.values()) {
            if (!each.stringValue.equals(value)) continue;
            return each;
        }
        return null;
    }

    public boolean isAvailableOverflowAction(CollectionOverflowAction overflowAction) {
        return this.availableOverflowAction.contains((Object)overflowAction);
    }
}

