/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.ElementFlagUpdate;

public abstract class CollectionUpdate<T> {
    protected int flags = 0;
    protected T newValue;
    protected ElementFlagUpdate eflagUpdate;
    protected boolean noreply = false;
    protected String str;

    public CollectionUpdate(T newValue, ElementFlagUpdate eflagUpdate, boolean noreply) {
        if (eflagUpdate == null) {
            if (newValue == null) {
                throw new IllegalArgumentException("One of the newValue or elementFlag must not be null.");
            }
        } else if (eflagUpdate.getElementFlag().length > 31) {
            throw new IllegalArgumentException("length of element flag cannot exceed 31.");
        }
        this.newValue = newValue;
        this.eflagUpdate = eflagUpdate;
        this.noreply = noreply;
    }

    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        if (this.noreply) {
            b.append(b.length() <= 0 ? "" : " ").append("noreply");
        }
        this.str = b.toString();
        return this.str;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public T getNewValue() {
        return this.newValue;
    }

    public void setNewValue(T newValue) {
        this.newValue = newValue;
    }

    public ElementFlagUpdate getElementFlagUpdate() {
        return this.eflagUpdate;
    }

    public void setElementFlagUpdate(ElementFlagUpdate eflagUpdate) {
        this.eflagUpdate = eflagUpdate;
    }

    public boolean isNoreply() {
        return this.noreply;
    }

    public void setNoreply(boolean noreply) {
        this.noreply = noreply;
    }

    public String toString() {
        return this.str != null ? this.str : this.stringify();
    }

    public abstract String getCommand();
}

