/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.util.ArrayList;
import net.spy.memcached.collection.ElementFlagFilter;
import net.spy.memcached.util.BTreeUtil;

public class ElementMultiFlagsFilter
extends ElementFlagFilter {
    static final int MAX_EFLAGS = 100;
    private ArrayList<byte[]> compValue = new ArrayList();

    public ElementMultiFlagsFilter setCompOperand(ElementFlagFilter.CompOperands compOperand) {
        if (compOperand == null) {
            throw new NullPointerException("Invalid compOperand");
        }
        if (compOperand != ElementFlagFilter.CompOperands.Equal && compOperand != ElementFlagFilter.CompOperands.NotEqual) {
            throw new IllegalArgumentException("The only compOperand Equal and NotEqual can compare multi compValues.");
        }
        this.compOp = compOperand;
        return this;
    }

    public ElementMultiFlagsFilter addCompValue(byte[] compValue) {
        if (compValue == null) {
            throw new NullPointerException("Invalid compOperand and compValue.");
        }
        if (compValue.length == 0) {
            throw new IllegalArgumentException("Length of comparison value must be larger than 0.");
        }
        if (compValue.length > 31) {
            throw new IllegalArgumentException("Length of comparison value must be less than 31");
        }
        if (this.compValue.size() > 100) {
            throw new IllegalArgumentException("Count of comparison values must be less than 100");
        }
        if (this.compValue.size() > 0 && this.compValue.get(0).length != compValue.length) {
            throw new IllegalArgumentException("Length of comparison value must be same with " + this.compValue.get(0).length);
        }
        this.compValue.add(compValue);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fwhere).append(" ");
        if (this.isBitWiseOpEnabled()) {
            sb.append((Object)this.bitOp).append(" ");
            sb.append(BTreeUtil.toHex(this.bitCompValue)).append(" ");
        }
        sb.append((Object)this.compOp).append(" ");
        for (int i = 0; i < this.compValue.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(BTreeUtil.toHex(this.compValue.get(i)));
        }
        return sb.toString();
    }
}

