/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionDelete;

public class ListDelete
extends CollectionDelete {
    private static final String command = "lop delete";

    public ListDelete(int index, boolean noreply) {
        this.range = String.valueOf(index);
        this.noreply = noreply;
    }

    public ListDelete(int index, boolean noreply, boolean dropIfEmpty) {
        this(index, noreply);
        this.dropIfEmpty = dropIfEmpty;
    }

    public ListDelete(int from, int to, boolean noreply) {
        this.range = String.valueOf(from) + ".." + String.valueOf(to);
        this.noreply = noreply;
    }

    public ListDelete(int from, int to, boolean noreply, boolean dropIfEmpty) {
        this(from, to, noreply);
        this.dropIfEmpty = dropIfEmpty;
    }

    @Override
    public byte[] getAdditionalArgs() {
        return null;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.range);
        if (this.dropIfEmpty) {
            b.append(" drop");
        }
        if (this.noreply) {
            b.append(" noreply");
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }
}

