/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionGet;

public class ListGet
extends CollectionGet {
    public static final int FIRST = 0;
    public static final int LAST = -1;
    private static final String command = "lop get";

    public ListGet(int index, boolean delete) {
        this.headerCount = 1;
        this.range = String.valueOf(index);
        this.delete = delete;
    }

    public ListGet(int index, boolean delete, boolean dropIfEmpty) {
        this(index, delete);
        this.dropIfEmpty = dropIfEmpty;
    }

    public ListGet(int from, int to, boolean delete) {
        this.headerCount = 1;
        this.range = String.valueOf(from) + ".." + String.valueOf(to);
        this.delete = delete;
    }

    public ListGet(int from, int to, boolean delete, boolean dropIfEmpty) {
        this(from, to, delete);
        this.dropIfEmpty = dropIfEmpty;
    }

    public String getRange() {
        return this.range;
    }

    public void setRange(String range) {
        this.range = range;
    }

    @Override
    public byte[] getAddtionalArgs() {
        return null;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        StringBuilder b = new StringBuilder();
        b.append(this.range);
        if (this.delete && this.dropIfEmpty) {
            b.append(" drop");
        }
        if (this.delete && !this.dropIfEmpty) {
            b.append(" delete");
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }

    @Override
    public void decodeItemHeader(String itemHeader) {
        this.dataLength = Integer.parseInt(itemHeader);
    }
}

