/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.util.List;
import net.spy.memcached.collection.CollectionDelete;

public class MapDelete
extends CollectionDelete {
    private static final String command = "mop delete";
    protected List<String> mkeyList;
    private String keySeparator;
    private String spaceSeparatedKeys;
    protected byte[] additionalArgs;

    public MapDelete(List<String> mkeyList, boolean noreply) {
        this.mkeyList = mkeyList;
        this.noreply = noreply;
    }

    public MapDelete(List<String> mkeyList, boolean noreply, boolean dropIfEmpty) {
        this(mkeyList, noreply);
        this.dropIfEmpty = dropIfEmpty;
    }

    public void setKeySeparator(String keySeparator) {
        this.keySeparator = keySeparator;
    }

    public String getSpaceSeparatedMkeys() {
        if (this.spaceSeparatedKeys != null) {
            return this.spaceSeparatedKeys;
        }
        StringBuilder sb = new StringBuilder();
        int numkeys = this.mkeyList.size();
        for (int i = 0; i < numkeys; ++i) {
            sb.append(this.mkeyList.get(i));
            if (i + 1 >= numkeys) continue;
            sb.append(this.keySeparator);
        }
        this.spaceSeparatedKeys = sb.toString();
        return this.spaceSeparatedKeys;
    }

    @Override
    public byte[] getAdditionalArgs() {
        return this.additionalArgs;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        this.additionalArgs = (byte[])(this.mkeyList.size() == 0 ? null : this.getSpaceSeparatedMkeys().getBytes());
        StringBuilder b = new StringBuilder();
        if (this.additionalArgs == null) {
            b.append("0");
        } else {
            b.append(this.additionalArgs.length);
        }
        b.append(" ").append(this.mkeyList.size());
        if (this.dropIfEmpty) {
            b.append(" drop");
        }
        if (this.noreply) {
            b.append(" noreply");
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }
}

