/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.util.List;
import net.spy.memcached.collection.CollectionGet;

public class MapGet
extends CollectionGet {
    private static final String command = "mop get";
    protected List<String> mkeyList;
    protected byte[] data;
    private String keySeparator;
    private String spaceSeparatedKeys;
    protected byte[] additionalArgs;

    public MapGet(List<String> mkeyList, boolean delete) {
        this.headerCount = 2;
        this.mkeyList = mkeyList;
        this.delete = delete;
    }

    public MapGet(List<String> mkeyList, boolean delete, boolean dropIfEmpty) {
        this(mkeyList, delete);
        this.dropIfEmpty = dropIfEmpty;
    }

    public void setKeySeparator(String keySeparator) {
        this.keySeparator = keySeparator;
    }

    public String getSpaceSeparatedMkeys() {
        if (this.spaceSeparatedKeys != null) {
            return this.spaceSeparatedKeys;
        }
        StringBuilder sb = new StringBuilder();
        int numkeys = this.mkeyList.size();
        for (int i = 0; i < numkeys; ++i) {
            sb.append(this.mkeyList.get(i));
            if (i + 1 >= numkeys) continue;
            sb.append(this.keySeparator);
        }
        this.spaceSeparatedKeys = sb.toString();
        return this.spaceSeparatedKeys;
    }

    @Override
    public byte[] getAddtionalArgs() {
        return this.additionalArgs;
    }

    @Override
    public String stringify() {
        if (this.str != null) {
            return this.str;
        }
        this.additionalArgs = (byte[])(this.mkeyList.size() == 0 ? null : this.getSpaceSeparatedMkeys().getBytes());
        StringBuilder b = new StringBuilder();
        if (this.additionalArgs == null) {
            b.append("0");
        } else {
            b.append(this.additionalArgs.length);
        }
        b.append(" ").append(this.mkeyList.size());
        if (this.delete && this.dropIfEmpty) {
            b.append(" drop");
        }
        if (this.delete && !this.dropIfEmpty) {
            b.append(" delete");
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }

    @Override
    public void decodeItemHeader(String itemHeader) {
        String[] splited = itemHeader.split(" ");
        this.subkey = splited[0];
        this.dataLength = Integer.parseInt(splited[1]);
    }
}

