/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.util.BTreeUtil;

public class SMGetElement<T>
implements Comparable<SMGetElement<T>> {
    private String key;
    private long bkey;
    private byte[] bytebkey;
    private T value;

    public SMGetElement(String key, long bkey, T value) {
        this.key = key;
        this.bkey = bkey;
        this.bytebkey = null;
        this.value = value;
    }

    public SMGetElement(String key, byte[] bkey, T value) {
        this.key = key;
        this.bkey = -1L;
        this.bytebkey = bkey;
        this.value = value;
    }

    public String toString() {
        return "SMGetElement {KEY:" + this.key + ", BKEY:" + (this.bytebkey == null ? Long.valueOf(this.bkey) : BTreeUtil.toHex(this.bytebkey)) + ", VALUE:" + this.value + "}";
    }

    @Override
    public int compareTo(SMGetElement<T> param) {
        assert (param != null);
        int comp = this.bytebkey == null ? Long.valueOf(this.bkey).compareTo(param.getBkey()) : BTreeUtil.compareByteArraysInLexOrder(this.bytebkey, param.getByteBkey());
        if (comp == 0) {
            comp = this.key.compareTo(param.getKey());
        }
        return comp;
    }

    public int compareBkeyTo(SMGetElement<T> param) {
        assert (param != null);
        if (this.bytebkey == null) {
            return Long.valueOf(this.bkey).compareTo(param.getBkey());
        }
        return BTreeUtil.compareByteArraysInLexOrder(this.bytebkey, param.getByteBkey());
    }

    public int compareKeyTo(SMGetElement<T> param) {
        assert (param != null);
        return this.key.compareTo(param.getKey());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getBkey() {
        if (this.bkey == -1L) {
            throw new IllegalStateException("This element has byte[] bkey. " + this.toString());
        }
        return this.bkey;
    }

    public byte[] getByteBkey() {
        if (this.bytebkey == null) {
            throw new IllegalStateException("This element has java.lang.Long type bkey. " + this.toString());
        }
        return this.bytebkey;
    }

    public Object getBkeyByObject() {
        if (this.bytebkey != null) {
            return this.bytebkey;
        }
        return this.bkey;
    }

    public void setBkey(long bkey) {
        this.bkey = bkey;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean hasByteArrayBkey() {
        return this.bytebkey != null;
    }
}

