/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.ByteArrayBKey;
import net.spy.memcached.util.BTreeUtil;

public class SMGetTrimKey
implements Comparable<SMGetTrimKey> {
    private String key;
    private long bkey;
    private byte[] bytebkey;

    public SMGetTrimKey(String key, Object bkey) {
        this.key = key;
        if (bkey instanceof byte[]) {
            this.bytebkey = new ByteArrayBKey((byte[])bkey).getBytes();
            this.bkey = -1L;
        } else {
            this.bkey = (Long)bkey;
            this.bytebkey = null;
        }
    }

    public String toString() {
        return "SMGetElement {KEY:" + this.key + ", BKEY:" + (this.bytebkey == null ? Long.valueOf(this.bkey) : BTreeUtil.toHex(this.bytebkey)) + "}";
    }

    @Override
    public int compareTo(SMGetTrimKey param) {
        assert (param != null);
        int comp = this.bytebkey == null ? Long.valueOf(this.bkey).compareTo(param.getBkey()) : BTreeUtil.compareByteArraysInLexOrder(this.bytebkey, param.getByteBkey());
        if (comp == 0) {
            comp = this.key.compareTo(param.getKey());
        }
        return comp;
    }

    public int compareBkeyTo(SMGetTrimKey param) {
        assert (param != null);
        if (this.bytebkey == null) {
            return Long.valueOf(this.bkey).compareTo(param.getBkey());
        }
        return BTreeUtil.compareByteArraysInLexOrder(this.bytebkey, param.getByteBkey());
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public long getBkey() {
        if (this.bkey == -1L) {
            throw new IllegalStateException("This element has byte[] bkey. " + this.toString());
        }
        return this.bkey;
    }

    public byte[] getByteBkey() {
        if (this.bytebkey == null) {
            throw new IllegalStateException("This element has java.lang.Long type bkey. " + this.toString());
        }
        return this.bytebkey;
    }

    public Object getBkeyByObject() {
        if (this.bytebkey != null) {
            return this.bytebkey;
        }
        return this.bkey;
    }

    public void setBkey(long bkey) {
        this.bkey = bkey;
    }

    public boolean hasByteArrayBkey() {
        return this.bytebkey != null;
    }
}

