/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import net.spy.memcached.collection.CollectionDelete;
import net.spy.memcached.transcoders.Transcoder;

public class SetDelete<T>
extends CollectionDelete {
    private static final String command = "sop delete";
    protected T value;
    protected byte[] additionalArgs;
    protected Transcoder<T> tc;

    public SetDelete(T value, boolean noreply, Transcoder<T> tc) {
        this.value = value;
        this.noreply = noreply;
        this.tc = tc;
        this.additionalArgs = tc.encode(value).getData();
    }

    public SetDelete(T value, boolean noreply, boolean dropIfEmpty, Transcoder<T> tc) {
        this(value, noreply, tc);
        this.dropIfEmpty = dropIfEmpty;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public byte[] getAdditionalArgs() {
        return this.additionalArgs;
    }

    @Override
    public String stringify() {
        StringBuilder b = new StringBuilder();
        b.append(this.additionalArgs.length);
        if (this.dropIfEmpty) {
            b.append(" drop");
        }
        if (this.noreply) {
            b.append(" noreply");
        }
        this.str = b.toString();
        return this.str;
    }

    @Override
    public String getCommand() {
        return command;
    }
}

