/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.collection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.spy.memcached.CachedData;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.CollectionObject;
import net.spy.memcached.transcoders.Transcoder;

public class SetPipedExist<T>
extends CollectionObject {
    public static final int MAX_PIPED_ITEM_COUNT = 500;
    private static final String COMMAND = "sop exist";
    private static final String PIPE = "pipe";
    private final String key;
    private final List<T> values;
    private final Transcoder<T> tc;
    private int itemCount;

    public List<T> getValues() {
        return this.values;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public SetPipedExist(String key, List<T> values, Transcoder<T> tc) {
        this.key = key;
        this.values = values;
        this.tc = tc;
        this.itemCount = values.size();
    }

    public ByteBuffer getAsciiCommand() {
        int capacity = 0;
        ArrayList<byte[]> encodedList = new ArrayList<byte[]>(this.values.size());
        CachedData cd = null;
        for (Object each : this.values) {
            cd = this.tc.encode(each);
            encodedList.add(cd.getData());
        }
        Iterator<Object> iterator = encodedList.iterator();
        while (iterator.hasNext()) {
            Object each;
            each = (byte[])iterator.next();
            capacity += KeyUtil.getKeyBytes(this.key).length;
            capacity += ((T)each).length;
            capacity += 64;
        }
        ByteBuffer bb = ByteBuffer.allocate(capacity);
        int eSize = encodedList.size();
        for (int i = 0; i < eSize; ++i) {
            byte[] each = (byte[])encodedList.get(i);
            this.setArguments(bb, COMMAND, this.key, each.length, i < eSize - 1 ? PIPE : "");
            bb.put(each);
            bb.put(CRLF);
        }
        bb.flip();
        return bb;
    }

    public ByteBuffer getBinaryCommand() {
        throw new RuntimeException("not supported in binary protocol yet.");
    }
}

