/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.compat.log;

import net.spy.memcached.compat.log.AbstractLogger;
import net.spy.memcached.compat.log.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ObjectMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.spi.ExtendedLoggerWrapper;

public class Log4JLogger
extends AbstractLogger {
    private final ExtendedLoggerWrapper logger;

    public Log4JLogger(String name) {
        super(name);
        Logger l4jLogger = LogManager.getLogger((String)name);
        this.logger = new ExtendedLoggerWrapper((ExtendedLogger)((org.apache.logging.log4j.spi.AbstractLogger)l4jLogger), l4jLogger.getName(), l4jLogger.getMessageFactory());
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void log(Level level, Object message, Throwable e) {
        org.apache.logging.log4j.Level pLevel;
        switch (level == null ? Level.FATAL : level) {
            case TRACE: {
                pLevel = org.apache.logging.log4j.Level.TRACE;
                break;
            }
            case DEBUG: {
                pLevel = org.apache.logging.log4j.Level.DEBUG;
                break;
            }
            case INFO: {
                pLevel = org.apache.logging.log4j.Level.INFO;
                break;
            }
            case WARN: {
                pLevel = org.apache.logging.log4j.Level.WARN;
                break;
            }
            case ERROR: {
                pLevel = org.apache.logging.log4j.Level.ERROR;
                break;
            }
            case FATAL: {
                pLevel = org.apache.logging.log4j.Level.FATAL;
                break;
            }
            default: {
                pLevel = org.apache.logging.log4j.Level.FATAL;
                this.logger.logIfEnabled("net.spy.memcached.compat.log.AbstractLogger", pLevel, null, "Unhandled log level:  " + (Object)((Object)level) + " for the following message");
            }
        }
        this.logger.logIfEnabled("net.spy.memcached.compat.log.AbstractLogger", pLevel, null, (Message)new ObjectMessage(message), e);
    }
}

