/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;

public abstract class BulkOperationFuture<T>
extends OperationFuture<Map<String, T>> {
    protected final Map<String, T> failedResult = new HashMap<String, T>();
    protected final ConcurrentLinkedQueue<Operation> ops = new ConcurrentLinkedQueue();

    public BulkOperationFuture(Collection<String> keys, CountDownLatch l, long timeout) {
        super(l, timeout);
        for (String key : keys) {
            this.ops.add(this.createOp(key));
        }
    }

    @Override
    public boolean cancel(boolean ign) {
        boolean rv = false;
        for (Operation op : this.ops) {
            op.cancel("by application.");
            rv |= op.getState() == OperationState.WRITE_QUEUED;
        }
        return rv;
    }

    @Override
    public boolean isCancelled() {
        for (Operation op : this.ops) {
            if (!op.isCancelled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, T> get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.latch.await(duration, units)) {
            for (Operation op : this.ops) {
                if (op.getState() != OperationState.COMPLETE) {
                    MemcachedConnection.opTimedOut(op);
                    continue;
                }
                MemcachedConnection.opSucceeded(op);
            }
            throw new CheckedOperationTimeoutException("Timed out waiting for bulk operation >" + duration + " " + (Object)((Object)units), this.ops);
        }
        for (Operation op : this.ops) {
            MemcachedConnection.opSucceeded(op);
        }
        for (Operation op : this.ops) {
            if (op != null && op.hasErrored()) {
                throw new ExecutionException(op.getException());
            }
            if (op == null || !op.isCancelled()) continue;
            throw new ExecutionException(new RuntimeException(op.getCancelCause()));
        }
        return this.failedResult;
    }

    public abstract Operation createOp(String var1);
}

