/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;

public class CollectionGetBulkFuture<T>
implements Future<T> {
    private final Collection<Operation> ops;
    private final long timeout;
    private final CountDownLatch latch;
    private final T result;

    public CollectionGetBulkFuture(CountDownLatch latch, Collection<Operation> ops, T result, long timeout) {
        this.latch = latch;
        this.ops = ops;
        this.result = result;
        this.timeout = timeout;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out waiting for smget operation", e);
        }
    }

    @Override
    public T get(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.latch.await(duration, units)) {
            for (Operation op : this.ops) {
                MemcachedConnection.opTimedOut(op);
            }
            throw new CheckedOperationTimeoutException("Timed out waiting for b+tree get bulk operation", this.ops);
        }
        for (Operation op : this.ops) {
            MemcachedConnection.opSucceeded(op);
        }
        for (Operation op : this.ops) {
            if (op != null && op.hasErrored()) {
                throw new ExecutionException(op.getException());
            }
            if (op == null || !op.isCancelled()) continue;
            throw new ExecutionException(new RuntimeException(op.getCancelCause()));
        }
        return this.result;
    }

    @Override
    public boolean cancel(boolean ign) {
        boolean rv = false;
        for (Operation op : this.ops) {
            op.cancel("by application.");
            rv |= op.getState() == OperationState.WRITE_QUEUED;
        }
        return rv;
    }

    @Override
    public boolean isCancelled() {
        boolean rv = false;
        for (Operation op : this.ops) {
            rv |= op.isCancelled();
        }
        return rv;
    }

    @Override
    public boolean isDone() {
        for (Operation op : this.ops) {
            if (op.getState() == OperationState.COMPLETE || op.isCancelled()) continue;
            return false;
        }
        return true;
    }

    public CollectionOperationStatus getOperationStatus() {
        if (this.isCancelled()) {
            return new CollectionOperationStatus(new OperationStatus(false, "CANCELED"));
        }
        return new CollectionOperationStatus(new OperationStatus(true, "END"));
    }
}

