/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.ops;

import java.util.ArrayList;
import java.util.Collection;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.ops.CASOperation;
import net.spy.memcached.ops.CollectionDeleteOperation;
import net.spy.memcached.ops.CollectionExistOperation;
import net.spy.memcached.ops.CollectionGetOperation;
import net.spy.memcached.ops.CollectionInsertOperation;
import net.spy.memcached.ops.ConcatenationOperation;
import net.spy.memcached.ops.DeleteOperation;
import net.spy.memcached.ops.GetAttrOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.MutatorOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.SetAttrOperation;
import net.spy.memcached.ops.StoreOperation;

public abstract class BaseOperationFactory
implements OperationFactory {
    private String first(Collection<String> keys) {
        return keys.iterator().next();
    }

    @Override
    public Collection<Operation> clone(KeyedOperation op) {
        assert (op.getState() == OperationState.WRITE_QUEUED) : "Who passed me an operation in the " + (Object)((Object)op.getState()) + "state?";
        assert (!op.isCancelled()) : "Attempted to clone a canceled op";
        assert (!op.hasErrored()) : "Attempted to clone an errored op";
        ArrayList<Operation> rv = new ArrayList<Operation>(op.getKeys().size());
        if (op instanceof GetOperation) {
            rv.addAll(this.cloneGet(op));
        } else if (op instanceof GetsOperation) {
            GetsOperation.Callback callback = (GetsOperation.Callback)op.getCallback();
            for (String k : op.getKeys()) {
                rv.add(this.gets(k, callback));
            }
        } else if (op instanceof CASOperation) {
            CASOperation cop = (CASOperation)op;
            rv.add(this.cas(cop.getStoreType(), this.first(op.getKeys()), cop.getCasValue(), cop.getFlags(), cop.getExpiration(), cop.getBytes(), cop.getCallback()));
        } else if (op instanceof DeleteOperation) {
            rv.add(this.delete(this.first(op.getKeys()), op.getCallback()));
        } else if (op instanceof MutatorOperation) {
            MutatorOperation mo = (MutatorOperation)op;
            rv.add(this.mutate(mo.getType(), this.first(op.getKeys()), mo.getBy(), mo.getDefault(), mo.getExpiration(), op.getCallback()));
        } else if (op instanceof StoreOperation) {
            StoreOperation so = (StoreOperation)op;
            rv.add(this.store(so.getStoreType(), this.first(op.getKeys()), so.getFlags(), so.getExpiration(), so.getData(), op.getCallback()));
        } else if (op instanceof ConcatenationOperation) {
            ConcatenationOperation c = (ConcatenationOperation)op;
            rv.add(this.cat(c.getStoreType(), c.getCasValue(), this.first(op.getKeys()), c.getData(), c.getCallback()));
        } else if (op instanceof SetAttrOperation) {
            SetAttrOperation c = (SetAttrOperation)op;
            rv.add(this.setAttr(this.first(c.getKeys()), c.getAttributes(), c.getCallback()));
        } else if (op instanceof GetAttrOperation) {
            GetAttrOperation c = (GetAttrOperation)op;
            rv.add(this.getAttr(this.first(c.getKeys()), (GetAttrOperation.Callback)c.getCallback()));
        } else if (op instanceof CollectionInsertOperation) {
            CollectionInsertOperation c = (CollectionInsertOperation)op;
            rv.add(this.collectionInsert(this.first(c.getKeys()), c.getSubKey(), c.getInsert(), c.getData(), c.getCallback()));
        } else if (op instanceof CollectionGetOperation) {
            CollectionGetOperation c = (CollectionGetOperation)op;
            rv.add(this.collectionGet(this.first(c.getKeys()), c.getGet(), (CollectionGetOperation.Callback)c.getCallback()));
        } else if (op instanceof CollectionDeleteOperation) {
            CollectionDeleteOperation c = (CollectionDeleteOperation)op;
            rv.add(this.collectionDelete(this.first(c.getKeys()), c.getDelete(), c.getCallback()));
        } else if (op instanceof CollectionExistOperation) {
            CollectionExistOperation c = (CollectionExistOperation)op;
            rv.add(this.collectionExist(this.first(c.getKeys()), c.getSubKey(), c.getExist(), c.getCallback()));
        } else assert (false) : "Unhandled operation type: " + op.getClass();
        return rv;
    }

    protected abstract Collection<? extends Operation> cloneGet(KeyedOperation var1);
}

