/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.ops;

import net.spy.memcached.compat.log.Logger;
import net.spy.memcached.compat.log.LoggerFactory;

public enum StatusCode {
    SUCCESS,
    ERR_NOT_FOUND,
    ERR_EXISTS,
    ERR_2BIG,
    ERR_INVAL,
    ERR_NOT_STORED,
    ERR_DELTA_BADVAL,
    ERR_TYPE_MISMATCH,
    ERR_UNKNOWN_COMMAND,
    ERR_NO_MEM,
    ERR_NOT_SUPPORTED,
    ERR_ERROR,
    ERR_SERVER,
    ERR_CLIENT,
    CANCELLED,
    INTERRUPTED,
    TIMEDOUT,
    UNDEFINED;

    private static final Logger logger;

    public static StatusCode fromAsciiLine(String line) {
        if (line.equals("OK") || line.equals("END") || line.equals("STORED") || line.equals("DELETED")) {
            return SUCCESS;
        }
        if (line.equals("NOT_STORED")) {
            return ERR_NOT_STORED;
        }
        if (line.equals("EXISTS")) {
            return ERR_EXISTS;
        }
        if (line.equals("NOT_FOUND")) {
            return ERR_NOT_FOUND;
        }
        if (line.equals("TYPE_MISMATCH")) {
            return ERR_TYPE_MISMATCH;
        }
        if (line.equals("ERROR")) {
            return ERR_ERROR;
        }
        if (line.equals("SERVER_ERROR")) {
            return ERR_SERVER;
        }
        if (line.equals("CLIENT_ERROR")) {
            return ERR_CLIENT;
        }
        logger.warn("Undefined response message: %s", line);
        return UNDEFINED;
    }

    static {
        logger = LoggerFactory.getLogger(StatusCode.class);
    }
}

