/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.plugin;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.Future;
import net.sf.ehcache.Element;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.plugin.FrontCacheGetFuture;
import net.spy.memcached.plugin.LocalCacheManager;
import net.spy.memcached.transcoders.Transcoder;

public class FrontCacheMemcachedClient
extends MemcachedClient {
    public FrontCacheMemcachedClient(ConnectionFactory cf, String name, List<InetSocketAddress> addrs) throws IOException {
        super(cf, name, addrs);
        if (cf.getMaxFrontCacheElements() > 0) {
            String cacheName = cf.getFrontCacheName();
            int maxElements = cf.getMaxFrontCacheElements();
            int timeToLiveSeconds = cf.getFrontCacheExpireTime();
            boolean copyOnRead = cf.getFrontCacheCopyOnRead();
            boolean copyOnWrite = cf.getFrontCacheCopyOnWrite();
            this.localCacheManager = new LocalCacheManager(cacheName, maxElements, timeToLiveSeconds, copyOnRead, copyOnWrite);
        }
    }

    @Override
    public <T> Future<T> asyncGet(String key, Transcoder<T> tc) {
        Element frontElement = null;
        if (this.localCacheManager != null) {
            frontElement = this.localCacheManager.getElement(key);
        }
        if (frontElement == null) {
            return super.asyncGet(key, tc);
        }
        return new FrontCacheGetFuture(frontElement);
    }

    @Override
    public Future<Boolean> delete(String key) {
        if (this.localCacheManager != null) {
            this.localCacheManager.delete(key);
        }
        return super.delete(key);
    }
}

