/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.plugin;

import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PersistenceConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.spy.memcached.compat.log.Logger;
import net.spy.memcached.compat.log.LoggerFactory;
import net.spy.memcached.transcoders.Transcoder;

public class LocalCacheManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Cache cache;
    protected String name;

    public LocalCacheManager() {
        this("DEFAULT_ARCUS_LOCAL_CACHE");
    }

    public LocalCacheManager(String name) {
        this.name = name;
        this.cache = CacheManager.getInstance().getCache(name);
    }

    public LocalCacheManager(String name, int max, int exptime, boolean copyOnRead, boolean copyOnWrite) {
        this.cache = CacheManager.getInstance().getCache(name);
        if (this.cache == null) {
            CacheConfiguration config = new CacheConfiguration(name, max).copyOnRead(copyOnRead).copyOnWrite(copyOnWrite).memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy.LRU).eternal(false).timeToLiveSeconds((long)exptime).timeToIdleSeconds((long)exptime).diskExpiryThreadIntervalSeconds(60L).persistence(new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.NONE));
            this.cache = new Cache(config, null, null);
            CacheManager.getInstance().addCache(this.cache);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Arcus k/v local cache is enabled : %s", this.cache.toString());
            }
        }
    }

    public <T> T get(String key, Transcoder<T> tc) {
        if (this.cache == null) {
            return null;
        }
        try {
            Element element = this.cache.get((Serializable)((Object)key));
            if (null != element) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ArcusFrontCache: local cache hit for %s", key);
                }
                Object ret = element.getObjectValue();
                return (T)ret;
            }
        }
        catch (Exception e) {
            this.logger.info("failed to get from the local cache : %s", e.getMessage());
            return null;
        }
        return null;
    }

    public <T> Future<T> asyncGet(final String key, final Transcoder<T> tc) {
        Task task = new Task(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return LocalCacheManager.this.get(key, tc);
            }
        });
        return task;
    }

    public Element getElement(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        if (this.logger.isDebugEnabled() && null != element) {
            this.logger.debug("ArcusFrontCache: local cache hit for %s", key);
        }
        return element;
    }

    public <T> boolean put(String k, T v) {
        if (v == null) {
            return false;
        }
        try {
            this.cache.put(new Element((Object)k, v));
            return true;
        }
        catch (Exception e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("failed to put to the local cache : %s", e.getMessage());
            }
            return false;
        }
    }

    public <T> boolean put(String k, Future<T> future, long timeout) {
        if (future == null) {
            return false;
        }
        try {
            T v = future.get(timeout, TimeUnit.MILLISECONDS);
            return this.put(k, v);
        }
        catch (Exception e) {
            this.logger.info("failed to put to the local cache : %s", e.getMessage());
            return false;
        }
    }

    public void delete(String k) {
        try {
            this.cache.remove((Serializable)((Object)k));
        }
        catch (Exception e) {
            this.logger.info("failed to remove the locally cached item : %s", e.getMessage());
        }
    }

    public String toString() {
        return this.cache.toString();
    }

    public static class Task<T>
    extends FutureTask<T> {
        private final AtomicBoolean isRunning = new AtomicBoolean(false);

        public Task(Callable<T> callable) {
            super(callable);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            this.run();
            return (T)super.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.run();
            return (T)super.get(timeout, unit);
        }

        @Override
        public void run() {
            if (this.isRunning.compareAndSet(false, true)) {
                super.run();
            }
        }
    }
}

