/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.BTreeFindPositionWithGet;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.BTreeFindPositionWithGetOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;

public class BTreeFindPositionWithGetOperationImpl
extends OperationImpl
implements BTreeFindPositionWithGetOperation {
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private static final OperationStatus GET_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus END = new CollectionOperationStatus(true, "END", CollectionResponse.END);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    protected final String key;
    protected final BTreeFindPositionWithGet get;
    protected int position = 0;
    protected int flags = 0;
    protected int count = 0;
    protected int index = 0;
    protected int pos = 0;
    protected int posDiff = 0;
    protected byte[] data = null;
    protected int readOffset = 0;
    protected byte lookingFor = 0;
    protected int spaceCount = 0;
    private Boolean hasEFlag = null;

    public BTreeFindPositionWithGetOperationImpl(String key, BTreeFindPositionWithGet get, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.get = get;
        this.setAPIType(APIType.BOP_PWG);
        this.setOperationType(OperationType.READ);
    }

    @Override
    public BTreeFindPositionWithGet getGet() {
        return this.get;
    }

    @Override
    public void handleLine(String line) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Got line %s", line);
        }
        if (line.startsWith("VALUE ")) {
            String[] stuff = line.split(" ");
            assert (stuff.length == 5);
            this.position = Integer.parseInt(stuff[1]);
            this.flags = Integer.parseInt(stuff[2]);
            this.count = Integer.parseInt(stuff[3]);
            this.index = Integer.parseInt(stuff[4]);
            assert (this.count > 0);
            this.pos = this.position - this.index;
            this.posDiff = 1;
            this.setReadType(OperationReadType.DATA);
        } else {
            OperationStatus status = this.matchStatus(line, END, NOT_FOUND, NOT_FOUND_ELEMENT, UNREADABLE, TYPE_MISMATCH, BKEY_MISMATCH);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(status);
            }
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handleRead(ByteBuffer bb) {
        block22: {
            if (this.lookingFor != 0 || this.data != null) break block22;
            i = 0;
            while (bb.remaining() > 0) {
                block25: {
                    block24: {
                        block23: {
                            b = bb.get();
                            if (b != 32) break block23;
                            if (this.hasEFlag == null && this.spaceCount == 1) {
                                chunk = new String(this.byteBuffer.toByteArray()).split(" ");
                                this.hasEFlag = chunk[1].startsWith("0x") != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
                            }
                            ++this.spaceCount;
                            v0 = spaceReduced = this.hasEFlag != null && this.hasEFlag != false ? 1 : 0;
                            if (this.get.headerReady(this.spaceCount - spaceReduced)) {
                                this.get.decodeItemHeader(new String(this.byteBuffer.toByteArray()));
                                this.data = new byte[this.get.getDataLength()];
                                this.byteBuffer.reset();
                                this.spaceCount = 0;
                                this.hasEFlag = null;
                                break;
                            }
                            break block24;
                        }
                        if (b != 13) {
                            if (b == 10) {
                                status = this.matchStatus(this.byteBuffer.toString(), new OperationStatus[]{BTreeFindPositionWithGetOperationImpl.END, BTreeFindPositionWithGetOperationImpl.NOT_FOUND, BTreeFindPositionWithGetOperationImpl.NOT_FOUND_ELEMENT, BTreeFindPositionWithGetOperationImpl.UNREADABLE, BTreeFindPositionWithGetOperationImpl.TYPE_MISMATCH, BTreeFindPositionWithGetOperationImpl.BKEY_MISMATCH});
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("Get complete!");
                                }
                                this.getCallback().receivedStatus(status);
                                this.transitionState(OperationState.COMPLETE);
                                this.data = null;
                                break;
                            } else {
                                ** GOTO lbl30
                            }
                        }
                        break block25;
                    }
                    this.byteBuffer.write(b);
                }
                ++i;
            }
            return;
        }
        if (!BTreeFindPositionWithGetOperationImpl.$assertionsDisabled && this.key == null) {
            throw new AssertionError();
        }
        if (!BTreeFindPositionWithGetOperationImpl.$assertionsDisabled && this.data == null) {
            throw new AssertionError();
        }
        if (!BTreeFindPositionWithGetOperationImpl.$assertionsDisabled && this.readOffset > this.data.length) {
            throw new AssertionError((Object)("readOffset is " + this.readOffset + " data.length is " + this.data.length));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("readOffset: %d, length: %d", new Object[]{this.readOffset, this.data.length});
        }
        if (this.lookingFor == 0) {
            toRead = this.data.length - this.readOffset;
            available = bb.remaining();
            toRead = Math.min(toRead, available);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Reading %d bytes", new Object[]{toRead});
            }
            bb.get(this.data, this.readOffset, toRead);
            this.readOffset += toRead;
        }
        if (this.lookingFor == 0 && this.readOffset == this.data.length) {
            cb = (BTreeFindPositionWithGetOperation.Callback)this.getCallback();
            cb.gotData(this.key, this.flags, this.pos, this.get.getBkey(), this.get.getEflag(), this.data);
            this.pos += this.posDiff;
            this.lookingFor = (byte)13;
        }
        if (this.lookingFor != 0 && bb.hasRemaining()) {
            do {
                tmp = bb.get();
                if (!BTreeFindPositionWithGetOperationImpl.$assertionsDisabled && tmp != this.lookingFor) {
                    throw new AssertionError((Object)("Expecting " + this.lookingFor + ", got " + (char)tmp));
                }
                switch (this.lookingFor) {
                    case 13: {
                        this.lookingFor = (byte)10;
                        break;
                    }
                    case 10: {
                        this.lookingFor = 0;
                        break;
                    }
                    default: {
                        if (!BTreeFindPositionWithGetOperationImpl.$assertionsDisabled) {
                            throw new AssertionError((Object)("Looking for unexpected char: " + (char)this.lookingFor));
                        } else {
                            break;
                        }
                    }
                }
            } while (this.lookingFor != 0 && bb.hasRemaining());
            if (this.lookingFor == 0) {
                this.data = null;
                this.readOffset = 0;
            }
        }
    }

    @Override
    public void initialize() {
        String cmd = this.get.getCommand();
        String args = this.get.stringify();
        ByteBuffer bb = ByteBuffer.allocate(KeyUtil.getKeyBytes(this.key).length + cmd.length() + args.length() + 16);
        this.setArguments(bb, cmd, this.key, args);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(GET_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

