/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.BTreeGetBulk;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.BTreeGetBulkOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;

public class BTreeGetBulkOperationImpl
extends OperationImpl
implements BTreeGetBulkOperation {
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private static final OperationStatus GET_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus END = new CollectionOperationStatus(true, "END", CollectionResponse.END);
    private static final OperationStatus OK = new CollectionOperationStatus(true, "OK", CollectionResponse.OK);
    private static final OperationStatus TRIMMED = new CollectionOperationStatus(true, "TRIMMED", CollectionResponse.TRIMMED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    private static final OperationStatus OUT_OF_RANGE = new CollectionOperationStatus(false, "OUT_OF_RANGE", CollectionResponse.OUT_OF_RANGE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    protected final BTreeGetBulk<?> getBulk;
    protected int flags = 0;
    protected byte[] data = null;
    protected int readOffset = 0;
    protected byte lookingFor = 0;
    protected int spaceCount = 0;
    protected int elementCount = 0;

    public BTreeGetBulkOperationImpl(BTreeGetBulk<?> getBulk, OperationCallback cb) {
        super(cb);
        this.getBulk = getBulk;
        this.setAPIType(APIType.BOP_GET);
        this.setOperationType(OperationType.READ);
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Got line %s", line);
        if (line.startsWith("VALUE ")) {
            this.readKey(line);
            if (this.elementCount > 0) {
                this.setReadType(OperationReadType.DATA);
            }
        } else {
            OperationStatus status = this.matchStatus(line, END);
            this.getLogger().debug(status);
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
        }
    }

    @Override
    public final void handleRead(ByteBuffer bb) {
        this.readValue(bb);
        if (this.elementCount == 0) {
            this.setReadType(OperationReadType.LINE);
        }
    }

    private final void readKey(String line) {
        String[] chunk = line.split(" ");
        OperationStatus status = this.matchStatus(chunk[2], OK, TRIMMED, NOT_FOUND, NOT_FOUND_ELEMENT, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH, UNREADABLE);
        this.getBulk.decodeKeyHeader(line);
        this.elementCount = chunk.length > 3 ? Integer.parseInt(chunk[4]) : 0;
        BTreeGetBulkOperation.Callback cb = (BTreeGetBulkOperation.Callback)this.getCallback();
        cb.gotKey(chunk[1], this.elementCount, status);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void readValue(ByteBuffer bb) {
        if (this.lookingFor != 0 || this.data != null) {
            assert (this.data != null);
            assert (this.readOffset <= this.data.length) : "readOffset is " + this.readOffset + " data.length is " + this.data.length;
            this.getLogger().debug("readOffset: %d, length: %d", this.readOffset, this.data.length);
            if (this.lookingFor == 0) {
                int toRead = this.data.length - this.readOffset;
                int available = bb.remaining();
                toRead = Math.min(toRead, available);
                this.getLogger().debug("Reading %d bytes", toRead);
                bb.get(this.data, this.readOffset, toRead);
                this.readOffset += toRead;
            }
            if (this.lookingFor == 0 && this.readOffset == this.data.length) {
                BTreeGetBulkOperation.Callback cb = (BTreeGetBulkOperation.Callback)this.getCallback();
                cb.gotElement(this.getBulk.getKey(), this.getBulk.getSubkey(), this.getBulk.getFlag(), this.getBulk.getEFlag(), this.data);
                this.lookingFor = (byte)13;
            }
        } else {
            int i = 0;
            while (bb.remaining() > 0) {
                block18: {
                    byte b = bb.get();
                    if (b == 32) {
                        ++this.spaceCount;
                        String l = new String(this.byteBuffer.toByteArray());
                        if (l.startsWith("ELEMENT") && this.getBulk.elementHeaderReady(this.spaceCount)) {
                            if (this.spaceCount == 3 && l.split(" ")[2].startsWith("0x")) {
                                this.byteBuffer.write(b);
                                break block18;
                            } else {
                                this.getBulk.decodeItemHeader(l);
                                this.data = new byte[this.getBulk.getDataLength()];
                                this.byteBuffer.reset();
                                this.spaceCount = 0;
                                return;
                            }
                        }
                    }
                    this.byteBuffer.write(b);
                }
                ++i;
            }
            return;
        }
        if (this.lookingFor == 0) return;
        if (!bb.hasRemaining()) return;
        do {
            byte tmp = bb.get();
            assert (tmp == this.lookingFor) : "Expecting " + this.lookingFor + ", got " + (char)tmp;
            switch (this.lookingFor) {
                case 13: {
                    this.lookingFor = (byte)10;
                    break;
                }
                case 10: {
                    this.lookingFor = 0;
                    break;
                }
                default: {
                    assert (false) : "Looking for unexpected char: " + (char)this.lookingFor;
                    {
                        break;
                    }
                }
            }
        } while (this.lookingFor != 0 && bb.hasRemaining());
        if (this.lookingFor != 0) return;
        this.data = null;
        this.readOffset = 0;
        --this.elementCount;
    }

    @Override
    public void initialize() {
        String cmd = this.getBulk.getCommand();
        if (this.getHandlingNode() == null || this.getHandlingNode().enabledSpaceSeparate()) {
            this.getBulk.setKeySeparator(" ");
        } else {
            this.getBulk.setKeySeparator(",");
        }
        String args = this.getBulk.stringify();
        ByteBuffer bb = ByteBuffer.allocate(cmd.length() + args.length() + KeyUtil.getKeyBytes(this.getBulk.getSpaceSeparatedKeys()).length + 16);
        this.setArguments(bb, cmd, args);
        this.setArguments(bb, this.getBulk.getSpaceSeparatedKeys());
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(GET_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return this.getBulk.getKeyList();
    }
}

