/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.BTreeGetByPosition;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.BTreeGetByPositionOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;

public class BTreeGetByPositionOperationImpl
extends OperationImpl
implements BTreeGetByPositionOperation {
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private static final OperationStatus GET_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus END = new CollectionOperationStatus(true, "END", CollectionResponse.END);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus NOT_FOUND_ELEMENT = new CollectionOperationStatus(false, "NOT_FOUND_ELEMENT", CollectionResponse.NOT_FOUND_ELEMENT);
    protected final String key;
    protected final BTreeGetByPosition get;
    protected int flags = 0;
    protected int count = 0;
    protected int pos = 0;
    protected int posDiff = 0;
    protected byte[] data = null;
    protected int readOffset = 0;
    protected byte lookingFor = 0;
    protected int spaceCount = 0;
    private Boolean hasEFlag = null;

    public BTreeGetByPositionOperationImpl(String key, BTreeGetByPosition get, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.get = get;
        this.setAPIType(APIType.BOP_GBP);
        this.setOperationType(OperationType.READ);
    }

    @Override
    public BTreeGetByPosition getGet() {
        return this.get;
    }

    @Override
    public void handleLine(String line) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Got line %s", line);
        }
        if (line.startsWith("VALUE ")) {
            String[] stuff = line.split(" ");
            assert (stuff.length == 3);
            assert ("VALUE".equals(stuff[0]));
            this.flags = Integer.parseInt(stuff[1]);
            this.count = Integer.parseInt(stuff[2]);
            if (this.count > 0) {
                this.pos = this.get.isReversed() ? this.get.getPosTo() + this.count - 1 : this.get.getPosFrom();
                this.posDiff = this.get.isReversed() ? -1 : 1;
                this.setReadType(OperationReadType.DATA);
            }
        } else {
            OperationStatus status = this.matchStatus(line, END, NOT_FOUND, UNREADABLE, TYPE_MISMATCH, NOT_FOUND_ELEMENT);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(status);
            }
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
            return;
        }
    }

    @Override
    public void handleRead(ByteBuffer bb) {
        if (this.lookingFor == 0 && this.data == null) {
            int i = 0;
            while (bb.remaining() > 0) {
                byte b = bb.get();
                if (b == 32) {
                    int spaceReduced;
                    if (this.hasEFlag == null && this.spaceCount == 1) {
                        String[] chunk = new String(this.byteBuffer.toByteArray()).split(" ");
                        this.hasEFlag = chunk[1].startsWith("0x") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    ++this.spaceCount;
                    int n = spaceReduced = this.hasEFlag != null && this.hasEFlag != false ? 1 : 0;
                    if (this.get.headerReady(this.spaceCount - spaceReduced)) {
                        this.get.decodeItemHeader(new String(this.byteBuffer.toByteArray()));
                        this.data = new byte[this.get.getDataLength()];
                        this.byteBuffer.reset();
                        this.spaceCount = 0;
                        this.hasEFlag = null;
                        break;
                    }
                }
                if (b != 13) {
                    if (b == 10) {
                        OperationStatus status = this.matchStatus(this.byteBuffer.toString(), END, NOT_FOUND, UNREADABLE, TYPE_MISMATCH, NOT_FOUND_ELEMENT);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Get complete!");
                        }
                        this.getCallback().receivedStatus(status);
                        this.transitionState(OperationState.COMPLETE);
                        this.data = null;
                        break;
                    }
                    this.byteBuffer.write(b);
                }
                ++i;
            }
            return;
        }
        assert (this.key != null);
        assert (this.data != null);
        assert (this.readOffset <= this.data.length) : "readOffset is " + this.readOffset + " data.length is " + this.data.length;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("readOffset: %d, length: %d", this.readOffset, this.data.length);
        }
        if (this.lookingFor == 0) {
            int toRead = this.data.length - this.readOffset;
            int available = bb.remaining();
            toRead = Math.min(toRead, available);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Reading %d bytes", toRead);
            }
            bb.get(this.data, this.readOffset, toRead);
            this.readOffset += toRead;
        }
        if (this.lookingFor == 0 && this.readOffset == this.data.length) {
            BTreeGetByPositionOperation.Callback cb = (BTreeGetByPositionOperation.Callback)this.getCallback();
            cb.gotData(this.key, this.flags, this.pos, this.get.getBkey(), this.get.getEflag(), this.data);
            this.pos += this.posDiff;
            this.lookingFor = (byte)13;
        }
        if (this.lookingFor != 0 && bb.hasRemaining()) {
            do {
                byte tmp = bb.get();
                assert (tmp == this.lookingFor) : "Expecting " + this.lookingFor + ", got " + (char)tmp;
                switch (this.lookingFor) {
                    case 13: {
                        this.lookingFor = (byte)10;
                        break;
                    }
                    case 10: {
                        this.lookingFor = 0;
                        break;
                    }
                    default: {
                        assert (false) : "Looking for unexpected char: " + (char)this.lookingFor;
                        {
                            break;
                        }
                    }
                }
            } while (this.lookingFor != 0 && bb.hasRemaining());
            if (this.lookingFor == 0) {
                this.data = null;
                this.readOffset = 0;
            }
        }
    }

    @Override
    public void initialize() {
        String cmd = this.get.getCommand();
        String args = this.get.stringify();
        ByteBuffer bb = ByteBuffer.allocate(cmd.length() + KeyUtil.getKeyBytes(this.key).length + args.length() + 16);
        this.setArguments(bb, cmd, this.key, args);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(GET_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

