/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.BTreeInsertAndGet;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.BTreeInsertAndGetOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;

public class BTreeInsertAndGetOperationImpl
extends OperationImpl
implements BTreeInsertAndGetOperation {
    private static final int OVERHEAD = 32;
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private static final OperationStatus GET_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus CREATED_STORED = new CollectionOperationStatus(true, "CREATED_STORED", CollectionResponse.CREATED_STORED);
    private static final OperationStatus STORED = new CollectionOperationStatus(true, "STORED", CollectionResponse.STORED);
    private static final OperationStatus REPLACED = new CollectionOperationStatus(true, "REPLACED", CollectionResponse.REPLACED);
    private static final OperationStatus TRIMMED = new CollectionOperationStatus(true, "TRIMMED", CollectionResponse.TRIMMED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus ELEMENT_EXISTS = new CollectionOperationStatus(false, "ELEMENT_EXISTS", CollectionResponse.ELEMENT_EXISTS);
    private static final OperationStatus OVERFLOWED = new CollectionOperationStatus(false, "OVERFLOWED", CollectionResponse.OVERFLOWED);
    private static final OperationStatus OUT_OF_RANGE = new CollectionOperationStatus(false, "OUT_OF_RANGE", CollectionResponse.OUT_OF_RANGE);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    private static final OperationStatus UNDEFINED_OPERATION = new CollectionOperationStatus(false, "UNDEFINED_OPERATION", CollectionResponse.UNDEFINED);
    private static final OperationStatus[] INSERT_AND_GET_STATUS_ON_LINE = new OperationStatus[]{STORED, CREATED_STORED, NOT_FOUND, ELEMENT_EXISTS, OVERFLOWED, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH};
    private static final OperationStatus[] UPSERT_AND_GET_STATUS_ON_LINE = new OperationStatus[]{STORED, CREATED_STORED, REPLACED, NOT_FOUND, OVERFLOWED, OUT_OF_RANGE, TYPE_MISMATCH, BKEY_MISMATCH};
    private static final OperationStatus[] STORE_AND_GET_ON_DATA = new OperationStatus[]{TRIMMED};
    protected final String key;
    protected final BTreeInsertAndGet<?> get;
    protected final byte[] dataToStore;
    protected int flags = 0;
    protected int count = 0;
    protected byte[] data = null;
    protected int readOffset = 0;
    protected byte lookingFor = 0;
    protected int spaceCount = 0;
    private Boolean hasEFlag = null;

    public BTreeInsertAndGetOperationImpl(String key, BTreeInsertAndGet<?> get, byte[] dataToStore, OperationCallback cb) {
        super(cb);
        this.key = key;
        this.get = get;
        this.dataToStore = dataToStore;
        if (get.getCmd() == BTreeInsertAndGet.Command.INSERT) {
            this.setAPIType(APIType.BOP_INSERT);
        } else if (get.getCmd() == BTreeInsertAndGet.Command.UPSERT) {
            this.setAPIType(APIType.BOP_UPSERT);
        }
        this.setOperationType(OperationType.WRITE);
    }

    @Override
    public BTreeInsertAndGet<?> getGet() {
        return this.get;
    }

    @Override
    public void handleLine(String line) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Got line %s", line);
        }
        if (line.equals("SWITCHOVER") || line.equals("REPL_SLAVE")) {
            this.receivedMoveOperations(line);
            return;
        }
        if (line.startsWith("VALUE ")) {
            String[] stuff = line.split(" ");
            assert (stuff.length == 3);
            assert ("VALUE".equals(stuff[0]));
            this.flags = Integer.parseInt(stuff[1]);
            this.count = Integer.parseInt(stuff[2]);
            if (this.count > 0) {
                this.setReadType(OperationReadType.DATA);
            }
        } else {
            OperationStatus status = null;
            switch (this.get.getCmd()) {
                case INSERT: {
                    status = this.matchStatus(line, INSERT_AND_GET_STATUS_ON_LINE);
                    break;
                }
                case UPSERT: {
                    status = this.matchStatus(line, UPSERT_AND_GET_STATUS_ON_LINE);
                    break;
                }
                default: {
                    status = UNDEFINED_OPERATION;
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(status);
            }
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
            return;
        }
    }

    @Override
    public void handleRead(ByteBuffer bb) {
        if (this.lookingFor == 0 && this.data == null) {
            int i = 0;
            while (bb.remaining() > 0) {
                byte b = bb.get();
                if (b == 32) {
                    int spaceReduced;
                    if (this.hasEFlag == null && this.spaceCount == 2) {
                        String[] chunk = new String(this.byteBuffer.toByteArray()).split(" ");
                        this.hasEFlag = chunk[1].startsWith("0x") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    ++this.spaceCount;
                    int n = spaceReduced = this.hasEFlag != null && this.hasEFlag != false ? 1 : 0;
                    if (this.get.headerReady(this.spaceCount - spaceReduced)) {
                        this.get.decodeItemHeader(new String(this.byteBuffer.toByteArray()));
                        this.data = new byte[this.get.getBytes()];
                        this.byteBuffer.reset();
                        this.spaceCount = 0;
                        this.hasEFlag = null;
                        break;
                    }
                }
                if (b != 13) {
                    if (b == 10) {
                        OperationStatus status = this.matchStatus(this.byteBuffer.toString(), STORE_AND_GET_ON_DATA);
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Get complete!");
                        }
                        this.getCallback().receivedStatus(status);
                        this.transitionState(OperationState.COMPLETE);
                        this.data = null;
                        break;
                    }
                    this.byteBuffer.write(b);
                }
                ++i;
            }
            return;
        }
        assert (this.key != null);
        assert (this.data != null);
        assert (this.readOffset <= this.data.length) : "readOffset is " + this.readOffset + " data.length is " + this.data.length;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("readOffset: %d, length: %d", this.readOffset, this.data.length);
        }
        if (this.lookingFor == 0) {
            int toRead = this.data.length - this.readOffset;
            int available = bb.remaining();
            toRead = Math.min(toRead, available);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Reading %d bytes", toRead);
            }
            bb.get(this.data, this.readOffset, toRead);
            this.readOffset += toRead;
        }
        if (this.lookingFor == 0 && this.readOffset == this.data.length) {
            BTreeInsertAndGetOperation.Callback cb = (BTreeInsertAndGetOperation.Callback)this.getCallback();
            cb.gotData(this.key, this.flags, this.get.getBkeyObject(), this.get.getElementFlag(), this.data);
            this.lookingFor = (byte)13;
        }
        if (this.lookingFor != 0 && bb.hasRemaining()) {
            do {
                byte tmp = bb.get();
                assert (tmp == this.lookingFor) : "Expecting " + this.lookingFor + ", got " + (char)tmp;
                switch (this.lookingFor) {
                    case 13: {
                        this.lookingFor = (byte)10;
                        break;
                    }
                    case 10: {
                        this.lookingFor = 0;
                        break;
                    }
                    default: {
                        assert (false) : "Looking for unexpected char: " + (char)this.lookingFor;
                        {
                            break;
                        }
                    }
                }
            } while (this.lookingFor != 0 && bb.hasRemaining());
            if (this.lookingFor == 0) {
                this.data = null;
                this.readOffset = 0;
            }
        }
    }

    @Override
    public void initialize() {
        String args = this.get.stringify();
        ByteBuffer bb = ByteBuffer.allocate(this.dataToStore.length + KeyUtil.getKeyBytes(this.key).length + KeyUtil.getKeyBytes(this.get.getBkeyObject().getBKeyAsString()).length + KeyUtil.getKeyBytes(this.get.getElementFlagByHex()).length + args.length() + 32);
        this.setArguments(bb, this.get.getCommand(), this.key, this.get.getBkeyObject().getBKeyAsString(), this.get.getElementFlagByHex(), this.dataToStore.length, args);
        bb.put(this.dataToStore);
        bb.put(CRLF);
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(GET_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return Collections.singleton(this.key);
    }
}

