/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.collection.BTreeSMGet;
import net.spy.memcached.collection.BTreeSMGetWithByteTypeBkey;
import net.spy.memcached.collection.BTreeSMGetWithLongTypeBkey;
import net.spy.memcached.collection.CollectionResponse;
import net.spy.memcached.ops.APIType;
import net.spy.memcached.ops.BTreeSortMergeGetOperation;
import net.spy.memcached.ops.CollectionOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.protocol.ascii.OperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;
import net.spy.memcached.util.BTreeUtil;

public class BTreeSortMergeGetOperationImpl
extends OperationImpl
implements BTreeSortMergeGetOperation {
    private final ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
    private static final OperationStatus GET_CANCELED = new CollectionOperationStatus(false, "collection canceled", CollectionResponse.CANCELED);
    private static final OperationStatus END = new CollectionOperationStatus(true, "END", CollectionResponse.END);
    private static final OperationStatus DUPLICATED = new CollectionOperationStatus(true, "DUPLICATED", CollectionResponse.DUPLICATED);
    private static final OperationStatus TRIMMED = new CollectionOperationStatus(true, "TRIMMED", CollectionResponse.TRIMMED);
    private static final OperationStatus DUPLICATED_TRIMMED = new CollectionOperationStatus(true, "DUPLICATED_TRIMMED", CollectionResponse.DUPLICATED_TRIMMED);
    private static final OperationStatus NOT_FOUND = new CollectionOperationStatus(false, "NOT_FOUND", CollectionResponse.NOT_FOUND);
    private static final OperationStatus UNREADABLE = new CollectionOperationStatus(false, "UNREADABLE", CollectionResponse.UNREADABLE);
    private static final OperationStatus OUT_OF_RANGE = new CollectionOperationStatus(false, "OUT_OF_RANGE", CollectionResponse.OUT_OF_RANGE);
    private static final OperationStatus ATTR_MISMATCH = new CollectionOperationStatus(false, "ATTR_MISMATCH", CollectionResponse.ATTR_MISMATCH);
    private static final OperationStatus TYPE_MISMATCH = new CollectionOperationStatus(false, "TYPE_MISMATCH", CollectionResponse.TYPE_MISMATCH);
    private static final OperationStatus BKEY_MISMATCH = new CollectionOperationStatus(false, "BKEY_MISMATCH", CollectionResponse.BKEY_MISMATCH);
    protected final BTreeSMGet<?> smGet;
    protected int flags = 0;
    protected int lineCount = 0;
    protected byte[] data = null;
    protected int readOffset = 0;
    protected byte lookingFor = 0;
    protected int spaceCount = 0;
    protected ReadState readState = ReadState.VALUE;
    private int processedValueCount = 0;

    public BTreeSortMergeGetOperationImpl(BTreeSMGet<?> smGet, OperationCallback cb) {
        super(cb);
        this.smGet = smGet;
        this.setAPIType(APIType.BOP_SMGET);
        this.setOperationType(OperationType.READ);
    }

    @Override
    public void handleLine(String line) {
        this.getLogger().debug("Got line %s", line);
        if (line.startsWith("VALUE ") || line.startsWith("ELEMENTS ")) {
            this.readState = ReadState.VALUE;
            String[] stuff = line.split(" ");
            assert ("VALUE".equals(stuff[0]) || "ELEMENTS".equals(stuff[0]));
            this.lineCount = Integer.parseInt(stuff[1]);
            if (this.lineCount > 0) {
                this.setReadType(OperationReadType.DATA);
            }
        } else if (line.startsWith("MISSED_KEYS")) {
            this.readState = ReadState.MISSED_KEYS;
            String[] stuff = line.split(" ");
            assert ("MISSED_KEYS".equals(stuff[0]));
            this.lineCount = Integer.parseInt(stuff[1]);
            if (this.lineCount > 0) {
                this.setReadType(OperationReadType.DATA);
            }
        } else if (line.startsWith("TRIMMED_KEYS")) {
            this.readState = ReadState.TRIMMED_KEYS;
            String[] stuff = line.split(" ");
            assert ("TRIMMED_KEYS".equals(stuff[0]));
            this.lineCount = Integer.parseInt(stuff[1]);
            if (this.lineCount > 0) {
                this.setReadType(OperationReadType.DATA);
            }
        } else {
            OperationStatus status = this.matchStatus(line, END, TRIMMED, DUPLICATED, DUPLICATED_TRIMMED, OUT_OF_RANGE, ATTR_MISMATCH, TYPE_MISMATCH, BKEY_MISMATCH);
            this.getLogger().debug(status);
            this.getCallback().receivedStatus(status);
            this.transitionState(OperationState.COMPLETE);
            return;
        }
    }

    @Override
    public final void handleRead(ByteBuffer bb) {
        switch (this.readState) {
            case VALUE: {
                this.readValue(bb);
                break;
            }
            case MISSED_KEYS: {
                this.readMissedKeys(bb);
                break;
            }
            case TRIMMED_KEYS: {
                this.readTrimmedKeys(bb);
            }
        }
    }

    private final void readValue(ByteBuffer bb) {
        int count = 0;
        if (this.lookingFor == 0 && this.data == null) {
            int i = 0;
            while (bb.remaining() > 0) {
                byte b = bb.get();
                if (b == 32) {
                    String[] chunk = new String(this.byteBuffer.toByteArray()).split(" ");
                    if (chunk.length == 4 && chunk[3].startsWith("0x")) {
                        --this.spaceCount;
                    }
                    ++this.spaceCount;
                    if (this.smGet.headerReady(this.spaceCount)) {
                        this.smGet.decodeItemHeader(new String(this.byteBuffer.toByteArray()));
                        this.data = new byte[this.smGet.getDataLength()];
                        this.byteBuffer.reset();
                        this.spaceCount = 0;
                        ++this.processedValueCount;
                        break;
                    }
                }
                if (b != 13) {
                    if (b == 10) {
                        String sep = new String(this.byteBuffer.toByteArray());
                        if (sep.startsWith("MISSED_KEYS")) {
                            this.readState = ReadState.MISSED_KEYS;
                            this.byteBuffer.reset();
                            this.spaceCount = 0;
                            String[] stuff = sep.split(" ");
                            this.lineCount = Integer.parseInt(stuff[1]);
                            return;
                        }
                        OperationStatus status = this.matchStatus(this.byteBuffer.toString(), END, TRIMMED, DUPLICATED, DUPLICATED_TRIMMED, OUT_OF_RANGE, ATTR_MISMATCH, TYPE_MISMATCH, BKEY_MISMATCH);
                        this.getCallback().receivedStatus(status);
                        this.data = null;
                        break;
                    }
                    this.byteBuffer.write(b);
                }
                ++i;
            }
            return;
        }
        assert (this.data != null);
        assert (this.readOffset <= this.data.length) : "readOffset is " + this.readOffset + " data.length is " + this.data.length;
        this.getLogger().debug("readOffset: %d, length: %d", this.readOffset, this.data.length);
        if (this.lookingFor == 0) {
            int toRead = this.data.length - this.readOffset;
            int available = bb.remaining();
            toRead = Math.min(toRead, available);
            this.getLogger().debug("Reading %d bytes", toRead);
            bb.get(this.data, this.readOffset, toRead);
            this.readOffset += toRead;
        }
        if (this.lookingFor == 0 && this.readOffset == this.data.length && count < this.lineCount) {
            BTreeSortMergeGetOperation.Callback cb = (BTreeSortMergeGetOperation.Callback)this.getCallback();
            cb.gotData(this.smGet.getKey(), this.smGet.getSubkey(), this.smGet.getFlag(), this.data);
            this.lookingFor = (byte)13;
        }
        if (this.lookingFor != 0 && bb.hasRemaining()) {
            do {
                byte tmp = bb.get();
                assert (tmp == this.lookingFor) : "Expecting " + this.lookingFor + ", got " + (char)tmp;
                switch (this.lookingFor) {
                    case 13: {
                        this.lookingFor = (byte)10;
                        break;
                    }
                    case 10: {
                        this.lookingFor = 0;
                        break;
                    }
                    default: {
                        assert (false) : "Looking for unexpected char: " + (char)this.lookingFor;
                        {
                            break;
                        }
                    }
                }
            } while (this.lookingFor != 0 && bb.hasRemaining());
            if (this.lookingFor == 0) {
                this.data = null;
                this.readOffset = 0;
            }
        }
    }

    private final void readMissedKeys(ByteBuffer bb) {
        int count = 0;
        if (this.lookingFor == 0 && this.data == null) {
            int i = 0;
            while (bb.remaining() > 0) {
                byte b = bb.get();
                if (b != 13) {
                    if (b == 10) {
                        String sep = new String(this.byteBuffer.toByteArray());
                        if (sep.startsWith("TRIMMED_KEYS")) {
                            this.readState = ReadState.TRIMMED_KEYS;
                            this.byteBuffer.reset();
                            this.spaceCount = 0;
                            String[] stuff = sep.split(" ");
                            this.lineCount = Integer.parseInt(stuff[1]);
                            return;
                        }
                        OperationStatus status = this.matchStatus(this.byteBuffer.toString(), END, TRIMMED, DUPLICATED, DUPLICATED_TRIMMED, OUT_OF_RANGE, ATTR_MISMATCH, TYPE_MISMATCH, BKEY_MISMATCH);
                        if (status.isSuccess()) {
                            this.getCallback().receivedStatus(status);
                            this.transitionState(OperationState.COMPLETE);
                            return;
                        }
                        if (count < this.lineCount) {
                            String[] chunk = new String(this.byteBuffer.toByteArray()).split(" ");
                            if (chunk.length == 2) {
                                ((BTreeSortMergeGetOperation.Callback)this.getCallback()).gotMissedKey(chunk[0], this.matchStatus(chunk[1], NOT_FOUND, UNREADABLE, OUT_OF_RANGE));
                            } else {
                                ((BTreeSortMergeGetOperation.Callback)this.getCallback()).gotMissedKey(chunk[0], new CollectionOperationStatus(false, "UNDEFINED", CollectionResponse.UNDEFINED));
                            }
                            ++count;
                        } else {
                            this.getCallback().receivedStatus(status);
                            this.transitionState(OperationState.COMPLETE);
                            return;
                        }
                        this.byteBuffer.reset();
                    } else {
                        this.byteBuffer.write(b);
                    }
                }
                ++i;
            }
            return;
        }
    }

    private final void readTrimmedKeys(ByteBuffer bb) {
        int count = 0;
        if (this.lookingFor == 0 && this.data == null) {
            int i = 0;
            while (bb.remaining() > 0) {
                byte b = bb.get();
                if (b != 13) {
                    if (b == 10) {
                        OperationStatus status = this.matchStatus(this.byteBuffer.toString(), END, DUPLICATED, OUT_OF_RANGE, ATTR_MISMATCH, TYPE_MISMATCH, BKEY_MISMATCH);
                        if (status.isSuccess()) {
                            this.getCallback().receivedStatus(status);
                            this.transitionState(OperationState.COMPLETE);
                            return;
                        }
                        if (count < this.lineCount) {
                            String[] chunk = new String(this.byteBuffer.toByteArray()).split(" ");
                            if (this.smGet instanceof BTreeSMGetWithLongTypeBkey) {
                                ((BTreeSortMergeGetOperation.Callback)this.getCallback()).gotTrimmedKey(chunk[0], Long.parseLong(chunk[1]));
                            } else if (this.smGet instanceof BTreeSMGetWithByteTypeBkey) {
                                ((BTreeSortMergeGetOperation.Callback)this.getCallback()).gotTrimmedKey(chunk[0], BTreeUtil.hexStringToByteArrays(chunk[1].substring(2)));
                            }
                            ++count;
                        } else {
                            this.getCallback().receivedStatus(status);
                            this.transitionState(OperationState.COMPLETE);
                            return;
                        }
                        this.byteBuffer.reset();
                    } else {
                        this.byteBuffer.write(b);
                    }
                }
                ++i;
            }
            return;
        }
    }

    @Override
    public void initialize() {
        String cmd = this.smGet.getCommand();
        if (this.getHandlingNode() == null || this.getHandlingNode().enabledSpaceSeparate()) {
            this.smGet.setKeySeparator(" ");
        } else {
            this.smGet.setKeySeparator(",");
        }
        String args = this.smGet.stringify();
        ByteBuffer bb = ByteBuffer.allocate(cmd.length() + args.length() + KeyUtil.getKeyBytes(this.smGet.getSpaceSeparatedKeys()).length + 16);
        this.setArguments(bb, cmd, args);
        this.setArguments(bb, this.smGet.getSpaceSeparatedKeys());
        bb.flip();
        this.setBuffer(bb);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Request in ascii protocol: " + new String(bb.array()).replace("\r\n", "\\r\\n"));
        }
    }

    @Override
    protected void wasCancelled() {
        this.getCallback().receivedStatus(GET_CANCELED);
    }

    @Override
    public Collection<String> getKeys() {
        return this.smGet.getKeyList();
    }

    private static enum ReadState {
        VALUE,
        MISSED_KEYS,
        TRIMMED_KEYS;

    }
}

