/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.OperationType;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.OperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;

abstract class BaseGetOpImpl
extends OperationImpl {
    private static final OperationStatus END = new OperationStatus(true, "END", StatusCode.SUCCESS);
    private static final String RN_STRING = "\r\n";
    private final String cmd;
    private final Collection<String> keys;
    private String currentKey = null;
    private long casValue = 0L;
    private int currentFlags = 0;
    private byte[] data = null;
    private int readOffset = 0;
    private byte lookingFor = 0;

    public BaseGetOpImpl(String c, OperationCallback cb, Collection<String> k) {
        super(cb);
        this.cmd = c;
        this.keys = k;
        this.setOperationType(OperationType.READ);
    }

    public final Collection<String> getKeys() {
        return this.keys;
    }

    @Override
    public final void handleLine(String line) {
        if (line.equals("END")) {
            this.getLogger().debug("Get complete!");
            this.getCallback().receivedStatus(END);
            this.transitionState(OperationState.COMPLETE);
            this.data = null;
        } else if (line.startsWith("VALUE ")) {
            this.getLogger().debug("Got line %s", line);
            String[] stuff = line.split(" ");
            assert (stuff[0].equals("VALUE"));
            this.currentKey = stuff[1];
            this.currentFlags = Integer.parseInt(stuff[2]);
            this.data = new byte[Integer.parseInt(stuff[3])];
            if (stuff.length > 4) {
                this.casValue = Long.parseLong(stuff[4]);
            }
            this.readOffset = 0;
            this.getLogger().debug("Set read type to data");
            this.setReadType(OperationReadType.DATA);
        } else assert (false) : "Unknown line type: " + line;
    }

    @Override
    public final void handleRead(ByteBuffer b) {
        assert (this.currentKey != null);
        assert (this.data != null);
        assert (this.readOffset <= this.data.length) : "readOffset is " + this.readOffset + " data.length is " + this.data.length;
        this.getLogger().debug("readOffset: %d, length: %d", this.readOffset, this.data.length);
        if (this.lookingFor == 0) {
            int toRead = this.data.length - this.readOffset;
            int available = b.remaining();
            toRead = Math.min(toRead, available);
            this.getLogger().debug("Reading %d bytes", toRead);
            b.get(this.data, this.readOffset, toRead);
            this.readOffset += toRead;
        }
        if (this.readOffset == this.data.length && this.lookingFor == 0) {
            try {
                GetOperation.Callback gcb = (GetOperation.Callback)this.getCallback();
                gcb.gotData(this.currentKey, this.currentFlags, this.data);
            }
            catch (ClassCastException e) {
                GetsOperation.Callback gcb = (GetsOperation.Callback)this.getCallback();
                gcb.gotData(this.currentKey, this.currentFlags, this.casValue, this.data);
            }
            this.lookingFor = (byte)13;
        }
        if (this.lookingFor != 0 && b.hasRemaining()) {
            do {
                byte tmp = b.get();
                assert (tmp == this.lookingFor) : "Expecting " + this.lookingFor + ", got " + (char)tmp;
                switch (this.lookingFor) {
                    case 13: {
                        this.lookingFor = (byte)10;
                        break;
                    }
                    case 10: {
                        this.lookingFor = 0;
                        break;
                    }
                    default: {
                        assert (false) : "Looking for unexpected char: " + (char)this.lookingFor;
                        {
                            break;
                        }
                    }
                }
            } while (this.lookingFor != 0 && b.hasRemaining());
            if (this.lookingFor == 0) {
                this.currentKey = null;
                this.data = null;
                this.readOffset = 0;
                this.currentFlags = 0;
                this.getLogger().debug("Setting read type back to line.");
                this.setReadType(OperationReadType.LINE);
            }
        }
    }

    @Override
    public final void initialize() {
        StringBuilder commandBuilder = new StringBuilder();
        String keysString = this.generateKeysString();
        if (this.cmd.equals("get") || this.cmd.equals("gets")) {
            commandBuilder.append(this.cmd);
            commandBuilder.append(' ');
            commandBuilder.append(keysString);
            commandBuilder.append(RN_STRING);
        } else {
            assert (this.cmd.equals("mget")) : "Unknown Command " + this.cmd;
            int lenKeys = keysString.getBytes().length;
            int numKeys = this.keys.size();
            commandBuilder.append(this.cmd);
            commandBuilder.append(' ');
            commandBuilder.append(String.valueOf(lenKeys));
            commandBuilder.append(' ');
            commandBuilder.append(String.valueOf(numKeys));
            commandBuilder.append(RN_STRING);
            commandBuilder.append(keysString);
            commandBuilder.append(RN_STRING);
        }
        byte[] commandLine = commandBuilder.toString().getBytes();
        int size = commandLine.length;
        ByteBuffer b = ByteBuffer.allocate(size);
        b.put(commandLine);
        b.flip();
        this.setBuffer(b);
    }

    private String generateKeysString() {
        StringBuilder keyString = new StringBuilder();
        Iterator<String> iterator = this.keys.iterator();
        while (true) {
            keyString.append(iterator.next());
            if (!iterator.hasNext()) break;
            keyString.append(' ');
        }
        return keyString.toString();
    }

    @Override
    protected final void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }
}

